/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import java.io.PrintWriter;
import java.io.StringWriter;

abstract class LocalAbstractInfo {
    protected static final String LIMEWIRE_VERSION = "1";
    protected String _limewireVersion;
    protected static final String JAVA_VERSION = "2";
    protected String _javaVersion;
    protected static final String OS = "3";
    protected String _os;
    protected static final String OS_VERSION = "4";
    protected String _osVersion;
    protected static final String ARCHITECTURE = "5";
    protected String _architecture;
    protected static final String FREE_MEMORY = "6";
    protected String _freeMemory;
    protected static final String TOTAL_MEMORY = "7";
    protected String _totalMemory;
    protected static final String BUG = "8";
    protected String _bug;
    protected static final String CURRENT_THREAD = "9";
    protected String _currentThread;
    protected static final String PROPS = "10";
    protected String _props;
    protected static final String UPTIME = "11";
    protected String _upTime;
    protected static final String CONNECTED = "12";
    protected String _connected;
    protected static final String UP_TO_UP = "13";
    protected String _upToUp;
    protected static final String UP_TO_LEAF = "14";
    protected String _upToLeaf;
    protected static final String LEAF_TO_UP = "15";
    protected String _leafToUp;
    protected static final String OLD_CONNECTIONS = "16";
    protected String _oldConnections;
    protected static final String ULTRAPEER = "17";
    protected String _ultrapeer;
    protected static final String LEAF = "18";
    protected String _leaf;
    protected static final String ACTIVE_UPLOADS = "19";
    protected String _activeUploads;
    protected static final String QUEUED_UPLOADS = "20";
    protected String _queuedUploads;
    protected static final String ACTIVE_DOWNLOADS = "21";
    protected String _activeDownloads;
    protected static final String HTTP_DOWNLOADERS = "22";
    protected String _httpDownloaders;
    protected static final String WAITING_DOWNLOADERS = "23";
    protected String _waitingDownloaders;
    protected static final String ACCEPTED_INCOMING = "24";
    protected String _acceptedIncoming;
    protected static final String SHARED_FILES = "25";
    protected String _sharedFiles;
    protected static final String OTHER_THREADS = "26";
    protected String _otherThreads;
    protected static final String DETAIL = "27";
    protected String _detail;
    protected static final String OTHER_BUG = "28";
    protected String _otherBug;
    protected static final String JAVA_VENDOR = "29";
    protected String _javaVendor;
    protected static final String THREAD_COUNT = "30";
    protected String _threadCount;
    protected static final String BUG_NAME = "31";
    protected String _bugName;
    protected static final String GUESS_CAPABLE = "32";
    protected String _guessCapable;

    LocalAbstractInfo() {
    }

    public String toBugReport() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("LimeWire version " + this._limewireVersion);
        pw.println("Java version " + this._javaVersion + " from " + this._javaVendor);
        pw.println(this._os + " v. " + this._osVersion + " on " + this._architecture);
        pw.println("Free/total memory: " + this._freeMemory + "/" + this._totalMemory);
        pw.println();
        pw.println(this._bug);
        pw.println();
        if (this._detail != null) {
            pw.println("Detail: " + this._detail);
            pw.println();
        }
        if (this._otherBug != null) {
            pw.println("Underlying Error:");
            pw.println(this._otherBug);
            pw.println();
        }
        pw.println("-- listing session information --");
        pw.println("Current thread: " + this._currentThread);
        pw.println("Active Threads: " + this._threadCount);
        this.append(pw, "Uptime", this._upTime);
        this.append(pw, "Is Connected", this._connected);
        this.append(pw, "Number of Ultrapeer -> Ultrapeer Connections", this._upToUp);
        this.append(pw, "Number of Ultrapeer -> Leaf Connections", this._upToLeaf);
        this.append(pw, "Number of Leaf -> Ultrapeer Connections", this._leafToUp);
        this.append(pw, "Number of Old Connections", this._oldConnections);
        this.append(pw, "Acting as Ultrapeer", this._ultrapeer);
        this.append(pw, "Acting as Shielded Leaf", this._leaf);
        this.append(pw, "Number of Active Uploads", this._activeUploads);
        this.append(pw, "Number of Queued Uploads", this._queuedUploads);
        this.append(pw, "Number of Active Managed Downloads", this._activeDownloads);
        this.append(pw, "Number of Active HTTP Downloaders", this._httpDownloaders);
        this.append(pw, "Number of Waiting Downloads", this._waitingDownloaders);
        this.append(pw, "Received incoming this session", this._acceptedIncoming);
        this.append(pw, "Number of Shared Files", this._sharedFiles);
        this.append(pw, "Guess Capable", this._guessCapable);
        pw.println();
        if (this._otherThreads != null) {
            pw.println("-- listing threads --");
            pw.println(this._otherThreads);
            pw.println();
        }
        pw.println(this._props);
        pw.println();
        pw.flush();
        return sw.toString();
    }

    private void append(PrintWriter pw, String k, String v) {
        if (v != null) {
            pw.println(k + ": " + v);
        }
    }

    public final String getParsedBug() {
        int colon = this._bug.indexOf(58);
        if (colon == -1) {
            return this._bug;
        }
        if (colon - 4 >= 0 && this._bug.substring(colon - 4, colon).equals("java")) {
            return this._bug;
        }
        int ntat = this._bug.indexOf("\n\tat", colon);
        if (ntat == -1) {
            return this._bug;
        }
        String parsedBug = this._bug.substring(0, colon) + this._bug.substring(ntat);
        return parsedBug;
    }

    public String toString() {
        return this._bugName;
    }
}

