/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.bugs.LocalAbstractInfo;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.settings.FileArraySetting;
import com.limegroup.gnutella.settings.FileSetting;
import com.limegroup.gnutella.settings.LimeProps;
import com.limegroup.gnutella.settings.Setting;
import com.limegroup.gnutella.settings.SettingsFactory;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.httpclient.NameValuePair;

public final class LocalClientInfo
extends LocalAbstractInfo {
    public LocalClientInfo(Throwable bug, Thread running, String detail) {
        SettingsFactory sf;
        this._limewireVersion = CommonUtils.getLimeWireVersion();
        this._javaVersion = CommonUtils.getJavaVersion();
        this._javaVendor = this.prop("java.vendor");
        this._os = CommonUtils.getOS();
        this._osVersion = this.prop("os.version");
        this._architecture = this.prop("os.arch");
        this._freeMemory = "" + Runtime.getRuntime().freeMemory();
        this._totalMemory = "" + Runtime.getRuntime().totalMemory();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        bug.printStackTrace(pw);
        pw.flush();
        this._bug = sw.toString();
        this._currentThread = running.getName();
        this._bugName = bug.getClass().getName();
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        File propsFile = new File(CommonUtils.getUserSettingsDir(), "limewire.props");
        Properties props = new Properties();
        SettingsFactory settingsFactory = sf = LimeProps.instance().getFactory();
        synchronized (settingsFactory) {
            Iterator it = sf.iterator();
            while (it.hasNext()) {
                Setting set = (Setting)it.next();
                if (set instanceof FileSetting || set instanceof FileArraySetting || set.isDefault()) continue;
                ((Hashtable)props).put(set.getKey(), set.getValueAsString());
            }
        }
        props.list(pw);
        pw.flush();
        this._props = sw.toString();
        if (GUIMediator.isConstructed() && RouterService.isStarted()) {
            this._upTime = GUIUtils.seconds2time((int)(RouterService.getCurrentUptime() / 1000L));
            this._connected = "" + RouterService.isConnected();
            this._upToUp = "" + RouterService.getNumUltrapeerToUltrapeerConnections();
            this._upToLeaf = "" + RouterService.getNumUltrapeerToLeafConnections();
            this._leafToUp = "" + RouterService.getNumLeafToUltrapeerConnections();
            this._oldConnections = "" + RouterService.getNumOldConnections();
            this._ultrapeer = "" + RouterService.isSupernode();
            this._leaf = "" + RouterService.isShieldedLeaf();
            this._activeUploads = "" + RouterService.getNumUploads();
            this._queuedUploads = "" + RouterService.getNumQueuedUploads();
            this._activeDownloads = "" + RouterService.getNumActiveDownloads();
            this._httpDownloaders = "" + RouterService.getNumIndividualDownloaders();
            this._waitingDownloaders = "" + RouterService.getNumWaitingDownloads();
            this._acceptedIncoming = "" + RouterService.acceptedIncomingConnection();
            this._sharedFiles = "" + RouterService.getNumSharedFiles();
            this._guessCapable = "" + RouterService.isGUESSCapable();
        }
        this._detail = detail;
        if (bug instanceof ExceptionInInitializerError) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            ExceptionInInitializerError err = (ExceptionInInitializerError)bug;
            if (err.getException() != null) {
                err.getException().printStackTrace(pw);
                pw.flush();
                this._otherBug = sw.toString();
            }
        }
        Thread[] allThreads = new Thread[Thread.activeCount()];
        int copied = Thread.enumerate(allThreads);
        this._threadCount = "" + copied;
        HashMap threads = new HashMap();
        int i = 0;
        while (i < copied) {
            String name = allThreads[i].getName();
            Object val = threads.get(name);
            if (val == null) {
                threads.put(name, new Integer(1));
            } else {
                int num = (Integer)val + 1;
                threads.put(name, new Integer(num));
            }
            ++i;
        }
        sw = new StringWriter();
        pw = new PrintWriter(sw);
        Iterator i2 = threads.entrySet().iterator();
        while (i2.hasNext()) {
            Map.Entry info = (Map.Entry)i2.next();
            pw.println(info.getKey() + ": " + info.getValue());
        }
        pw.flush();
        this._otherThreads = sw.toString();
    }

    private final String prop(String name) {
        String value = System.getProperty(name);
        if (value == null) {
            return "?";
        }
        return value;
    }

    public final NameValuePair[] getPostRequestParams() {
        LinkedList params = new LinkedList();
        this.append(params, "1", this._limewireVersion);
        this.append(params, "2", this._javaVersion);
        this.append(params, "3", this._os);
        this.append(params, "4", this._osVersion);
        this.append(params, "5", this._architecture);
        this.append(params, "6", this._freeMemory);
        this.append(params, "7", this._totalMemory);
        this.append(params, "8", this._bug);
        this.append(params, "9", this._currentThread);
        this.append(params, "10", this._props);
        this.append(params, "11", this._upTime);
        this.append(params, "12", this._connected);
        this.append(params, "13", this._upToUp);
        this.append(params, "14", this._upToLeaf);
        this.append(params, "15", this._leafToUp);
        this.append(params, "16", this._oldConnections);
        this.append(params, "17", this._ultrapeer);
        this.append(params, "18", this._leaf);
        this.append(params, "19", this._activeUploads);
        this.append(params, "20", this._queuedUploads);
        this.append(params, "21", this._activeDownloads);
        this.append(params, "22", this._httpDownloaders);
        this.append(params, "23", this._waitingDownloaders);
        this.append(params, "24", this._acceptedIncoming);
        this.append(params, "25", this._sharedFiles);
        this.append(params, "26", this._otherThreads);
        this.append(params, "27", this._detail);
        this.append(params, "28", this._otherBug);
        this.append(params, "29", this._javaVendor);
        this.append(params, "30", this._threadCount);
        this.append(params, "31", this._bugName);
        this.append(params, "32", this._guessCapable);
        return (NameValuePair[])params.toArray(new NameValuePair[params.size()]);
    }

    private final void append(List l, String k, String v) {
        if (v != null) {
            l.add(new NameValuePair(k, v));
        }
    }
}

