/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.bugs;

import com.limegroup.gnutella.bugs.LocalServletInfo;
import com.limegroup.gnutella.bugs.RemoteAbstractInfo;
import com.limegroup.gnutella.util.FixedsizeForgetfulHashMap;
import java.io.IOException;
import java.net.URLEncoder;

public final class RemoteServletInfo
extends RemoteAbstractInfo {
    private static final RemoteServletInfo INSTANCE = new RemoteServletInfo();
    private final FixedsizeForgetfulHashMap BUGS = new FixedsizeForgetfulHashMap(100);
    private static final int TOTAL_BUGS = 100;
    private static final int BUG_CUTOFF = 3;
    private static final String WAIT_TIME = "86400000";
    private static final String ANY_TIME = "600000";
    private static final String SHUT_UP = "1471228928";
    private static final String OLD_RESPONSE = "1=1471228928&2=1471228928";
    private static final int MAJOR_VERSION = 3;
    private static final int MINOR_VERSION = 7;
    private static final int SERVICE_VERSION = 0;

    public static RemoteServletInfo instance() {
        return INSTANCE;
    }

    public String getURLEncodedString(LocalServletInfo localInfo) throws IOException {
        String nextThisBugTime;
        String nextAnyBugTime;
        String version = localInfo.getLimeWireVersion();
        String os = localInfo.getOS();
        if (version == null || version.equals("")) {
            throw new IOException("invalid version");
        }
        if (os == null || os.equals("")) {
            throw new IOException("invalid operating system");
        }
        if (RemoteServletInfo.isOldClient(version)) {
            return OLD_RESPONSE;
        }
        RemoteServletInfo remoteServletInfo = this;
        synchronized (remoteServletInfo) {
            String bug = localInfo.getParsedBug();
            Integer count = (Integer)this.BUGS.get(bug);
            nextAnyBugTime = ANY_TIME;
            if (count == null) {
                this.BUGS.put(bug, new Integer(1));
                nextThisBugTime = "0";
            } else {
                int newCount = count + 1;
                this.BUGS.put(bug, new Integer(newCount));
                nextThisBugTime = newCount >= 3 ? WAIT_TIME : "0";
            }
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "1", nextThisBugTime);
        this.append(sb, "2", nextAnyBugTime);
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private final void append(StringBuffer sb, String k, String v) {
        if (v != null) {
            sb.append(k);
            sb.append("=");
            sb.append(URLEncoder.encode(v));
            sb.append("&");
        }
    }

    public static final boolean isOldClient(String vers) {
        int service;
        int minor;
        int major;
        if (vers.equals("@version@")) {
            return false;
        }
        int dot1 = vers.indexOf(".");
        if (dot1 == -1) {
            return true;
        }
        int dot2 = vers.indexOf(".", dot1 + 1);
        if (dot2 == -1) {
            return true;
        }
        try {
            major = Integer.parseInt(vers.substring(0, dot1));
        }
        catch (NumberFormatException nfe) {
            return true;
        }
        try {
            minor = Integer.parseInt(vers.substring(dot1 + 1, dot2));
        }
        catch (NumberFormatException nfe) {
            return true;
        }
        try {
            int q = dot2 + 1;
            while (q < vers.length() && Character.isDigit(vers.charAt(q))) {
                ++q;
            }
            service = Integer.parseInt(vers.substring(dot2 + 1, q));
        }
        catch (NumberFormatException nfe) {
            return true;
        }
        if (major < 3) {
            return true;
        }
        if (major == 3) {
            if (minor < 7) {
                return true;
            }
            if (minor == 7 && service < 0) {
                return true;
            }
        }
        return false;
    }
}

