/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.altlocs.AlternateLocationCollection;
import com.limegroup.gnutella.altlocs.AlternateLocationCollector;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HttpClientManager;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.HeadMethod;

final class HeadRequester
implements Runnable {
    private final Set HOSTS;
    private final URN RESOURCE_NAME;
    private final AlternateLocationCollector COLLECTOR;
    private final AlternateLocationCollection TOTAL_ALTS;

    public HeadRequester(Set hosts, URN resourceName, AlternateLocationCollector collector, AlternateLocationCollection totalAlts) {
        this.HOSTS = hosts;
        this.RESOURCE_NAME = resourceName;
        this.COLLECTOR = collector;
        this.TOTAL_ALTS = totalAlts;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            Iterator iter = this.HOSTS.iterator();
            while (true) {
                Object var12_14;
                HeadMethod head;
                block17: {
                    block16: {
                        block15: {
                            block14: {
                                URN urn;
                                if (!iter.hasNext()) {
                                    return;
                                }
                                RemoteFileDesc rfd = (RemoteFileDesc)iter.next();
                                if (QueryReply.isFirewalledQuality(rfd.getQuality()) || (urn = rfd.getSHA1Urn()) == null || !urn.equals(this.RESOURCE_NAME)) continue;
                                URL url = rfd.getUrl();
                                String connectTo = url.toExternalForm();
                                head = new HeadMethod(connectTo);
                                head.addRequestHeader("User-Agent", CommonUtils.getHttpServer());
                                head.addRequestHeader("Cache-Control", "no-cache");
                                head.addRequestHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN.httpStringValue(), this.RESOURCE_NAME.httpStringValue());
                                head.addRequestHeader(HTTPHeaderName.ALT_LOCATION.httpStringValue(), this.TOTAL_ALTS.httpStringValue());
                                head.addRequestHeader(HTTPHeaderName.CONNECTION.httpStringValue(), "close");
                                head.setFollowRedirects(false);
                                HttpClient client = HttpClientManager.getNewClient();
                                try {
                                    try {
                                        block13: {
                                            client.executeMethod(head);
                                            String contentUrn = HeadRequester.getHeader(head, HTTPHeaderName.GNUTELLA_CONTENT_URN);
                                            if (contentUrn == null) {
                                                var12_14 = null;
                                                if (head == null) continue;
                                                head.releaseConnection();
                                                continue;
                                            }
                                            try {
                                                URN reportedUrn = URN.createSHA1Urn(contentUrn);
                                                if (reportedUrn.equals(this.RESOURCE_NAME)) break block13;
                                                break block14;
                                            }
                                            catch (IOException e) {
                                                var12_14 = null;
                                                if (head == null) continue;
                                                head.releaseConnection();
                                            }
                                            continue;
                                        }
                                        String altLocs = HeadRequester.getHeader(head, HTTPHeaderName.ALT_LOCATION);
                                        if (altLocs == null) {
                                            break block15;
                                        }
                                        AlternateLocationCollection alc = AlternateLocationCollection.createCollectionFromHttpValue(altLocs);
                                        if (alc == null) {
                                            break block16;
                                        }
                                        if (!alc.getSHA1Urn().equals(this.COLLECTOR.getSHA1Urn())) break block17;
                                        this.COLLECTOR.addAll(alc);
                                        break block17;
                                    }
                                    catch (IOException e) {
                                        var12_14 = null;
                                        if (head == null) continue;
                                        head.releaseConnection();
                                        continue;
                                    }
                                }
                                catch (Throwable throwable) {
                                    var12_14 = null;
                                    if (head == null) throw throwable;
                                    head.releaseConnection();
                                    throw throwable;
                                }
                            }
                            var12_14 = null;
                            if (head == null) continue;
                            head.releaseConnection();
                        }
                        var12_14 = null;
                        if (head == null) continue;
                        head.releaseConnection();
                        continue;
                    }
                    var12_14 = null;
                    if (head == null) continue;
                    head.releaseConnection();
                    continue;
                }
                var12_14 = null;
                if (head == null) continue;
                head.releaseConnection();
            }
        }
        catch (Throwable e) {
            ErrorService.error(e);
        }
    }

    private static String getHeader(HttpMethod methid, HTTPHeaderName name) {
        Header header = methid.getResponseHeader(name.httpStringValue());
        if (header == null) {
            return null;
        }
        return header.getValue();
    }
}

