/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.downloader.IncompleteFileManager;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.UnsupportedOperationException;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

class RemoteFileDescGrouper
implements Serializable {
    private List buckets = new ArrayList();
    private List incompletes = new ArrayList();
    private URN[] sha1s = new URN[0];
    private IncompleteFileManager incompleteFileManager;
    private static final int DECENT_QUALITY = 2;
    private static final int MAX_BUCKET_SIZE = 500;
    static boolean DEBUG = false;

    RemoteFileDescGrouper(RemoteFileDesc[] rfds, IncompleteFileManager incompleteFileManager) {
        this.incompleteFileManager = incompleteFileManager;
        int i = 0;
        while (i < rfds.length) {
            this.add(rfds[i], false);
            ++i;
        }
        this.repOk();
        Object[] pairs = new FileTuple[this.buckets.size()];
        int i2 = 0;
        while (i2 < this.buckets.size()) {
            File incompleteFile = (File)this.incompletes.get(i2);
            List files = (List)this.buckets.get(i2);
            int size = ((RemoteFileDesc)files.get(0)).getSize() - incompleteFileManager.getBlockSize(incompleteFile);
            int bandwidth = 1;
            Iterator iter2 = files.iterator();
            while (iter2.hasNext()) {
                RemoteFileDesc rfd = (RemoteFileDesc)iter2.next();
                if (rfd.getQuality() < 2) continue;
                bandwidth += RemoteFileDescGrouper.normalize(rfd.getSpeed());
            }
            float time = (float)size / (float)bandwidth;
            pairs[i2] = new FileTuple(files, incompleteFile, this.sha1s[i2], time);
            ++i2;
        }
        Arrays.sort(pairs);
        int i3 = 0;
        while (i3 < pairs.length) {
            Object pair = pairs[i3];
            this.buckets.set(i3, ((FileTuple)pair).bucket);
            this.incompletes.set(i3, ((FileTuple)pair).incompleteFile);
            this.sha1s[i3] = ((FileTuple)pair).sha1;
            ++i3;
        }
        this.repOk();
    }

    private static int normalize(int speed) {
        if (speed < 56) {
            return 3;
        }
        if (speed < 350) {
            return 30;
        }
        if (speed < 1000) {
            return 40;
        }
        return 50;
    }

    synchronized int add(RemoteFileDesc rfd, boolean checkExisting) {
        this.repOk();
        File incompleteFile = null;
        try {
            incompleteFile = this.incompleteFileManager.getFile(rfd);
        }
        catch (IOException ioe) {
            return -1;
        }
        int n = this.buckets.size();
        Assert.that(this.incompletes.size() == n, "Length of buckets and incompletes different: " + n + "!=" + this.incompletes.size());
        int i = 0;
        while (i < n) {
            File otherIncompleteFile = (File)this.incompletes.get(i);
            if (otherIncompleteFile.equals(incompleteFile) && RemoteFileDescGrouper.hashEquals(rfd.getSHA1Urn(), this.sha1s[i])) {
                if (this.sha1s[i] == null && rfd.getSHA1Urn() != null) {
                    this.sha1s[i] = rfd.getSHA1Urn();
                }
                List bucket = (List)this.buckets.get(i);
                if (checkExisting && bucket.contains(rfd)) {
                    return -1;
                }
                if (bucket.size() > 500) {
                    return -1;
                }
                bucket.add(rfd);
                this.repOk();
                return 1;
            }
            ++i;
        }
        ArrayList bucket = new ArrayList();
        bucket.add(rfd);
        this.buckets.add(bucket);
        this.incompletes.add(incompleteFile);
        int p = this.incompletes.size();
        URN[] newArray = new URN[p];
        System.arraycopy(this.sha1s, 0, newArray, 0, this.sha1s.length);
        newArray[p - 1] = rfd.getSHA1Urn();
        this.sha1s = newArray;
        this.repOk();
        return 0;
    }

    synchronized List getURNs() {
        return Collections.unmodifiableList(Arrays.asList(this.sha1s));
    }

    synchronized URN getURNForBucket(int n) {
        if (n < 0 || n >= this.buckets.size()) {
            throw new IllegalArgumentException("index: " + n + ", size: " + this.buckets.size());
        }
        return this.sha1s[n];
    }

    synchronized URN getBestURN() {
        if (this.sha1s.length < 1) {
            return null;
        }
        int index = 0;
        int numBuckets = this.buckets.size();
        int i = 0;
        int maxNum = 0;
        while (i < numBuckets) {
            List currBucket = (List)this.buckets.get(i);
            if (currBucket.size() > maxNum) {
                maxNum = currBucket.size();
                index = i;
            }
            ++i;
        }
        if (index < this.sha1s.length) {
            return this.sha1s[index];
        }
        return null;
    }

    private static boolean hashEquals(URN urn1, URN urn2) {
        if (urn1 == null || urn2 == null) {
            return true;
        }
        return urn1.equals(urn2);
    }

    Iterator buckets() {
        return new BucketIterator();
    }

    protected void repOk() {
        if (!DEBUG) {
            return;
        }
        Assert.that(this.buckets.size() == this.incompletes.size());
        Assert.that(this.buckets.size() == this.sha1s.length);
        int i = 0;
        while (i < this.buckets.size()) {
            List bucket = (List)this.buckets.get(i);
            File tmp1 = (File)this.incompletes.get(i);
            int j = 0;
            while (j < bucket.size()) {
                try {
                    File tmp2 = this.incompleteFileManager.getFile((RemoteFileDesc)bucket.get(j));
                    Assert.that(tmp1.equals(tmp2));
                }
                catch (IOException ioe) {
                    Assert.that(false, ioe.getMessage());
                }
                ++j;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.buckets.size()) {
            List bucket = (List)this.buckets.get(i2);
            URN urn1 = this.sha1s[i2];
            int j = 0;
            while (j < bucket.size()) {
                URN urn2 = ((RemoteFileDesc)bucket.get(j)).getSHA1Urn();
                if (urn2 != null) {
                    Assert.that(urn1 != null);
                    Assert.that(urn1.equals(urn2));
                }
                ++j;
            }
            ++i2;
        }
    }

    private class BucketIterator
    implements Iterator {
        int i = 0;

        private BucketIterator() {
        }

        public boolean hasNext() {
            RemoteFileDescGrouper remoteFileDescGrouper = RemoteFileDescGrouper.this;
            synchronized (remoteFileDescGrouper) {
                boolean bl = this.i < RemoteFileDescGrouper.this.buckets.size();
                return bl;
            }
        }

        public Object next() {
            RemoteFileDescGrouper remoteFileDescGrouper = RemoteFileDescGrouper.this;
            synchronized (remoteFileDescGrouper) {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object object = RemoteFileDescGrouper.this.buckets.get(this.i++);
                return object;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class FileTuple
    implements Comparable {
        List bucket;
        File incompleteFile;
        URN sha1;
        float time;

        public FileTuple(List bucket, File incompleteFile, URN sha1, float time) {
            this.bucket = bucket;
            this.incompleteFile = incompleteFile;
            this.sha1 = sha1;
            this.time = time;
        }

        public int compareTo(Object o) {
            float diff = this.time - ((FileTuple)o).time;
            if (diff < 0.0f) {
                return -1;
            }
            if (diff > 0.0f) {
                return 1;
            }
            return 0;
        }
    }
}

