/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.guess;

import com.limegroup.gnutella.ByteOrder;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Random;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import org.logi.crypto.Crypto;
import org.logi.crypto.keys.DESKey;

public final class QueryKey {
    private static SecretKey SECRET_KEY = null;
    private static SecretPad SECRET_PAD = null;
    public final int MIN_QK_SIZE_IN_BYTES = 4;
    public final int MAX_QK_SIZE_IN_BYTES = 16;
    private byte[] _queryKey;

    private QueryKey(byte[] key) throws IllegalArgumentException {
        if (key.length < 4 || key.length > 16) {
            throw new IllegalArgumentException();
        }
        this._queryKey = new byte[key.length];
        System.arraycopy(key, 0, this._queryKey, 0, key.length);
    }

    public void prepareForNetwork() {
        int i = 0;
        while (i < this._queryKey.length) {
            if (this._queryKey[i] == 28) {
                this._queryKey[i] = -6;
            }
            ++i;
        }
    }

    public static SecretKey generateSecretKey() {
        return new SecretKey();
    }

    public static SecretPad generateSecretPad() {
        return new SecretPad();
    }

    public boolean equals(Object o) {
        if (!(o instanceof QueryKey)) {
            return false;
        }
        QueryKey other = (QueryKey)o;
        return Arrays.equals(this._queryKey, other._queryKey);
    }

    public int hashCode() {
        int retInt = 0;
        int i = 0;
        while (i < 4) {
            int index = this._queryKey[i] % this._queryKey.length;
            if (index < 0) {
                index *= -1;
            }
            retInt += this._queryKey[index] * 7;
            ++i;
        }
        return retInt;
    }

    public void write(OutputStream out) throws IOException {
        out.write(this._queryKey);
    }

    public String toString() {
        return "{Query Key: " + new BigInteger(this._queryKey) + "}";
    }

    public static QueryKey getQueryKey(byte[] networkQK, boolean prepareForNet) throws IllegalArgumentException {
        QueryKey retQK = new QueryKey(networkQK);
        if (prepareForNet) {
            retQK.prepareForNetwork();
        }
        return retQK;
    }

    public static QueryKey getQueryKey(InetAddress ip, int port) {
        return QueryKey.getQueryKey(ip, port, SECRET_KEY, SECRET_PAD);
    }

    /*
     * Unable to fully structure code
     */
    public static QueryKey getQueryKey(InetAddress ip, int port, SecretKey secretKey, SecretPad secretPad) {
        toEncrypt = new byte[8];
        ipBytes = ip.getAddress();
        shortPort = (short)port;
        portBytes = new byte[2];
        ByteOrder.short2leb(shortPort, portBytes, 0);
        first = SecretPad.access$200(secretPad)[0] % 8;
        if (first < 0) {
            first *= -1;
        }
        if ((second = SecretPad.access$200(secretPad)[1] % 8) < 0) {
            second *= -1;
        }
        if (second == first) {
            second = first == 0 ? 1 : first - 1;
        }
        toEncrypt[first] = SecretPad.access$200(secretPad)[0];
        toEncrypt[second] = SecretPad.access$200(secretPad)[1];
        j = 0;
        i = 0;
        ** GOTO lbl23
        {
            ++j;
            do {
                if (j == first || j == second) continue block3;
                toEncrypt[j++] = ipBytes[i];
                ++i;
lbl23:
                // 2 sources

            } while (i < 4);
        }
        i = 0;
        ** GOTO lbl31
        {
            ++j;
            do {
                if (j == first || j == second) continue block5;
                toEncrypt[j++] = portBytes[i];
                ++i;
lbl31:
                // 2 sources

            } while (i < 2);
        }
        encrypted = new byte[8];
        var14_14 = secretKey;
        synchronized (var14_14) {
            SecretKey.access$300(secretKey).encrypt(toEncrypt, 0, encrypted, 0);
        }
        return QueryKey.getQueryKey(encrypted, true);
    }

    static {
        Crypto.initRandom();
        SECRET_KEY = new SecretKey();
        SECRET_PAD = new SecretPad();
    }

    public static class SecretPad {
        private byte[] _pad = new byte[2];

        private SecretPad() {
            new Random().nextBytes(this._pad);
        }

        static /* synthetic */ byte[] access$200(SecretPad x0) {
            return x0._pad;
        }
    }

    public static class SecretKey {
        private DESKey _DESKey = new DESKey();

        private SecretKey() {
        }

        static /* synthetic */ DESKey access$300(SecretKey x0) {
            return x0._DESKey;
        }
    }
}

