/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.ScrollingTextPane;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

final class AboutWindow {
    private final JDialog DIALOG = new JDialog();
    private final Dimension DIALOG_DIMENSION = new Dimension(450, 400);
    private final ScrollingTextPane SCROLLING_PANE;
    private final JCheckBox SCROLL_CHECK_BOX = new JCheckBox(GUIMediator.getStringResource("ABOUT_SCROLL_CHECK_BOX_LABEL"));

    AboutWindow() {
        if (!CommonUtils.isMacOSX() || !CommonUtils.isJava14OrLater()) {
            this.DIALOG.setModal(true);
        }
        this.DIALOG.setResizable(false);
        this.DIALOG.setTitle(GUIMediator.getStringResource("ABOUT_TITLE"));
        URL aboutUrl = GUIMediator.getURLResource(GUIMediator.getStringResource("ABOUT_FILE_NAME"));
        if (aboutUrl == null) {
            aboutUrl = GUIMediator.getURLResource("about.html");
        }
        this.SCROLLING_PANE = new ScrollingTextPane(aboutUrl);
        this.SCROLLING_PANE.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent he) {
                if (he.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                URL url = he.getURL();
                if (url == null) {
                    return;
                }
                try {
                    GUIMediator.openURL(url.toExternalForm());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.SCROLL_CHECK_BOX.setSelected(true);
        this.SCROLL_CHECK_BOX.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                        AboutWindow.this.SCROLLING_PANE.startScroll();
                    } else {
                        AboutWindow.this.SCROLLING_PANE.stopScroll();
                    }
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        });
        BoxPanel topPanel = new BoxPanel(1);
        Border border = BorderFactory.createEmptyBorder(6, 6, 6, 6);
        topPanel.setBorder(border);
        topPanel.add(GUIMediator.getVerticalSeparator());
        LogoPanel logo = new LogoPanel();
        logo.setSearching(true);
        topPanel.add(logo);
        topPanel.add(Box.createVerticalStrut(17));
        String labelStart = GUIMediator.getStringResource("ABOUT_LABEL_START");
        String version = CommonUtils.getLimeWireVersion();
        String labelAddress = GUIMediator.getStringResource("ABOUT_LABEL_ADDRESS");
        String[] strs = new String[]{labelStart + " " + version, labelAddress};
        MultiLineLabel label = new MultiLineLabel(strs);
        label.setFont(new Font("Sans Serif", 0, 11));
        label.setForeground(Color.black);
        Dimension dim = new Dimension(this.DIALOG_DIMENSION.width - 12, 40);
        label.setPreferredSize(dim);
        label.setMaximumSize(dim);
        BoxPanel labelPanel = new BoxPanel(0);
        labelPanel.add(Box.createRigidArea(new Dimension(this.DIALOG_DIMENSION.width / 2 - ((Component)label).getFontMetrics(label.getFont()).stringWidth(labelAddress) / 2, 0)));
        labelPanel.add(label);
        topPanel.add(labelPanel);
        topPanel.add(this.SCROLLING_PANE);
        ((Component)this.DIALOG).setSize(this.DIALOG_DIMENSION);
        ActionListener closeDialogListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ((Component)AboutWindow.this.DIALOG).setVisible(false);
                    AboutWindow.this.SCROLLING_PANE.stopScroll();
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        JButton button = new JButton(GUIMediator.getStringResource("ABOUT_BUTTON_LABEL"));
        button.setToolTipText(GUIMediator.getStringResource("ABOUT_BUTTON_TIP"));
        button.addActionListener(closeDialogListener);
        BoxPanel buttonPanel = new BoxPanel(0);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.SCROLL_CHECK_BOX);
        buttonPanel.add(GUIMediator.getHorizontalSeparator());
        buttonPanel.add(button);
        buttonPanel.add(Box.createHorizontalGlue());
        Container CONTENT_PANE = this.DIALOG.getContentPane();
        CONTENT_PANE.setLayout(new BoxLayout(CONTENT_PANE, 1));
        CONTENT_PANE.add(topPanel);
        CONTENT_PANE.add(GUIMediator.getVerticalSeparator());
        CONTENT_PANE.add(buttonPanel);
        CONTENT_PANE.add(Box.createVerticalStrut(6));
    }

    void showDialog() {
        if (GUIMediator.isAppVisible()) {
            this.DIALOG.setLocationRelativeTo(GUIMediator.getAppFrame());
        } else {
            ((Component)this.DIALOG).setLocation(GUIMediator.getScreenCenterPoint(this.DIALOG));
        }
        if (this.SCROLL_CHECK_BOX.isSelected()) {
            ActionListener startTimerListener = new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    try {
                        if (AboutWindow.this.SCROLL_CHECK_BOX.isSelected()) {
                            AboutWindow.this.SCROLLING_PANE.startScroll();
                        }
                    }
                    catch (Throwable t) {
                        ErrorService.error(t);
                    }
                }
            };
            Timer startTimer = new Timer(10000, startTimerListener);
            startTimer.setRepeats(false);
            startTimer.start();
        }
        ((Component)this.DIALOG).setVisible(true);
    }
}

