/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;

public class CocoaApplicationEventHandler
implements ApplicationListener {
    private final Application _app = new Application();
    private static CocoaApplicationEventHandler INSTANCE;

    public static CocoaApplicationEventHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new CocoaApplicationEventHandler();
        }
        return INSTANCE;
    }

    private CocoaApplicationEventHandler() {
    }

    public void register() {
        this._app.addApplicationListener((ApplicationListener)this);
    }

    public void enablePreferences() {
        this._app.setEnabledPreferencesMenu(true);
    }

    public void handleAbout(ApplicationEvent event) {
        event.setHandled(true);
        GUIMediator.showAboutWindow();
    }

    public void handleOpenApplication(ApplicationEvent event) {
        event.setHandled(true);
    }

    public void handleReOpenApplication(ApplicationEvent event) {
        event.setHandled(true);
        GUIMediator.handleReopen();
    }

    public void handleOpenFile(ApplicationEvent event) {
        event.setHandled(true);
        if (event.getFilename().endsWith("limestart")) {
            Initializer.setStartup();
        } else {
            PackagedMediaFileLauncher.launchFile(event.getFilename(), false);
        }
    }

    public void handlePreferences(ApplicationEvent event) {
        event.setHandled(true);
        GUIMediator.instance().setOptionsVisible(true);
    }

    public void handlePrintFile(ApplicationEvent event) {
    }

    public void handleQuit(ApplicationEvent event) {
        event.setHandled(true);
        GUIMediator.shutdown();
    }

    public void handlePrintDocument(ApplicationEvent ev) {
        ev.setHandled(true);
    }

    public void handleOpenDocument(ApplicationEvent ev) {
        ev.setHandled(true);
    }
}

