/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;

final class Finalizer {
    private static final List FINALIZERS = new ArrayList();
    private static boolean _wasConnected;
    private static boolean _shutdownImminent;
    private static boolean _uploadsComplete;
    private static boolean _downloadsComplete;

    private Finalizer() {
    }

    static boolean isShutdownImminent() {
        return _shutdownImminent;
    }

    static void shutdown() {
        try {
            NotifyUserProxy.instance().removeNotify();
            GUIMediator.applyWindowSettings();
            RouterService router = GUIMediator.instance().getRouter();
            if (router != null) {
                RouterService.shutdown();
            } else {
                SettingsHandler.save();
            }
            int i = 0;
            while (i < FINALIZERS.size()) {
                ((FinalizeListener)FINALIZERS.get(i)).doFinalize();
                ++i;
            }
            System.exit(0);
        }
        catch (Throwable e) {
            GUIMediator.showInternalError(e, "Finalizer");
            System.exit(0);
        }
    }

    static void shutdownAfterTransfers() {
        if (Finalizer.isShutdownImminent()) {
            return;
        }
        _shutdownImminent = true;
        _wasConnected = RouterService.isConnected();
        RouterService.setIsShuttingDown(true);
        if (_wasConnected) {
            RouterService.disconnect();
        }
        if (Finalizer.transfersComplete()) {
            GUIMediator.shutdown();
        }
    }

    public static void cancelShutdown() {
        _shutdownImminent = false;
        _uploadsComplete = false;
        _downloadsComplete = false;
        if (_wasConnected) {
            RouterService.connect();
        }
        RouterService.setIsShuttingDown(false);
    }

    static void setDownloadsComplete() {
        _downloadsComplete = true;
        Finalizer.checkForShutdown();
    }

    static void setUploadsComplete() {
        _uploadsComplete = true;
        Finalizer.checkForShutdown();
    }

    private static boolean transfersComplete() {
        RouterService router = GUIMediator.instance().getRouter();
        if (router == null) {
            return true;
        }
        if (RouterService.getNumDownloads() == 0) {
            _downloadsComplete = true;
        }
        if (RouterService.getNumUploads() == 0) {
            _uploadsComplete = true;
        }
        return _uploadsComplete & _downloadsComplete;
    }

    private static void checkForShutdown() {
        if (_shutdownImminent && _uploadsComplete && _downloadsComplete) {
            GUIMediator.shutdown();
        }
    }

    static void addFinalizeListener(FinalizeListener fin) {
        FINALIZERS.add(fin);
    }
}

