/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.FileChooserUI;

public class IconManager {
    private static IconManager INSTANCE = new IconManager();
    private final FileView VIEW;
    private final Map EXTENSIONS = new HashMap();
    private final Icon NULL = new ImageIcon();
    private final boolean REQUIRES_FILE;

    public static IconManager instance() {
        return INSTANCE;
    }

    private IconManager() {
        FileView view = null;
        boolean requiresFile = false;
        if (CommonUtils.isMacOSX() || CommonUtils.isWindows() && CommonUtils.isJava14OrLater()) {
            requiresFile = true;
            view = this.getNativeFileView();
        }
        if (view == null) {
            requiresFile = false;
            view = new MediaFileView();
        } else {
            requiresFile = true;
            view = new DelegateFileView(view);
        }
        this.VIEW = view;
        this.REQUIRES_FILE = requiresFile;
        if (!(view instanceof MediaFileView)) {
            this.preload();
        }
    }

    private FileView getNativeFileView() {
        JFileChooser chooser = null;
        int i = 0;
        while (i < 10) {
            try {
                chooser = new JFileChooser(){
                    {
                        FileChooserUI ui = (FileChooserUI)ResourceManager.getNativeUI(this);
                        this.setUI(ui);
                        this.setFileView(ui.getFileView(this));
                    }
                };
                break;
            }
            catch (NullPointerException nullPointerException) {
                ++i;
            }
        }
        if (chooser == null) {
            return null;
        }
        return chooser.getFileView();
    }

    public Icon getIconForFile(File f) {
        if (f == null) {
            return null;
        }
        if (this.REQUIRES_FILE && f.exists()) {
            return this.VIEW.getIcon(f);
        }
        String extension = FileUtils.getFileExtension(f);
        if (extension != null) {
            return this.getIconForExtension(extension);
        }
        return null;
    }

    public Icon getIconForExtension(String ext) {
        if (!this.REQUIRES_FILE) {
            return this.VIEW.getIcon(new File("a." + ext));
        }
        Icon icon = (Icon)this.EXTENSIONS.get(ext = ext.toLowerCase());
        if (icon != null) {
            if (icon != this.NULL) {
                return icon;
            }
            return null;
        }
        File dir = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        File tmp = new File(dir, ".LimeWireIconFinder." + ext);
        if (tmp.exists()) {
            icon = this.VIEW.getIcon(tmp);
        } else {
            try {
                FileUtils.touch(tmp);
                icon = this.VIEW.getIcon(tmp);
                if (icon == null) {
                    icon = this.NULL;
                }
            }
            catch (IOException fnfe) {
                icon = this.NULL;
            }
        }
        tmp.delete();
        this.EXTENSIONS.put(ext, icon);
        return icon;
    }

    private void preload() {
        ProcessingQueue queue = new ProcessingQueue("IconLoader");
        MediaType[] types = MediaType.getDefaultMediaTypes();
        int i = 0;
        while (i < types.length) {
            Set exts = types[i].getExtensions();
            Iterator j = exts.iterator();
            while (j.hasNext()) {
                final String next = (String)j.next();
                queue.add(new Runnable(){

                    public void run() {
                        try {
                            SwingUtilities.invokeAndWait(new Runnable(this){
                                private final /* synthetic */ 2 this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void run() {
                                    2.access$200(this.this$1).getIconForExtension(2.access$100(this.this$1));
                                }
                            });
                        }
                        catch (InterruptedException ignored) {
                        }
                        catch (InvocationTargetException ite) {
                            Throwable target = ite.getTargetException();
                            if (target instanceof RuntimeException) {
                                throw (RuntimeException)target;
                            }
                            ErrorService.error(target);
                        }
                    }

                    static /* synthetic */ String access$100(2 x0) {
                        return x0.next;
                    }

                    static /* synthetic */ IconManager access$200(2 x0) {
                        return x0.IconManager.this;
                    }
                });
            }
            ++i;
        }
    }

    private static class NullFileView
    extends FileView {
        private NullFileView() {
        }

        public String getDescription(File f) {
            return null;
        }

        public Icon getIcon(File f) {
            return null;
        }

        public String getName(File f) {
            return null;
        }

        public String getTypeDescription(File f) {
            return null;
        }

        public Boolean isTraversable(File f) {
            return Boolean.FALSE;
        }
    }

    private static class DelegateFileView
    extends FileView {
        private final FileView DELEGATE;

        DelegateFileView(FileView real) {
            this.DELEGATE = real;
        }

        public Icon getIcon(File f) {
            try {
                return this.DELEGATE.getIcon(f);
            }
            catch (NullPointerException npe) {
                return null;
            }
        }

        public String getDescription(File f) {
            return this.DELEGATE.getDescription(f);
        }

        public String getName(File f) {
            return this.DELEGATE.getName(f);
        }

        public String getTypeDescription(File f) {
            return this.DELEGATE.getTypeDescription(f);
        }

        public Boolean isTraversable(File f) {
            return this.DELEGATE.isTraversable(f);
        }
    }

    private static class MediaFileView
    extends FileView {
        private MediaFileView() {
        }

        public Icon getIcon(File f) {
            String ext = FileUtils.getFileExtension(f);
            NamedMediaType nmt = null;
            if (ext != null) {
                nmt = NamedMediaType.getFromExtension(ext);
            }
            if (nmt == null) {
                nmt = NamedMediaType.getFromDescription("*");
            }
            return nmt.getIcon();
        }

        public String getDescription(File f) {
            return null;
        }

        public String getName(File f) {
            return null;
        }

        public String getTypeDescription(File f) {
            return null;
        }

        public Boolean isTraversable(File f) {
            return Boolean.FALSE;
        }
    }
}

