/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.browser.ExternalControl;
import com.limegroup.gnutella.bugs.BugManager;
import com.limegroup.gnutella.gui.CocoaApplicationEventHandler;
import com.limegroup.gnutella.gui.DefaultErrorCatcher;
import com.limegroup.gnutella.gui.ErrorHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GURLHandler;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MessageHandler;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.VisualConnectionCallback;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.SystemUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Initializer {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$Initializer == null ? (class$com$limegroup$gnutella$gui$Initializer = Initializer.class$("com.limegroup.gnutella.gui.Initializer")) : class$com$limegroup$gnutella$gui$Initializer);
    private static volatile boolean isStartup = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$Initializer;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$System;

    private Initializer() {
    }

    static void initialize(String[] args) throws Throwable {
        long startMemory = 0L;
        if (LOG.isTraceEnabled()) {
            startMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            LOG.trace("START Initializer, using: " + startMemory + " memory");
        }
        ErrorService.setErrorCallback(new ErrorHandler());
        MessageService.setCallback(new MessageHandler());
        if (!CommonUtils.isJava118()) {
            DefaultErrorCatcher.install();
        }
        if (CommonUtils.isMacOSX()) {
            LOG.trace("START registering OSX events");
            GURLHandler.getInstance().register();
            if (CommonUtils.isJava14OrLater()) {
                CocoaApplicationEventHandler.instance().register();
            }
            SystemUtils.setOpenFileLimit(1024);
            LOG.trace("STOP registering OSX events");
        }
        if (args.length >= 2 && "-pmf".equals(args[0])) {
            PackagedMediaFileLauncher.launchFile(args[1], false);
            return;
        }
        if (StartupSettings.RUN_ON_STARTUP.getValue()) {
            LOG.trace("START yield");
            Thread.yield();
            LOG.trace("STOP yield");
        }
        if (args.length >= 1 && "-startup".equals(args[0])) {
            isStartup = true;
        }
        if (isStartup && !StartupSettings.RUN_ON_STARTUP.getValue()) {
            System.exit(0);
        }
        String arg = null;
        LOG.trace("START magnet check");
        if (args.length > 0 && !args[0].equals("-startup")) {
            arg = ExternalControl.preprocessArgs(args);
            ExternalControl.checkForActiveLimeWire(arg);
            ExternalControl.enqueueMagnetRequest(arg);
        } else if (!StartupSettings.ALLOW_MULTIPLE_INSTANCES.getValue()) {
            ExternalControl.checkForActiveLimeWire();
        }
        LOG.trace("STOP magnet check");
        LOG.trace("START system properties");
        Initializer.setSystemProperties();
        Initializer.setOSXSystemProperties();
        LOG.trace("STOP system properties");
        LOG.trace("START ResourceManager");
        ResourceManager.instance();
        LOG.trace("STOP ResourceManager");
        SplashWindow splash = null;
        if (!isStartup) {
            splash = new SplashWindow();
            SplashWindow.setStatusText(GUIMediator.getStringResource("SPLASH_STATUS_USER_SETTINGS"));
            SplashWindow.setStatusText(GUIMediator.getStringResource("SPLASH_STATUS_SHARED_FILES"));
        }
        LOG.trace("START BugManager");
        BugManager.instance();
        LOG.trace("STOP BugManager");
        LOG.trace("START SetupManager");
        new SetupManager().createIfNeeded();
        LOG.trace("STOP SetupManager");
        LOG.trace("START SaveDirectoryHandler");
        SaveDirectoryHandler.handleSaveDirectory();
        LOG.trace("STOP SaveDirectoryHandler");
        SplashWindow.setStatusText(GUIMediator.getStringResource("SPLASH_STATUS_INTERFACE"));
        LOG.trace("START GUIMediator.instance()");
        GUIMediator mediator = GUIMediator.instance();
        LOG.trace("STOP GUIMediator.instance()");
        SplashWindow.setStatusText(GUIMediator.getStringResource("SPLASH_STATUS_CORE_COMPONENTS"));
        VisualConnectionCallback ac = new VisualConnectionCallback();
        LOG.trace("START new RouterService");
        RouterService routerService = new RouterService(ac);
        LOG.trace("STOP new RouterService");
        mediator.setRouterService(routerService);
        LOG.trace("START NotifyUserProxy");
        NotifyUserProxy notifyProxy = NotifyUserProxy.instance();
        notifyProxy.hideNotify();
        LOG.trace("STOP NotifyUserProxy");
        if (splash != null) {
            splash.dispose();
        }
        GUIMediator.allowVisibility();
        if (!isStartup) {
            LOG.trace("START setAppVisible");
            GUIMediator.setAppVisible(true);
            LOG.trace("STOP setAppVisible");
        } else {
            LOG.trace("START startupHidden");
            GUIMediator.startupHidden();
            LOG.trace("STOP startupHidden");
        }
        LOG.trace("START IconManager.instance()");
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_ICONS"));
        IconManager.instance();
        LOG.trace("STOP IconManager.instance()");
        LOG.trace("START I18NConvert.instance()");
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_I18N"));
        I18NConvert.instance();
        LOG.trace("STOP I18NConvert.instance()");
        LOG.trace("START RouterService");
        routerService.start();
        LOG.trace("STOP RouterService");
        mediator.startTimer();
        ExternalControl.runQueuedMagnetRequest();
        GUIMediator.instance().loadFinished();
        if (LOG.isTraceEnabled()) {
            long stopMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            LOG.trace("STOP Initializer, using: " + stopMemory + " memory, consumed: " + (stopMemory - startMemory));
        }
    }

    static void setStartup() {
        isStartup = true;
    }

    static void setSystemProperties() {
        if (CommonUtils.isJava118()) {
            return;
        }
        try {
            Method setPropertyMethod = (class$java$lang$System == null ? (class$java$lang$System = Initializer.class$("java.lang.System")) : class$java$lang$System).getDeclaredMethod("setProperty", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String);
            setPropertyMethod.invoke(null, (Object[])new String[]{"http.agent", CommonUtils.getHttpServer()});
        }
        catch (IllegalAccessException e1) {
        }
        catch (InvocationTargetException e1) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static void setOSXSystemProperties() {
        if (!CommonUtils.isMacOSX()) {
            return;
        }
        try {
            Method setPropertyMethod = (class$java$lang$System == null ? (class$java$lang$System = Initializer.class$("java.lang.System")) : class$java$lang$System).getDeclaredMethod("setProperty", class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = Initializer.class$("java.lang.String")) : class$java$lang$String);
            if (CommonUtils.isJava14OrLater()) {
                UIManager.put("ProgressBar.repaintInterval", new Integer(500));
                setPropertyMethod.invoke(null, (Object[])new String[]{"apple.laf.useScreenMenuBar", "true"});
            } else {
                setPropertyMethod.invoke(null, (Object[])new String[]{"com.apple.macos.useScreenMenuBar", "true"});
                setPropertyMethod.invoke(null, (Object[])new String[]{"com.apple.mrj.application.apple.menu.about.name", "LimeWire"});
                setPropertyMethod.invoke(null, (Object[])new String[]{"com.apple.macos.use-file-dialog-packages", "true"});
            }
        }
        catch (IllegalAccessException e1) {
        }
        catch (InvocationTargetException e1) {
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

