/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.SizedTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFrame;

public final class InputFieldDialog {
    public static final int NO_TEXT_ENTERED = 77;
    public static final int CANCELLED = 78;
    public static final int TEXT_ENTERED = 79;
    private JDialog _dialog;
    private final PaddedPanel MAIN_PANEL = new PaddedPanel();
    private final SizedTextField TEXT_FIELD = new SizedTextField();
    private int _returnCode = 77;

    public InputFieldDialog(String LABEL_KEY) {
        this("INPUT_FIELD_GENERIC_CAPTION", LABEL_KEY);
    }

    public InputFieldDialog(String CAPTION_KEY, String LABEL_KEY) {
        String caption = GUIMediator.getStringResource(CAPTION_KEY);
        JFrame frame = GUIMediator.getAppFrame();
        this._dialog = new JDialog(frame, caption, true);
        ((Component)this._dialog).setSize(340, 180);
        LabeledComponent component = new LabeledComponent(LABEL_KEY, this.TEXT_FIELD, 120);
        String[] buttonLabelKeys = new String[]{"GENERAL_OK_BUTTON_LABEL", "GENERAL_CANCEL_BUTTON_LABEL"};
        String[] buttonLabelTips = new String[]{"GENERAL_OK_BUTTON_TIP", "GENERAL_CANCEL_BUTTON_TIP"};
        ActionListener[] buttonListeners = new ActionListener[]{new OKListener(), new CancelListener()};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, buttonLabelTips, buttonListeners, 0, 12);
        Container contentPane = this._dialog.getContentPane();
        BoxPanel componentPanel = new BoxPanel(1);
        componentPanel.add(Box.createVerticalGlue());
        componentPanel.add(component.getComponent());
        componentPanel.add(Box.createVerticalGlue());
        this.MAIN_PANEL.add(componentPanel);
        this.MAIN_PANEL.add(Box.createVerticalGlue());
        this.MAIN_PANEL.add(buttons);
        contentPane.add(this.MAIN_PANEL);
    }

    public int showDialog() {
        this.setVisible(true);
        return this._returnCode;
    }

    private void setVisible(boolean visible) {
        if (visible) {
            this._dialog.setLocationRelativeTo(GUIMediator.getAppFrame());
        }
        ((Component)this._dialog).setVisible(visible);
    }

    public String getText() {
        return this.TEXT_FIELD.getText();
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                InputFieldDialog.this._returnCode = 78;
                InputFieldDialog.this.setVisible(false);
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class OKListener
    implements ActionListener {
        private OKListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (InputFieldDialog.this.TEXT_FIELD.getText().equals("")) {
                    InputFieldDialog.this._returnCode = 77;
                } else {
                    InputFieldDialog.this._returnCode = 79;
                }
                InputFieldDialog.this.setVisible(false);
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

