/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LanguageInfo {
    private final String languageCode;
    private final String countryCode;
    private final String variantCode;
    private final String display;
    private final String countryName;
    private final String variantName;

    public LanguageInfo(String lc, String cc, String vc, String ln, String cn, String vn) {
        this.languageCode = lc.trim();
        this.countryCode = cc.trim();
        this.variantCode = vc.trim();
        this.display = ln.trim();
        this.countryName = cn.trim();
        this.variantName = vn.trim();
    }

    public boolean isCurrent() {
        String lc = ApplicationSettings.LANGUAGE.getValue();
        String cc = ApplicationSettings.COUNTRY.getValue();
        String lv = ApplicationSettings.LOCALE_VARIANT.getValue();
        boolean isLV = lv == null || lv.equals("") || lv.equals(this.variantCode);
        boolean isCC = cc == null || cc.equals("") || cc.equals(this.countryCode);
        boolean isLC = (lc == null || lc.equals("")) && this.languageCode.equals("en") || lc.equals(this.languageCode);
        return isLV && isCC && isLC;
    }

    public void apply() {
        ApplicationSettings.LANGUAGE.setValue(this.languageCode);
        ApplicationSettings.COUNTRY.setValue(this.countryCode);
        ApplicationSettings.LOCALE_VARIANT.setValue(this.variantCode);
        GUIMediator.resetLocale();
    }

    public String toString() {
        if (this.variantName != null && !this.variantName.toLowerCase().equals("international") && !this.variantName.equals("")) {
            return this.display + ", " + this.variantName + " (" + this.countryName + ")";
        }
        return this.display + " (" + this.countryName + ")";
    }

    public static LanguageInfo[] getLanguages() {
        List langs = null;
        langs = CommonUtils.isTestingVersion() ? LanguageInfo.getLanguagesFromDisk() : LanguageInfo.getLanguagesFromJar();
        langs.add(0, new LanguageInfo("en", "", "", "English", "United States", ""));
        return (LanguageInfo[])langs.toArray(new LanguageInfo[langs.size()]);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List getLanguagesFromJar() {
        LinkedList langs = new LinkedList();
        File jar = CommonUtils.getResourceFile("MessagesBundles.jar");
        if (!jar.exists()) {
            return langs;
        }
        ZipFile zip = null;
        zip = new ZipFile(jar);
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        while (enumeration.hasMoreElements()) {
            String name = enumeration.nextElement().getName();
            if (!name.startsWith("MessagesBundle_") || !name.endsWith(".properties")) continue;
            InputStream in = CommonUtils.getResourceStream(name);
            LanguageInfo.loadFile(langs, in);
        }
        Object var7_7 = null;
        if (zip == null) return langs;
        try {
            zip.close();
            return langs;
        }
        catch (IOException ioe) {}
        return langs;
        {
            catch (IOException e) {
                Object var7_8 = null;
                if (zip == null) return langs;
                try {
                    zip.close();
                    return langs;
                }
                catch (IOException ioe) {}
                return langs;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (zip == null) throw throwable;
            try {
                zip.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static List getLanguagesFromDisk() {
        LinkedList langs = new LinkedList();
        File lib = new File("../lib/messagebundles");
        if (!lib.isDirectory()) {
            return langs;
        }
        String[] files = lib.list();
        int i = 0;
        while (i < files.length) {
            if (files[i].startsWith("MessagesBundle_") && files[i].endsWith(".properties")) {
                try {
                    FileInputStream in = new FileInputStream(new File(lib, files[i]));
                    LanguageInfo.loadFile(langs, in);
                }
                catch (FileNotFoundException fnfe) {
                    // empty catch block
                }
            }
            ++i;
        }
        return langs;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadFile(List langs, InputStream in) {
        block12: {
            block11: {
                p = new Properties();
                try {
                    try {
                        in = new BufferedInputStream(in);
                        p.load(in);
                        if (p.size() < 200) {
                            var10_3 = null;
                            if (in == null) return;
                            break block11;
                        }
                        lc = p.getProperty("LOCALE_LANGUAGE_CODE");
                        cc = p.getProperty("LOCALE_COUNTRY_CODE");
                        vc = p.getProperty("LOCALE_VARIANT_CODE");
                        ln = p.getProperty("LOCALE_LANGUAGE_NAME");
                        cn = p.getProperty("LOCALE_COUNTRY_NAME");
                        vn = p.getProperty("LOCALE_VARIANT_NAME");
                        langs.add(new LanguageInfo(lc, cc, vc, ln, cn, vn));
                        break block12;
                    }
                    catch (IOException e) {
                        var10_5 = null;
                        if (in == null) return;
                        try {
                            in.close();
                            return;
                        }
                        catch (IOException ioe) {
                            return;
                        }
                    }
                }
                catch (Throwable var9_18) {
                    var10_6 = null;
                    if (in == null) throw var9_18;
                    ** try [egrp 2[TRYBLOCK] [2 : 135->142)] { 
lbl34:
                    // 1 sources

                    in.close();
                    throw var9_18;
lbl36:
                    // 1 sources

                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw var9_18;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 135->142)] { 
lbl41:
            // 1 sources

            in.close();
            return;
lbl43:
            // 1 sources

            catch (IOException ioe) {
                // empty catch block
            }
            return;
        }
        var10_4 = null;
        if (in == null) return;
        try {}
        catch (IOException ioe) {}
        in.close();
        return;
    }
}

