/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.gui.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;
import java.util.MissingResourceException;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalScrollButton;

public class LimeButtonUI
extends BasicButtonUI {
    private static final LimeButtonUI limeButtonUI = new LimeButtonUI();
    private static Icon _default0;
    private static Icon _default1;
    private static Icon _default2;
    private static Icon _default3;
    private static Icon _default4;
    private static Icon _pressed0;
    private static Icon _pressed1;
    private static Icon _pressed2;
    private static Icon _pressed3;
    private static Icon _pressed4;
    private static Icon _rollover0;
    private static Icon _rollover1;
    private static Icon _rollover2;
    private static Icon _rollover3;
    private static Icon _rollover4;
    private static Color _focusColor;

    public LimeButtonUI() {
        LimeButtonUI.themeChanged();
    }

    public static void themeChanged() {
        _default0 = ResourceManager.getThemeImage("button1.gif");
        _default1 = ResourceManager.getThemeImage("button2.gif");
        _default2 = ResourceManager.getThemeImage("button3.gif");
        _default3 = ResourceManager.getThemeImage("button4.gif");
        try {
            _default4 = ResourceManager.getThemeImage("button5.gif");
        }
        catch (MissingResourceException mre) {
            _default4 = _default3;
        }
        _pressed0 = ResourceManager.getThemeImage("button1_press.gif");
        _pressed1 = ResourceManager.getThemeImage("button2_press.gif");
        _pressed2 = ResourceManager.getThemeImage("button3_press.gif");
        _pressed3 = ResourceManager.getThemeImage("button4_press.gif");
        try {
            _pressed4 = ResourceManager.getThemeImage("button5_press.gif");
        }
        catch (MissingResourceException mre) {
            _pressed4 = _pressed3;
        }
        _rollover0 = ImageManipulator.brighten(_default0);
        _rollover1 = ImageManipulator.brighten(_default1);
        _rollover2 = ImageManipulator.brighten(_default2);
        _rollover3 = ImageManipulator.brighten(_default3);
        _rollover4 = ImageManipulator.brighten(_default4);
        _focusColor = LimeButtonUI.createFocusColor();
    }

    private static Color createFocusColor() {
        Image img = ((ImageIcon)_default0).getImage();
        int[] pix = new int[1];
        PixelGrabber pg = new PixelGrabber(img, 10, 10, 1, 1, pix, 0, 1);
        try {
            if (pg.grabPixels()) {
                int alpha = pix[0] & 0xFF000000;
                int invert = ~(pix[0] & 0xFFFFFF);
                invert = alpha | invert;
                return new Color(invert);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return UIManager.getColor("Button.focus");
    }

    public static ComponentUI createUI(JComponent c) {
        return limeButtonUI;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        AbstractButton b = (AbstractButton)c;
        if (this.isValidButton(b) && this.shouldInstallUI(b)) {
            this.setButtonValues(b);
            this.setIcons(b);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.removeButtonValues((AbstractButton)c);
        this.removeIcons((AbstractButton)c);
    }

    private boolean isValidButton(AbstractButton b) {
        return b instanceof JButton && !(b instanceof MediaButton) && !(b instanceof MetalComboBoxButton) && !(b instanceof BasicArrowButton) && !(b instanceof MetalScrollButton) && b.getText() != null && !b.getText().equals("");
    }

    private void setButtonValues(AbstractButton b) {
        b.putClientProperty("setBorderPainted", b.isBorderPainted() ? Boolean.TRUE : Boolean.FALSE);
        b.setBorderPainted(false);
        b.putClientProperty("setContentAreaFilled", b.isContentAreaFilled() ? Boolean.TRUE : Boolean.FALSE);
        b.setContentAreaFilled(false);
        b.putClientProperty("setHorizontalTextPosition", new Integer(b.getHorizontalTextPosition()));
        b.setHorizontalTextPosition(0);
        b.putClientProperty("setFocusPainted", b.isFocusPainted() ? Boolean.TRUE : Boolean.FALSE);
        b.setFocusPainted(true);
    }

    private void removeButtonValues(AbstractButton b) {
        b.setBorderPainted(this.getBoolean("setBorderPainted", b));
        b.setContentAreaFilled(this.getBoolean("setContentAreaFilled", b));
        b.setHorizontalTextPosition(this.getInteger("setHorizontalTextPosition", b));
        b.setFocusPainted(this.getBoolean("setFocusPainted", b));
    }

    private boolean getBoolean(String s, AbstractButton b) {
        Boolean bool = (Boolean)b.getClientProperty(s);
        return bool == null ? false : bool;
    }

    private int getInteger(String s, AbstractButton b) {
        Integer integr = (Integer)b.getClientProperty(s);
        return integr == null ? 0 : integr;
    }

    private boolean shouldInstallUI(AbstractButton button) {
        Icon icon = button.getIcon();
        if (icon == null) {
            return true;
        }
        if (icon == _default0) {
            return false;
        }
        if (icon == _default1) {
            return false;
        }
        if (icon == _default2) {
            return false;
        }
        if (icon == _default3) {
            return false;
        }
        if (icon == _default4) {
            return false;
        }
        Icon pressedIcon = button.getPressedIcon();
        if (pressedIcon == null) {
            return true;
        }
        if (pressedIcon == _pressed0) {
            return false;
        }
        if (pressedIcon == _pressed1) {
            return false;
        }
        if (pressedIcon == _pressed2) {
            return false;
        }
        if (pressedIcon == _pressed3) {
            return false;
        }
        return pressedIcon != _pressed4;
    }

    protected void paintText(Graphics g, JComponent c, Rectangle r, String text) {
        ButtonModel model;
        AbstractButton b = (AbstractButton)c;
        if (this.isValidButton(b) && (model = b.getModel()).isArmed() && model.isPressed()) {
            ++r.x;
            ++r.y;
        }
        super.paintText(g, c, r, text);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (this.isValidButton(b)) {
            g.setColor(_focusColor);
            BasicGraphicsUtils.drawDashedRect(g, textRect.x - 6, textRect.y - 1, textRect.width + 12, textRect.height + 2);
        } else {
            super.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    private void setIcons(AbstractButton button) {
        Icon rolloverIcon;
        Icon pressedButtonIcon;
        Icon buttonIcon;
        FontMetrics fm = ((Component)button).getFontMetrics(button.getFont());
        int stringWidth = fm.stringWidth(button.getText());
        if (stringWidth < 30) {
            buttonIcon = _default0;
            pressedButtonIcon = _pressed0;
            rolloverIcon = _rollover0;
        } else if (stringWidth < 53) {
            buttonIcon = _default1;
            pressedButtonIcon = _pressed1;
            rolloverIcon = _rollover1;
        } else if (stringWidth < 72) {
            buttonIcon = _default2;
            pressedButtonIcon = _pressed2;
            rolloverIcon = _rollover2;
        } else if (stringWidth < 90) {
            buttonIcon = _default3;
            pressedButtonIcon = _pressed3;
            rolloverIcon = _rollover3;
        } else {
            buttonIcon = _default4;
            pressedButtonIcon = _pressed4;
            rolloverIcon = _rollover4;
        }
        button.putClientProperty("setIcon", button.getIcon());
        button.setIcon(buttonIcon);
        button.putClientProperty("setDisabledIcon", button.getDisabledIcon());
        button.setDisabledIcon(buttonIcon);
        button.putClientProperty("setPressedIcon", button.getPressedIcon());
        button.setPressedIcon(pressedButtonIcon);
        button.putClientProperty("setDisabledSelectedIcon", button.getDisabledSelectedIcon());
        button.setDisabledSelectedIcon(pressedButtonIcon);
        button.putClientProperty("setRolloverIcon", button.getRolloverIcon());
        button.setRolloverIcon(rolloverIcon);
        button.putClientProperty("setPreferredSize", button.getPreferredSize());
        button.setPreferredSize(new Dimension(buttonIcon.getIconWidth(), buttonIcon.getIconHeight()));
    }

    private void removeIcons(AbstractButton b) {
        b.setIcon((Icon)b.getClientProperty("setIcon"));
        b.setDisabledIcon((Icon)b.getClientProperty("setDisabledIcon"));
        b.setPressedIcon((Icon)b.getClientProperty("setPressedIcon"));
        b.setDisabledSelectedIcon((Icon)b.getClientProperty("setDisabledSelectedIcon"));
        b.setPreferredSize((Dimension)b.getClientProperty("setPreferredSize"));
        b.setRolloverIcon((Icon)b.getClientProperty("setRolloverIcon"));
    }
}

