/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJOpenDocumentHandler;
import com.apple.mrj.MRJQuitHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PackagedMediaFileLauncher;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.File;

final class MacEventHandler
implements MRJAboutHandler,
MRJQuitHandler,
MRJOpenDocumentHandler {
    MacEventHandler() {
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)this);
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)this);
        MRJApplicationUtils.registerOpenDocumentHandler((MRJOpenDocumentHandler)this);
    }

    public void handleAbout() {
        if (CommonUtils.isMacClassic() || CommonUtils.isJaguarOrAbove()) {
            GUIMediator.showAboutWindow();
        } else {
            new ManagedThread("Mac about menu thread"){

                public void managedRun() {
                    GUIMediator.showAboutWindow();
                }
            }.start();
        }
    }

    public void handleQuit() {
        if (CommonUtils.isMacClassic() || CommonUtils.isJaguarOrAbove()) {
            GUIMediator.close(false);
        } else {
            new ManagedThread("Mac quit thread"){

                public void managedRun() {
                    GUIMediator.close(false);
                }
            }.start();
        }
    }

    public void handleOpenFile(File file) {
        if (CommonUtils.isMacClassic() || CommonUtils.isJaguarOrAbove()) {
            PackagedMediaFileLauncher.launchFile(file.toString(), false);
        } else {
            new HandleOpenFile(file).start();
        }
    }

    class HandleOpenFile
    extends ManagedThread {
        File requestedFile;

        public HandleOpenFile(File file) {
            super("handleOpenFile");
            this.requestedFile = file;
        }

        public void managedRun() {
            PackagedMediaFileLauncher.launchFile(this.requestedFile.toString(), false);
        }
    }
}

