/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.PowerManager;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.ShoppingView;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.connection.ConnectionMediator;
import com.limegroup.gnutella.gui.download.DownloadMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.statistics.StatisticsMediator;
import com.limegroup.gnutella.gui.tabs.ConnectionsTab;
import com.limegroup.gnutella.gui.tabs.LibraryPlayListTab;
import com.limegroup.gnutella.gui.tabs.MonitorUploadTab;
import com.limegroup.gnutella.gui.tabs.SearchDownloadTab;
import com.limegroup.gnutella.gui.tabs.ShoppingBrowserTab;
import com.limegroup.gnutella.gui.tabs.Tab;
import com.limegroup.gnutella.gui.upload.UploadMediator;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.PlayerSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.TabbedPaneUI;

final class MainFrame
implements ComponentListener,
RefreshListener,
ThemeObserver {
    private static final int APP_WIDTH = 840;
    private static final int APP_HEIGHT = 600;
    private final JTabbedPane TABBED_PANE = new JTabbedPane();
    private final SearchMediator SEARCH_MEDIATOR = new SearchMediator();
    private final DownloadMediator DOWNLOAD_MEDIATOR = DownloadMediator.instance();
    private final MonitorView MONITOR_VIEW = new MonitorView();
    private final UploadMediator UPLOAD_MEDIATOR = UploadMediator.instance();
    private final ShoppingView SHOPPING_VIEW = new ShoppingView();
    private final ConnectionMediator CONNECTION_MEDIATOR = ConnectionMediator.instance();
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final PlayListGUI PLAYLIST_VIEW = !CommonUtils.isMacClassic() && PlayerSettings.PLAYER_ENABLED.getValue() ? PlayListGUI.instance() : null;
    private final StatisticsMediator STATISTICS_MEDIATOR = StatisticsMediator.instance();
    private final OptionsMediator OPTIONS_MEDIATOR = OptionsMediator.instance();
    private final StatusLine STATUS_LINE = new StatusLine();
    private final MenuMediator MENU_MEDIATOR = MenuMediator.instance();
    private final JFrame FRAME;
    private boolean isDownloadViewVisible = false;
    private final LogoPanel LOGO_PANEL = new LogoPanel();
    private Tab[] TABS = null;

    MainFrame(JFrame frame) {
        this.FRAME = frame;
        this.buildTabs();
        this.TABBED_PANE.setPreferredSize(new Dimension(10000, 10000));
        ImageIcon plugIcon = GUIMediator.getThemeImage("plug.gif");
        ((Frame)this.FRAME).setIconImage(plugIcon.getImage());
        this.FRAME.addWindowListener(new WindowAdapter(){

            public void windowDeiconified(WindowEvent e) {
                if (!CommonUtils.supportsTray()) {
                    GUIMediator.restoreView();
                }
            }

            public void windowClosing(WindowEvent e) {
                Dimension dim = GUIMediator.getAppSize();
                Point loc = GUIMediator.getAppLocation();
                ApplicationSettings.APP_WIDTH.setValue(dim.width);
                ApplicationSettings.APP_HEIGHT.setValue(dim.height);
                ApplicationSettings.WINDOW_X.setValue(loc.x);
                ApplicationSettings.WINDOW_Y.setValue(loc.y);
                SettingsHandler.save();
                GUIMediator.close(true);
            }
        });
        this.FRAME.addComponentListener(this);
        this.FRAME.setDefaultCloseOperation(0);
        this.setFrameDimensions();
        int i = 0;
        while (i < this.TABS.length) {
            this.addTab(this.TABS[i]);
            ++i;
        }
        this.TABBED_PANE.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JTabbedPane tp = (JTabbedPane)e.getSource();
                GUIMediator.instance().handleTabSelection(MainFrame.this.getIndex(tp.getSelectedComponent()));
            }
        });
        this.TABBED_PANE.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                TabbedPaneUI ui = MainFrame.this.TABBED_PANE.getUI();
                int idx = ui.tabForCoordinate(MainFrame.this.TABBED_PANE, e.getX(), e.getY());
                if (idx != -1) {
                    idx = MainFrame.this.getTabIndex(idx);
                }
                if (idx != -1) {
                    MainFrame.this.TABS[idx].mouseClicked();
                }
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        if (CommonUtils.isAnyMac() && !CommonUtils.isJava14OrLater()) {
            new MacEventHandler();
        }
        if (!CommonUtils.isMacClassic()) {
            if (!ApplicationSettings.MONITOR_VIEW_ENABLED.getValue()) {
                this.setTabVisible(1, false);
            }
            if (!ApplicationSettings.CONNECTION_VIEW_ENABLED.getValue()) {
                this.setTabVisible(2, false);
            }
            if (!ApplicationSettings.LIBRARY_VIEW_ENABLED.getValue()) {
                this.setTabVisible(3, false);
            }
            if (!ApplicationSettings.SHOPPING_VIEW_ENABLED.getValue() && this.shouldShowShoppingTab()) {
                this.setTabVisible(4, false);
            }
        }
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        Container contentPane = this.FRAME.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        BoxPanel mainPanel = new BoxPanel(1);
        mainPanel.add(this.TABBED_PANE);
        mainPanel.add(this.STATUS_LINE.getComponent());
        contentPane.add(mainPanel);
        JLayeredPane layeredPane = JLayeredPane.getLayeredPaneAbove(this.TABBED_PANE);
        layeredPane.add(this.LOGO_PANEL, JLayeredPane.PALETTE_LAYER, 0);
        this.configureMenusforShopping();
        GUIMediator.addThemeObserver(this);
        GUIMediator.addRefreshListener(this);
        this.updateLogoHeight();
        if (CommonUtils.isUnix() && !CommonUtils.isAnyMac()) {
            frame.addWindowListener(MagnetClipboardListener.getInstance());
        }
        PowerManager pm = new PowerManager();
        frame.addWindowListener(pm);
        GUIMediator.addRefreshListener(pm);
    }

    public void updateTheme() {
        this.FRAME.setJMenuBar(this.MENU_MEDIATOR.getMenuBar());
        this.LOGO_PANEL.updateTheme();
        this.setSearchIconLocation();
        this.updateLogoHeight();
    }

    private void updateLogoHeight() {
        Rectangle rect = this.TABBED_PANE.getUI().getTabBounds(this.TABBED_PANE, 0);
        Dimension ld = this.LOGO_PANEL.getSize();
        int height = ld.height + 5;
        if (rect.height < height) {
            this.TABBED_PANE.setBorder(BorderFactory.createEmptyBorder(height - rect.height, 0, 0, 0));
        } else {
            this.TABBED_PANE.setBorder(null);
        }
    }

    private boolean shouldShowShoppingTab() {
        return !GUIMediator.hasDonated() && CommonUtils.isWindows();
    }

    private void buildTabs() {
        if (this.shouldShowShoppingTab() && ResourceManager.isBrowserPageLoaded()) {
            this.TABS = new Tab[5];
            this.TABS[0] = new SearchDownloadTab(this.SEARCH_MEDIATOR, this.DOWNLOAD_MEDIATOR);
            this.TABS[1] = new MonitorUploadTab(this.MONITOR_VIEW, this.UPLOAD_MEDIATOR);
            this.TABS[2] = new ConnectionsTab(this.CONNECTION_MEDIATOR);
            this.TABS[3] = new LibraryPlayListTab(this.LIBRARY_MEDIATOR, this.PLAYLIST_VIEW);
            this.TABS[4] = new ShoppingBrowserTab(this.SHOPPING_VIEW);
        } else {
            this.TABS = new Tab[4];
            this.TABS[0] = new SearchDownloadTab(this.SEARCH_MEDIATOR, this.DOWNLOAD_MEDIATOR);
            this.TABS[1] = new MonitorUploadTab(this.MONITOR_VIEW, this.UPLOAD_MEDIATOR);
            this.TABS[2] = new ConnectionsTab(this.CONNECTION_MEDIATOR);
            this.TABS[3] = new LibraryPlayListTab(this.LIBRARY_MEDIATOR, this.PLAYLIST_VIEW);
        }
    }

    private void configureMenusforShopping() {
        if (this.shouldShowShoppingTab()) {
            int size = this.MENU_MEDIATOR.getMenuBar().getMenuCount();
            class MenuChangeListener
            implements MenuListener {
                private final /* synthetic */ MainFrame this$0;

                MenuChangeListener(MainFrame this$0) {
                    this.this$0 = this$0;
                }

                public void menuCanceled(MenuEvent e) {
                }

                public void menuDeselected(MenuEvent e) {
                }

                public void menuSelected(MenuEvent e) {
                    int size = MainFrame.access$400(this.this$0).getMenuBar().getMenuCount();
                    if (size > 1 && MainFrame.access$500(this.this$0) != null && MainFrame.access$100(this.this$0).getSelectedComponent() == MainFrame.access$500(this.this$0)) {
                        this.this$0.setSelectedIndex(0);
                    }
                }
            }
            MenuChangeListener mcl = new MenuChangeListener(this);
            int i = 0;
            while (i < size) {
                this.MENU_MEDIATOR.getMenuBar().getMenu(i).addMenuListener(mcl);
                ++i;
            }
        }
    }

    private void addTab(Tab tab) {
        this.TABBED_PANE.addTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip());
    }

    private void insertTab(Tab tab, int index) {
        this.TABBED_PANE.insertTab(tab.getTitle(), tab.getIcon(), tab.getComponent(), tab.getToolTip(), index);
        SwingUtilities.updateComponentTreeUI(this.TABBED_PANE);
        GUIMediator.instance().updateThemeObservers();
    }

    final void setSelectedIndex(int index) {
        int i = this.getTabIndex(index);
        if (i == -1) {
            return;
        }
        this.TABBED_PANE.setSelectedIndex(i);
    }

    void updateTabIcon(int index) {
        int i = this.getTabIndex(index);
        if (i == -1) {
            return;
        }
        this.TABBED_PANE.setIconAt(i, this.TABS[index].getIcon());
    }

    private final void setFrameDimensions() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int appWidth = 0;
        int appHeight = 0;
        if (ApplicationSettings.RUN_ONCE.getValue()) {
            appWidth = ApplicationSettings.APP_WIDTH.getValue();
            appHeight = ApplicationSettings.APP_HEIGHT.getValue();
            ((Component)this.FRAME).setLocation(ApplicationSettings.WINDOW_X.getValue(), ApplicationSettings.WINDOW_Y.getValue());
        } else {
            appWidth = Math.min(screenSize.width, 840);
            appHeight = Math.min(screenSize.height - 40, 600);
            ((Component)this.FRAME).setLocation((screenSize.width - appWidth) / 2, (screenSize.height - appHeight) / 2);
        }
        ((Component)this.FRAME).setSize(new Dimension(appWidth, appHeight));
    }

    void setTabVisible(int TAB_INDEX, boolean VISIBLE) {
        if (TAB_INDEX == 0 || TAB_INDEX > this.TABS.length - 1) {
            throw new IllegalArgumentException("Invalid tab index: " + TAB_INDEX);
        }
        Tab tab = this.TABS[TAB_INDEX];
        JComponent comp = tab.getComponent();
        int tabCount = this.TABBED_PANE.getTabCount();
        if (!VISIBLE) {
            int i = 0;
            while (i < tabCount) {
                if (comp.equals(this.TABBED_PANE.getComponentAt(i))) {
                    this.TABBED_PANE.remove(i);
                    break;
                }
                ++i;
            }
        } else {
            JComponent selComp = (JComponent)this.TABBED_PANE.getSelectedComponent();
            selComp.setVisible(false);
            int i = 0;
            while (i < tabCount) {
                Component comp1 = this.TABBED_PANE.getComponentAt(i);
                int index = this.getIndex(comp1);
                if (index == -1) {
                    selComp.setVisible(true);
                    return;
                }
                if (index > TAB_INDEX) {
                    this.insertTab(this.TABS[TAB_INDEX], i);
                    break;
                }
                if (i == tabCount - 1) {
                    this.insertTab(this.TABS[TAB_INDEX], i + 1);
                }
                ++i;
            }
            JComponent jcomp = comp;
            jcomp.invalidate();
            jcomp.revalidate();
            jcomp.repaint();
        }
        this.MENU_MEDIATOR.setNavMenuItemEnabled(TAB_INDEX, VISIBLE);
        tab.storeState(VISIBLE);
    }

    private int getIndex(Component comp) {
        int i = 0;
        while (i < this.TABS.length) {
            if (comp.equals(this.TABS[i].getComponent())) {
                return this.TABS[i].getIndex();
            }
            ++i;
        }
        return -1;
    }

    private int getTabIndex(int index) {
        int tabCount = this.TABBED_PANE.getTabCount();
        JComponent comp = this.TABS[index].getComponent();
        int i = 0;
        while (i < tabCount) {
            Component tabComp = this.TABBED_PANE.getComponentAt(i);
            if (tabComp.equals(comp)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void refresh() {
        int count;
        if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() == 0 && this.isDownloadViewVisible) {
            ((SearchDownloadTab)this.TABS[0]).setDividerLocation(1000);
            this.isDownloadViewVisible = false;
        } else if (this.DOWNLOAD_MEDIATOR.getActiveDownloads() > 0 && !this.isDownloadViewVisible && (count = this.DOWNLOAD_MEDIATOR.getActiveDownloads()) > 0) {
            double prop = count > 6 ? 0.6 : 0.7;
            ((SearchDownloadTab)this.TABS[0]).setDividerLocation(prop);
            ((SearchDownloadTab)this.TABS[0]).getComponent().revalidate();
            this.TABBED_PANE.revalidate();
            this.isDownloadViewVisible = true;
        }
    }

    final SearchMediator getSearchMediator() {
        return this.SEARCH_MEDIATOR;
    }

    final DownloadMediator getDownloadMediator() {
        return this.DOWNLOAD_MEDIATOR;
    }

    final MonitorView getMonitorView() {
        return this.MONITOR_VIEW;
    }

    final UploadMediator getUploadMediator() {
        return this.UPLOAD_MEDIATOR;
    }

    final ConnectionMediator getConnectionMediator() {
        return this.CONNECTION_MEDIATOR;
    }

    final LibraryMediator getLibraryMediator() {
        return this.LIBRARY_MEDIATOR;
    }

    final ShoppingView getShoppingView() {
        return this.SHOPPING_VIEW;
    }

    final PlayListGUI getPlayListGUI() {
        return this.PLAYLIST_VIEW;
    }

    final StatusLine getStatusLine() {
        return this.STATUS_LINE;
    }

    final MenuMediator getMenuMediator() {
        return this.MENU_MEDIATOR;
    }

    final OptionsMediator getOptionsMediator() {
        return this.OPTIONS_MEDIATOR;
    }

    final StatisticsMediator getStatisticsMediator() {
        return this.STATISTICS_MEDIATOR;
    }

    final void setSearching(boolean searching) {
        this.LOGO_PANEL.setSearching(searching);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.setSearchIconLocation();
    }

    public void componentShown(ComponentEvent e) {
        this.setSearchIconLocation();
    }

    private void setSearchIconLocation() {
        this.LOGO_PANEL.setLocation(this.FRAME.getSize().width - this.LOGO_PANEL.getSize().width - 12, this.MENU_MEDIATOR.getMenuBarHeight());
    }

    static /* synthetic */ MenuMediator access$400(MainFrame x0) {
        return x0.MENU_MEDIATOR;
    }

    static /* synthetic */ ShoppingView access$500(MainFrame x0) {
        return x0.SHOPPING_VIEW;
    }
}

