/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.BufferListModel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class MonitorView
extends PaddedPanel
implements ThemeObserver {
    private int listSize;
    private JTextField showText;
    private JCheckBox monitorCheckBox;
    private JList listBox;
    private JScrollPane scrollPane;
    private boolean bypassCountChange = false;
    private BufferListModel model = new BufferListModel(32);

    public MonitorView() {
        super(GUIMediator.getStringResource("MONITOR_VIEW_INCOMING_SEARCHES"));
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_MONITOR_WINDOW"));
        this.listBox = new JList(this.model);
        this.listBox.setPrototypeCellValue("                                      ");
        this.listBox.setFixedCellHeight(16);
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        this.monitorCheckBox = new JCheckBox(GUIMediator.getStringResource("MONITOR_VIEW_ENABLE"));
        this.monitorCheckBox.setPreferredSize(new Dimension(200, 20));
        this.monitorCheckBox.addItemListener(new CheckBoxListener());
        controlPanel.add(this.monitorCheckBox);
        controlPanel.add(Box.createHorizontalGlue());
        controlPanel.add(new JLabel(GUIMediator.getStringResource("MONITOR_VIEW_SHOW_LAST")));
        this.showText = new WholeNumberField(32, 3);
        Dimension d = new Dimension(10, 20);
        this.showText.setPreferredSize(d);
        this.showText.setMaximumSize(d);
        this.listSize = 32;
        controlPanel.add(this.showText);
        controlPanel.add(new JLabel(GUIMediator.getStringResource("MONITOR_VIEW_SEARCHES")));
        this.scrollPane = new JScrollPane(this.listBox);
        this.scrollPane.setPreferredSize(new Dimension(340, 180));
        this.add(controlPanel);
        this.add(this.scrollPane);
        this.showText.getDocument().addDocumentListener(new CountDocumentListener());
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() >= 2 && (index = MonitorView.this.listBox.locationToIndex(e.getPoint())) != -1) {
                    String str = (String)MonitorView.this.model.getElementAt(index);
                    MonitorView.this.triggerSearch(str);
                }
            }
        };
        this.listBox.addMouseListener(mouseListener);
        this.updateTheme();
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.scrollPane.getViewport().setBackground(tableColor);
        this.listBox.setBackground(tableColor);
    }

    private void triggerSearch(String str) {
        GUIMediator.instance().triggerSearch(str);
    }

    private void setShowCount(String count) {
        this.bypassCountChange = true;
        this.showText.setText(count);
        this.bypassCountChange = false;
    }

    private void handleCountChange() {
        if (this.bypassCountChange) {
            return;
        }
        String val = this.showText.getText();
        if (val != null && !val.equals("")) {
            int size = Integer.parseInt(val);
            if (size > 10000) {
                this.listSize = 32;
                this.delayedSetText("32");
            } else {
                this.listSize = size;
            }
            this.model.changeSize(this.listSize);
            this.scrollPane.validate();
        }
    }

    private void delayedSetText(String val) {
        DelayedSetText doWorkRunnable = new DelayedSetText(val);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void handleQueryString(String query) {
        if (this.monitorCheckBox.isSelected()) {
            if (query.length() == 0) {
                return;
            }
            char c = query.charAt(query.length() - 1);
            if (Character.isISOControl(c) || !Character.isDefined(c)) {
                query = query.substring(0, query.length() - 1);
            }
            this.model.addFirst(query);
        }
    }

    private class DelayedSetText
    implements Runnable {
        String val;

        public DelayedSetText(String val) {
            this.val = val;
        }

        public void run() {
            MonitorView.this.setShowCount(this.val);
        }
    }

    private class CountDocumentListener
    implements DocumentListener {
        private CountDocumentListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            MonitorView.this.handleCountChange();
        }

        public void removeUpdate(DocumentEvent e) {
            MonitorView.this.handleCountChange();
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class CheckBoxListener
    implements ItemListener {
        private CheckBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1 && RouterService.isShieldedLeaf()) {
                GUIMediator.showMessage("MONITOR_VIEW_LEAF_MESSAGE", QuestionsHandler.MONITOR_VIEW);
            }
        }
    }
}

