/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.JMultilineToolTip;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MultilineToolTipUI
extends BasicToolTipUI {
    private static final int MAX_WIDTH = 400;
    private static final int BLANK_SPACE = 4;
    private static final MultilineToolTipUI instance = new MultilineToolTipUI();
    private boolean extendedWidth = false;
    private final JTextArea TEXT = new JTextArea();
    private final CellRendererPane PANE = new CellRendererPane();

    public static MultilineToolTipUI instance() {
        return instance;
    }

    private MultilineToolTipUI() {
        this.TEXT.setLineWrap(true);
        this.TEXT.setWrapStyleWord(true);
        this.TEXT.setEditable(false);
        this.TEXT.setOpaque(false);
    }

    public Dimension getPreferredSize(JComponent c) {
        this.extendedWidth = false;
        Font font = c.getFont();
        FontMetrics fontMetrics = ((Component)c).getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        String[] lines = ((JMultilineToolTip)c).getTipArray();
        if (lines == null) {
            return new Dimension(0, 0);
        }
        int num_lines = lines.length;
        int height = num_lines * fontHeight;
        if (height == 0) {
            return new Dimension(0, 0);
        }
        int width = 0;
        int i = 0;
        while (i < num_lines) {
            int line_width = fontMetrics.stringWidth(lines[i]);
            width = Math.max(line_width, width);
            if (width > 400) {
                this.extendedWidth = true;
                break;
            }
            ++i;
        }
        if (this.extendedWidth) {
            this.TEXT.setFont(font);
            this.TEXT.setText(lines[0]);
            int i2 = 1;
            while (i2 < num_lines) {
                this.TEXT.append("\n" + lines[i2]);
                ++i2;
            }
            Dimension pref = this.preferredSize(fontMetrics, this.TEXT);
            width = pref.width;
            height = pref.height;
        }
        return new Dimension(width + 8, height + 8);
    }

    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    private Dimension preferredSize(FontMetrics fm, JTextArea area) {
        String current;
        int fullWidth = 0;
        int rows = 1;
        int carriage = -1;
        int nextCarriage = -1;
        int width = 0;
        String text = area.getText();
        nextCarriage = text.indexOf("\n");
        while (nextCarriage != -1) {
            current = text.substring(carriage + 1, nextCarriage);
            width = fm.stringWidth(current);
            if (width > 400) {
                rows += (int)Math.ceil((double)width / 400.0);
                fullWidth = 400;
            } else {
                fullWidth = Math.max(width, fullWidth);
                ++rows;
            }
            carriage = nextCarriage;
            nextCarriage = text.indexOf("\n", carriage + 1);
        }
        current = text.substring(carriage + 1);
        width = fm.stringWidth(current);
        if (width > 400) {
            rows += (int)Math.ceil((double)width / 400.0);
            fullWidth = 400;
        } else {
            fullWidth = Math.max(width, fullWidth);
            ++rows;
        }
        return new Dimension(fullWidth, rows * fm.getHeight());
    }

    public void paint(Graphics g, JComponent c) {
        Dimension dimension = c.getSize();
        Font font = c.getFont();
        if (this.extendedWidth) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, dimension.width, dimension.height);
            this.TEXT.setForeground(c.getForeground());
            this.PANE.paintComponent(g, this.TEXT, c, 4, 4, dimension.width - 8, dimension.height - 8, true);
            return;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int fontHeight = fontMetrics.getHeight();
        int fontAscent = fontMetrics.getAscent();
        String[] lines = ((JMultilineToolTip)c).getTipArray();
        if (lines == null) {
            return;
        }
        int num_lines = lines.length;
        g.setColor(c.getBackground());
        g.fillRect(0, 0, dimension.width, dimension.height);
        g.setColor(c.getForeground());
        int i = 0;
        int height = 4 + fontAscent;
        while (i < num_lines) {
            g.drawString(lines[i], 4, height);
            ++i;
            height += fontHeight;
        }
    }
}

