/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.InputFieldDialog;
import com.sun.java.util.collections.Vector;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class StandardListEditor {
    private final BoxPanel MAIN_PANEL = new BoxPanel(0);
    private final JList LIST = new JList();
    private final JButton REMOVE_BUTTON;
    private final JButton ADD_BUTTON;
    private ActionListener _defaultAddListener;
    private boolean _listChanged = false;

    public StandardListEditor(String INPUT_FIELD_KEY) {
        this("LIST_EDITOR_ADD_BUTTON", "LIST_EDITOR_REMOVE_BUTTON", INPUT_FIELD_KEY);
    }

    public StandardListEditor(ActionListener listener) {
        this("LIST_EDITOR_ADD_BUTTON", "LIST_EDITOR_REMOVE_BUTTON", "");
        this.setAddActionListener(listener);
    }

    public StandardListEditor(String ADD_BUTTON_KEY, String REMOVE_BUTTON_KEY, String INPUT_FIELD_KEY) {
        String[] buttonLabelKeys = new String[]{ADD_BUTTON_KEY, REMOVE_BUTTON_KEY};
        String[] buttonLabelTips = new String[]{"LIST_EDITOR_ADD_BUTTON_TIP", "LIST_EDITOR_REMOVE_BUTTON_TIP"};
        this._defaultAddListener = new AddActionListener(INPUT_FIELD_KEY);
        ActionListener[] buttonListeners = new ActionListener[]{this._defaultAddListener, new RemoveListener()};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, buttonLabelTips, buttonListeners, 1, 11);
        this.ADD_BUTTON = buttons.getButtonAtIndex(0);
        this.REMOVE_BUTTON = buttons.getButtonAtIndex(1);
        this.REMOVE_BUTTON.setEnabled(false);
        this.LIST.setSelectionMode(0);
        this.LIST.addListSelectionListener(new ListEditorSelectionListener());
        JScrollPane scrollPane = new JScrollPane(this.LIST);
        this.MAIN_PANEL.add(scrollPane);
        this.MAIN_PANEL.add(buttons);
    }

    public Component getComponent() {
        return this.MAIN_PANEL;
    }

    private void addElement(Object element) {
        DefaultListModel model = (DefaultListModel)this.LIST.getModel();
        model.addElement(element);
    }

    public void addFile(File file) {
        this.addElement(file);
    }

    public void addString(String string) {
        this.addElement(string);
    }

    public void setListData(Vector data) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int i = 0;
        while (i < data.size()) {
            model.addElement(data.get(i));
            ++i;
        }
        this.LIST.setModel(model);
    }

    private void setListDataObjects(Object[] data) {
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        int i = 0;
        while (i < data.length) {
            model.addElement(data[i]);
            ++i;
        }
        this.LIST.setModel(model);
    }

    public void setListData(File[] data) {
        this.setListDataObjects(data);
    }

    public void setListData(String[] data) {
        this.setListDataObjects(data);
    }

    public void clearSelection() {
        this.LIST.clearSelection();
    }

    public String[] getDataAsStringArray() {
        DefaultListModel model = (DefaultListModel)this.LIST.getModel();
        Object[] dataObjects = model.toArray();
        String[] dataStrings = new String[dataObjects.length];
        int i = 0;
        while (i < dataObjects.length) {
            dataStrings[i] = dataObjects[i].toString();
            ++i;
        }
        return dataStrings;
    }

    public File[] getDataAsFileArray() {
        DefaultListModel model = (DefaultListModel)this.LIST.getModel();
        Object[] dataObjects = model.toArray();
        File[] dataFiles = new File[dataObjects.length];
        int i = 0;
        while (i < dataObjects.length) {
            dataFiles[i] = (File)dataObjects[i];
            ++i;
        }
        return dataFiles;
    }

    public Object[] getDataAsObjectArray() {
        DefaultListModel model = (DefaultListModel)this.LIST.getModel();
        return model.toArray();
    }

    private void setAddActionListener(ActionListener addListener) {
        this.ADD_BUTTON.removeActionListener(this._defaultAddListener);
        this.ADD_BUTTON.addActionListener(addListener);
    }

    public boolean getListChanged() {
        return this._listChanged;
    }

    public void resetList() {
        this._listChanged = false;
    }

    private class ListEditorSelectionListener
    implements ListSelectionListener {
        private ListEditorSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            try {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                    StandardListEditor.this.REMOVE_BUTTON.setEnabled(false);
                } else {
                    StandardListEditor.this.REMOVE_BUTTON.setEnabled(true);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class RemoveListener
    implements ActionListener {
        private RemoveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                StandardListEditor.this._listChanged = true;
                if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                    return;
                }
                DefaultListModel model = (DefaultListModel)StandardListEditor.this.LIST.getModel();
                model.remove(StandardListEditor.this.LIST.getSelectedIndex());
                if (StandardListEditor.this.LIST.isSelectionEmpty()) {
                    StandardListEditor.this.REMOVE_BUTTON.setEnabled(false);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class AddActionListener
    implements ActionListener {
        private final String INPUT_FIELD_KEY;

        public AddActionListener(String key) {
            this.INPUT_FIELD_KEY = key;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                InputFieldDialog dialog = new InputFieldDialog(this.INPUT_FIELD_KEY);
                int returnCode = dialog.showDialog();
                if (returnCode == 79) {
                    StandardListEditor.this._listChanged = true;
                    StandardListEditor.this.addElement(dialog.getText());
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

