/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.chat.Chatter;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MonitorView;
import com.limegroup.gnutella.gui.PasswordDialog;
import com.limegroup.gnutella.gui.chat.ChatUIManager;
import com.limegroup.gnutella.gui.iTunesMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.tables.ComponentMediator;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.security.User;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.update.gui.UpdateCallback;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;

public final class VisualConnectionCallback
implements ActivityCallback {
    private final GUIMediator MEDIATOR = GUIMediator.instance();
    private final String ENGLISH_MESSGE = "LimeWire has detected a new version on the network. Please update to version ";
    private final HandleQueryString HANDLE_QUERY_STRING = new HandleQueryString();
    private final ComponentMediator DOWNLOAD_MEDIATOR;
    private final MonitorView MONITOR_VIEW;
    private final ComponentMediator UPLOAD_MEDIATOR;
    private final ComponentMediator CONNECTION_MEDIATOR;
    private final LibraryMediator LIBRARY_MEDIATOR;
    private final iTunesMediator ITUNES_MEDIATOR = iTunesMediator.instance();

    VisualConnectionCallback() {
        MainFrame mf = this.MEDIATOR.getMainFrame();
        this.DOWNLOAD_MEDIATOR = mf.getDownloadMediator();
        this.MONITOR_VIEW = mf.getMonitorView();
        this.UPLOAD_MEDIATOR = mf.getUploadMediator();
        this.CONNECTION_MEDIATOR = mf.getConnectionMediator();
        this.LIBRARY_MEDIATOR = mf.getLibraryMediator();
    }

    public void connectionInitializing(Connection c) {
        ConnectionInitializing doWorkRunnable = new ConnectionInitializing(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void connectionInitialized(Connection c) {
        ConnectionInitialized doWorkRunnable = new ConnectionInitialized(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void connectionClosed(Connection c) {
        ConnectionClosed doWorkRunnable = new ConnectionClosed(c);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void handleQueryResult(final RemoteFileDesc rfd, final HostData data, final Set locs) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    SearchMediator.handleQueryResult(rfd, data, locs);
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "handleQueryResult");
                }
            }
        });
    }

    public void handleQueryString(String query) {
        this.HANDLE_QUERY_STRING.addQueryString(query);
    }

    public void fileManagerLoaded() {
    }

    public void addSharedDirectory(final File dir, final File parent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    VisualConnectionCallback.this.LIBRARY_MEDIATOR.addSharedDirectory(dir, parent);
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "addSharedDirectory");
                }
            }
        });
    }

    public void addSharedFile(final FileDesc file, final File parent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    VisualConnectionCallback.this.LIBRARY_MEDIATOR.addSharedFile(file, parent);
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "addSharedFile");
                }
            }
        });
    }

    public void handleSharedFileUpdate(File file) {
        this.LIBRARY_MEDIATOR.updateSharedFile(file);
    }

    public void clearSharedFiles() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    VisualConnectionCallback.this.LIBRARY_MEDIATOR.clearLibrary();
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "clearSharedFiles");
                }
            }
        });
    }

    public void setAnnotateEnabled(final boolean enabled) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    VisualConnectionCallback.this.LIBRARY_MEDIATOR.setAnnotateEnabled(enabled);
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "setAnnotateEnabled");
                }
            }
        });
    }

    public void addDownload(Downloader mgr) {
        AddDownload doWorkRunnable = new AddDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void removeDownload(Downloader mgr) {
        RemoveDownload doWorkRunnable = new RemoveDownload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
        if (mgr.getState() == 4) {
            this.ITUNES_MEDIATOR.handleCompleteDownload(mgr);
        }
    }

    public void downloadsComplete() {
        Finalizer.setDownloadsComplete();
    }

    public void addUpload(Uploader mgr) {
        AddUpload doWorkRunnable = new AddUpload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void removeUpload(Uploader mgr) {
        RemoveUpload doWorkRunnable = new RemoveUpload(mgr);
        SwingUtilities.invokeLater(doWorkRunnable);
    }

    public void uploadsComplete() {
        Finalizer.setUploadsComplete();
    }

    public void notifyUserAboutUpdate(final String m, final boolean isPro, final boolean loc) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().showUpdateNotification(false);
                String message = loc ? GUIMediator.getStringResource("UPDATE_MESSAGE") + " " + m : "LimeWire has detected a new version on the network. Please update to version " + m;
                boolean update = UpdateCallback.showUpdatePromptWithParentFrame(message);
                if (update) {
                    String url = isPro ? "http://www.limewire.com/update" : "http://www.limewire.com/download";
                    try {
                        GUIMediator.openURL(url);
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void acceptChat(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ChatUIManager.instance().acceptChat(chatter);
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "acceptChat");
                }
            }
        });
    }

    public void receiveMessage(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ChatUIManager.instance().recieveMessage(chatter);
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "receiveMessage");
                }
            }
        });
    }

    public void chatUnavailable(final Chatter chatter) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ChatUIManager.instance().chatUnavailable(chatter);
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "chatUnavailable");
                }
            }
        });
    }

    public void chatErrorMessage(final Chatter chatter, final String str) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ChatUIManager.instance().chatErrorMessage(chatter, str);
                }
                catch (Throwable e) {
                    GUIMediator.showInternalError(e, "chatErrorMessage");
                }
            }
        });
    }

    public void browseHostFailed(final GUID guid) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SearchMediator.browseHostFailed(guid);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public User getUserAuthenticationInfo(String host) {
        Object lock = new Object();
        PasswordDialogRunnable passDialog = new PasswordDialogRunnable(host, lock);
        SwingUtilities.invokeLater(passDialog);
        Object object = lock;
        synchronized (object) {
            while (passDialog.notFinished()) {
                try {
                    lock.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            return passDialog.getUser();
        }
    }

    public void promptAboutCorruptDownload(Downloader downloader) {
        final Downloader dloader = downloader;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                int resp = GUIMediator.showYesNoMessage("MESSAGE_FILE_CORRUPT", dloader.getFileName(), "MESSAGE_CONTINUE_DOWNLOAD", QuestionsHandler.CORRUPT_DOWNLOAD);
                dloader.discardCorruptDownload(resp == 102);
            }
        });
    }

    public void restoreApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.restoreView();
            }
        });
    }

    public void componentLoading(String component) {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_COMPONENT_LOADING_" + component));
    }

    public void showDownloads() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.instance().setWindow(0);
            }
        });
    }

    public boolean isQueryAlive(GUID guid) {
        return SearchMediator.queryIsAlive(guid);
    }

    public void indicateNewVersion() {
        GUIMediator.instance().showUpdateNotification(true);
    }

    public String getHostValue(String key) {
        return GUIMediator.getStringResource(key);
    }

    private class PasswordDialogRunnable
    implements Runnable {
        private String _title;
        private Object _lock;
        private volatile boolean _notFinished = true;
        private PasswordDialog _passwordDialog;
        private volatile boolean _cancelled = false;

        public PasswordDialogRunnable(String title, Object lock) {
            this._title = title;
            this._lock = lock;
            this._passwordDialog = new PasswordDialog(title);
        }

        public void run() {
            try {
                int returnCode = VisualConnectionCallback.this.MEDIATOR.showPasswordDialog(this._passwordDialog);
                if (returnCode == 78) {
                    this._cancelled = true;
                }
                Object object = this._lock;
                synchronized (object) {
                    this._notFinished = false;
                    this._lock.notifyAll();
                }
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "PasswordDialog");
            }
        }

        public boolean notFinished() {
            return this._notFinished;
        }

        public User getUser() {
            if (this._cancelled) {
                return new User("", "");
            }
            return new User(this._passwordDialog.getUsername(), this._passwordDialog.getPassword());
        }
    }

    private class RemoveUpload
    implements Runnable {
        private Uploader mgr;

        public RemoveUpload(Uploader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.UPLOAD_MEDIATOR.remove(this.mgr);
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "RemoveUpload");
            }
        }
    }

    private class AddUpload
    implements Runnable {
        private Uploader up;

        public AddUpload(Uploader up) {
            this.up = up;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.UPLOAD_MEDIATOR.add(this.up);
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "AddUpload");
            }
        }
    }

    private class RemoveDownload
    implements Runnable {
        private Downloader mgr;

        public RemoveDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.DOWNLOAD_MEDIATOR.remove(this.mgr);
                VisualConnectionCallback.this.LIBRARY_MEDIATOR.refreshIfIncomplete();
                SearchMediator.updateResults();
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "RemoveDownload");
            }
        }
    }

    private class AddDownload
    implements Runnable {
        private Downloader mgr;

        public AddDownload(Downloader mgr) {
            this.mgr = mgr;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.DOWNLOAD_MEDIATOR.add(this.mgr);
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "AddDownload");
            }
        }
    }

    private class HandleQueryString
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addQueryString(String query) {
            this.list.add(query);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            try {
                while (this.list.size() > 0) {
                    String query = (String)this.list.elementAt(0);
                    this.list.remove(0);
                    VisualConnectionCallback.this.MONITOR_VIEW.handleQueryString(query);
                }
                this.active = false;
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "HandleQueryString");
            }
        }
    }

    private class ConnectionClosed
    implements Runnable {
        private Connection c;

        public ConnectionClosed(Connection c) {
            this.c = c;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.CONNECTION_MEDIATOR.remove(this.c);
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "ConnectionClosed");
            }
        }
    }

    private class ConnectionInitialized
    implements Runnable {
        private Connection c;

        public ConnectionInitialized(Connection c) {
            this.c = c;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.CONNECTION_MEDIATOR.update(this.c);
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "ConnectionInitialized");
            }
        }
    }

    private class ConnectionInitializing
    implements Runnable {
        private Connection c;

        public ConnectionInitializing(Connection c) {
            this.c = c;
        }

        public void run() {
            try {
                VisualConnectionCallback.this.CONNECTION_MEDIATOR.add(this.c);
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e, "ConnectionInitializing");
            }
        }
    }
}

