/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.connection;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadConnectionSettingException;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.connection.ConnectionButtons;
import com.limegroup.gnutella.gui.connection.ConnectionModel;
import com.limegroup.gnutella.gui.tables.AbstractTableMediator;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.sun.java.util.collections.Arrays;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public final class ConnectionMediator
extends AbstractTableMediator {
    private static final ConnectionMediator INSTANCE = new ConnectionMediator();
    ActionListener ADD_LISTENER;
    DocumentListener KEEP_ALIVE_LISTENER;
    private static final String IS_ULTRAPEER = GUIMediator.getStringResource("CV_STRING_ULTRAPEER");
    private static final String IS_LEAF = GUIMediator.getStringResource("CV_STRING_CLIENT");
    private static final String CONNECTING = GUIMediator.getStringResource("CV_TABLE_STRING_CONNECTINGS");
    private static final String LEAVES = GUIMediator.getStringResource("CV_TABLE_STRING_LEAVES");
    private static final String ULTRAPEERS = GUIMediator.getStringResource("CV_TABLE_STRING_ULTRAPEERS");
    private static final String PEERS = GUIMediator.getStringResource("CV_TABLE_STRING_PEERS");
    private static final String STANDARD = GUIMediator.getStringResource("CV_TABLE_STRING_STANDARDS");
    private AutoCompleteTextField HOST_INPUT;
    private JTextField PORT_INPUT;
    private JTextField MIN_CONNECTIONS_INPUT;
    private JLabel SERVENT_STATUS;
    private JLabel NEIGHBORS;
    private boolean disableKeepAliveValidate;

    public static ConnectionMediator instance() {
        return INSTANCE;
    }

    protected void buildListeners() {
        super.buildListeners();
        this.ADD_LISTENER = new AddListener();
        this.KEEP_ALIVE_LISTENER = new KeepAliveListener();
    }

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID){

            public boolean getDefaultTooltips() {
                return false;
            }
        };
    }

    protected void addListeners() {
        super.addListeners();
        this.HOST_INPUT.addActionListener(this.ADD_LISTENER);
        this.MIN_CONNECTIONS_INPUT.getDocument().addDocumentListener(this.KEEP_ALIVE_LISTENER);
    }

    protected void setupConstants() {
        this.MAIN_PANEL = new PaddedPanel(GUIMediator.getStringResource("CV_PANEL_TITLE"));
        this.DATA_MODEL = new ConnectionModel();
        this.TABLE = new LimeJTable(this.DATA_MODEL);
        this.BUTTON_ROW = new ConnectionButtons(this).getComponent();
        this.HOST_INPUT = new AutoCompleteTextField(20);
        this.PORT_INPUT = new WholeNumberField(6346, 4);
        this.SERVENT_STATUS = new JLabel("");
        this.MIN_CONNECTIONS_INPUT = new WholeNumberField(0, 2);
        this.NEIGHBORS = new JLabel("");
    }

    protected JComponent getScrolledTablePane() {
        JComponent pane = super.getScrolledTablePane();
        this.SCROLL_PANE.setPreferredSize(new Dimension(3000, 5000));
        return pane;
    }

    protected void updateSplashScreen() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_CONNECTION_WINDOW"));
    }

    protected void setupMainPanel() {
        if (this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.NEIGHBORS);
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            JPanel line1 = new JPanel();
            line1.setLayout(new FlowLayout());
            line1.add(this.SERVENT_STATUS);
            line1.add(this.BUTTON_ROW);
            line1.add(this.HOST_INPUT);
            line1.add(this.PORT_INPUT);
            this.MAIN_PANEL.add(line1);
            if (ConnectionSettings.SHOW_KEEP_ALIVE.getValue()) {
                JPanel line2 = new JPanel();
                line2.setLayout(new FlowLayout());
                line2.add(new JLabel(GUIMediator.getStringResource("CV_LABEL_KEEP_BEGIN") + " "));
                line2.add(this.MIN_CONNECTIONS_INPUT);
                this.setKeepAliveText(Integer.toString(ConnectionSettings.NUM_CONNECTIONS.getValue()));
                line2.add(new JLabel(" " + GUIMediator.getStringResource("CV_LABEL_KEEP_END")));
                this.MAIN_PANEL.add(line2);
            }
            this.MAIN_PANEL.setMinimumSize(AbstractTableMediator.ZERO_DIMENSION);
        }
    }

    private ConnectionMediator() {
        super("CONNECTION_TABLE");
        GUIMediator.addRefreshListener(this);
        GUIMediator.addThemeObserver(this);
    }

    public void removeSelection() {
        int[] sel = this.TABLE.getSelectedRows();
        Arrays.sort(sel);
        int counter = sel.length - 1;
        while (counter >= 0) {
            int i = sel[counter];
            ManagedConnection c = (ManagedConnection)this.DATA_MODEL.get(i).getInitializeObject();
            RouterService.removeConnection(c);
            --counter;
        }
        this.clearSelection();
    }

    protected JPopupMenu createPopupMenu() {
        return null;
    }

    public void handleSelection(int row) {
        this.setButtonEnabled(0, true);
    }

    public void handleNoSelection() {
        this.setButtonEnabled(0, false);
    }

    public void handleMouseDoubleClick(MouseEvent e) {
        this.doBrowseHost();
    }

    private void doBrowseHost() {
        int[] rows = this.TABLE.getSelectedRows();
        if (rows.length > 0) {
            ManagedConnection c = (ManagedConnection)this.DATA_MODEL.get(rows[0]).getInitializeObject();
            GUIMediator.instance().doBrowseHost(c.getAddress(), c.getPort());
        }
    }

    public void doRefresh() {
        super.doRefresh();
        this.SERVENT_STATUS.setText((RouterService.isSupernode() ? IS_ULTRAPEER : IS_LEAF) + "      ");
        int[] counts = ((ConnectionModel)this.DATA_MODEL).getConnectionInfo();
        ConnectionModel cm = (ConnectionModel)this.DATA_MODEL;
        this.NEIGHBORS.setText("( " + counts[1] + " " + ULTRAPEERS + ", " + counts[2] + " " + PEERS + ", " + counts[3] + " " + LEAVES + ", " + counts[0] + " " + CONNECTING + ", " + counts[4] + " " + STANDARD + " )");
    }

    public void processKeepAliveChange(JTextField source) {
        String val = source.getText();
        if (val == null || val.equals("") || this.disableKeepAliveValidate) {
            return;
        }
        int n = Integer.parseInt(val);
        if (source == this.MIN_CONNECTIONS_INPUT) {
            try {
                RouterService.setKeepAlive(n);
                ConnectionSettings.NUM_CONNECTIONS.setValue(n);
            }
            catch (BadConnectionSettingException e) {
                int reason = e.getReason();
                if (reason == 2) {
                    this.showMessage("ERROR_KEEP_ALIVE");
                } else if (reason == 4) {
                    this.showMessage("ERROR_TOO_LOW_FOR_ULTRAPEER");
                } else if (reason == 3) {
                    this.showMessage("ERROR_TOO_HIGH_FOR_LEAF");
                }
                this.processKeepAliveSuggestion(e);
            }
        } else {
            Assert.that(false, "Unknown connection property");
        }
    }

    private void processKeepAliveSuggestion(BadConnectionSettingException e) {
        final int outgoing = e.getSuggestedOutgoing();
        ConnectionSettings.NUM_CONNECTIONS.setValue(outgoing);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ConnectionMediator.this.disableKeepAliveValidate = true;
                ConnectionMediator.this.MIN_CONNECTIONS_INPUT.setText(String.valueOf(outgoing));
                ConnectionMediator.this.disableKeepAliveValidate = false;
            }
        });
        RouterService.forceKeepAlive(outgoing);
    }

    public int getConnectingCount() {
        return ((ConnectionModel)this.DATA_MODEL).getConnectingCount();
    }

    public void setKeepAliveText(String val) {
        this.disableKeepAliveValidate = true;
        this.MIN_CONNECTIONS_INPUT.setText(val);
        this.disableKeepAliveValidate = false;
    }

    private void tryConnection(String hostname, int portnum) {
        RouterService.connectToHostAsynchronously(hostname, portnum);
    }

    public void clearConnections() {
        this.DATA_MODEL.clear();
        this.setKeepAliveText("0");
    }

    void addKnownHost(String host, int port) {
    }

    private void showMessage(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                GUIMediator.showError(message);
            }
        });
    }

    private final class KeepAliveListener
    implements DocumentListener {
        private KeepAliveListener() {
        }

        public void insertUpdate(DocumentEvent e) {
            ConnectionMediator.this.processKeepAliveChange(this.source(e));
        }

        public void removeUpdate(DocumentEvent e) {
            ConnectionMediator.this.processKeepAliveChange(this.source(e));
        }

        public void changedUpdate(DocumentEvent e) {
        }

        private JTextField source(DocumentEvent e) {
            Document doc = e.getDocument();
            if (doc == ConnectionMediator.this.MIN_CONNECTIONS_INPUT.getDocument()) {
                return ConnectionMediator.this.MIN_CONNECTIONS_INPUT;
            }
            Assert.that(false, "Unknown connection property");
            return null;
        }
    }

    private final class AddListener
    implements ActionListener {
        private AddListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String hostnamestr = ConnectionMediator.this.HOST_INPUT.getText();
                String portstr = ConnectionMediator.this.PORT_INPUT.getText();
                int idx = hostnamestr.lastIndexOf(58);
                if (idx != -1) {
                    ConnectionMediator.this.PORT_INPUT.setText(hostnamestr.substring(idx + 1));
                    portstr = ConnectionMediator.this.PORT_INPUT.getText();
                    ConnectionMediator.this.HOST_INPUT.setText(hostnamestr.substring(0, idx));
                    hostnamestr = ConnectionMediator.this.HOST_INPUT.getText();
                }
                int portnum = -1;
                try {
                    portnum = Integer.parseInt(portstr);
                }
                catch (Exception ee) {
                    portnum = 6346;
                }
                if (!hostnamestr.equals("")) {
                    ConnectionMediator.this.tryConnection(hostnamestr, portnum);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

