/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.FileScan;
import com.limegroup.gnutella.gui.init.FinishWindow;
import com.limegroup.gnutella.gui.init.LanguageWindow;
import com.limegroup.gnutella.gui.init.SaveWindow;
import com.limegroup.gnutella.gui.init.ScanConfirmWindow;
import com.limegroup.gnutella.gui.init.ScanWindow;
import com.limegroup.gnutella.gui.init.SetupButtons;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.init.SetupWindowHolder;
import com.limegroup.gnutella.gui.init.SpeedWindow;
import com.limegroup.gnutella.gui.init.StartupWindow;
import com.limegroup.gnutella.gui.init.WaitWindow;
import com.limegroup.gnutella.gui.init.WelcomeWindow;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.InstallSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SetupManager {
    private JDialog _dialog;
    private SetupButtons _setupButtons;
    private SetupWindowHolder _setupWindowHolder;
    private SetupWindow _currentWindow;
    private String[] _scannedPaths;
    private boolean _scanned = false;

    public SetupManager() {
        if (ApplicationSettings.INSTALLED.getValue()) {
            InstallSettings.SAVE_DIRECTORY.setValue(true);
            InstallSettings.SPEED.setValue(true);
            InstallSettings.SCAN_FILES.setValue(true);
        }
    }

    public void createIfNeeded() {
        LinkedList windows = new LinkedList();
        if (!InstallSettings.LANGUAGE_CHOICE.getValue() && CommonUtils.isMacOSX()) {
            windows.add(new LanguageWindow(this));
        }
        if (!InstallSettings.SAVE_DIRECTORY.getValue()) {
            windows.add(new SaveWindow(this));
        }
        if (!InstallSettings.SPEED.getValue()) {
            windows.add(new SpeedWindow(this));
        }
        if (!InstallSettings.START_STARTUP.getValue() && CommonUtils.isMacOSX() && CommonUtils.isJava14OrLater() && CommonUtils.isCocoaFoundationAvailable()) {
            windows.add(new StartupWindow(this));
        }
        if (!InstallSettings.SCAN_FILES.getValue()) {
            windows.add(new ScanWindow(this));
            windows.add(new WaitWindow(this));
            windows.add(new ScanConfirmWindow(this));
        }
        if (windows.size() == 0) {
            return;
        }
        boolean partial = ApplicationSettings.INSTALLED.getValue();
        if (windows.get(0) instanceof LanguageWindow) {
            if (windows.size() > 1) {
                windows.add(1, new WelcomeWindow(this, partial));
                windows.add(new FinishWindow(this));
            }
        } else {
            windows.add(0, new WelcomeWindow(this, partial));
            windows.add(new FinishWindow(this));
        }
        this._setupWindowHolder = new SetupWindowHolder();
        SetupWindow prior = null;
        SetupWindow current = null;
        ScanWindow scanner = null;
        Iterator i = windows.iterator();
        while (i.hasNext()) {
            current = (SetupWindow)i.next();
            this._setupWindowHolder.add(current);
            if (prior == null) {
                current.setPrevious(current);
            } else {
                current.setPrevious(prior);
            }
            if (current instanceof ScanWindow) {
                scanner = (ScanWindow)current;
            } else if (current instanceof WaitWindow) {
                scanner.setYesWindow(current);
            } else if (current instanceof ScanConfirmWindow) {
                current.setPrevious(scanner);
            }
            if (prior != null) {
                prior.setNext(current);
            }
            prior = current;
        }
        if (scanner != null) {
            scanner.setNoWindow((SetupWindow)windows.get(windows.size() - 1));
        }
        current.setNext(current);
        this.createDialog((SetupWindow)windows.get(0));
    }

    private void createDialog(SetupWindow firstWindow) {
        this._dialog = new JDialog();
        this._dialog.setModal(true);
        if (!CommonUtils.isUnix()) {
            this._dialog.setResizable(false);
        }
        this._dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SetupManager.this.cancelSetup();
            }
        });
        Container container = this._dialog.getContentPane();
        BoxLayout containerLayout = new BoxLayout(container, 1);
        container.setLayout(containerLayout);
        JPanel setupPanel = new JPanel();
        BoxLayout layout = new BoxLayout(setupPanel, 1);
        setupPanel.setLayout(layout);
        Dimension d = new Dimension(500, 300);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this._dialog).setLocation((screenSize.width - d.width) / 2, (screenSize.height - d.height) / 2);
        this._setupButtons = new SetupButtons(this);
        setupPanel.add(this._setupWindowHolder);
        setupPanel.add(Box.createVerticalStrut(17));
        setupPanel.add(this._setupButtons);
        this.show(firstWindow);
        container.add(setupPanel);
        this._dialog.pack();
        ((Component)this._dialog).setVisible(true);
    }

    public void next() {
        SetupWindow newWindow = this._currentWindow.getNext();
        try {
            this._currentWindow.applySettings();
            this.show(newWindow);
        }
        catch (ApplySettingsException ase) {
            GUIMediator.showError(ase.getMessage());
        }
    }

    public void previous() {
        SetupWindow newWindow = this._currentWindow.getPrevious();
        this.show(newWindow);
    }

    public void scan() {
        if (!this._scanned) {
            this._scannedPaths = this.scanDrive();
            this._scanned = true;
        }
    }

    public String[] getScannedPaths() {
        return this._scannedPaths;
    }

    public void cancelSetup() {
        this._dialog.dispose();
        System.exit(0);
    }

    public void finishSetup() {
        this._dialog.dispose();
        ApplicationSettings.INSTALLED.setValue(true);
        InstallSettings.SAVE_DIRECTORY.setValue(true);
        InstallSettings.SPEED.setValue(true);
        InstallSettings.SCAN_FILES.setValue(true);
        if (CommonUtils.isMacOSX()) {
            if (CommonUtils.isJava14OrLater()) {
                InstallSettings.START_STARTUP.setValue(true);
            }
            InstallSettings.LANGUAGE_CHOICE.setValue(true);
        }
        SettingsHandler.save();
    }

    public void remakeButtons() {
        this._setupButtons.reconstruct(this);
    }

    public void goToFinishButtons() {
        this._setupButtons.goToFinishButtons();
    }

    public void goToCancelButtons() {
        this._setupButtons.goToCancelButtons();
    }

    public void goToStandardButtons() {
        this._setupButtons.goToStandardButtons();
    }

    public void goToNextButtons() {
        this._setupButtons.goToNextButtons();
    }

    private void show(SetupWindow window) {
        window.handleWindowOpeningEvent();
        this._setupWindowHolder.show(window.getKey());
        this._dialog.setTitle(window.getName());
        this._currentWindow = window;
    }

    private String[] scanDrive() {
        FileScan fs = new FileScan();
        String[] filters = new String[]{"Recycle", "Incomplete", "LimeWire", "Microsoft", "bin", "system", "WINNT"};
        fs.setFilters(filters);
        File root = this.getRoot(CommonUtils.getCurrentDirectory());
        try {
            fs.scan(root.getCanonicalPath());
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return fs.getListAsArray();
    }

    private File getRoot(File f) {
        String parent = f.getParent();
        if (parent == null) {
            return f;
        }
        return this.getRoot(new File(parent));
    }
}

