/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.library.LibraryConstructor;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public final class LibraryMediator
implements ThemeObserver {
    private static final LibraryMediator INSTANCE = new LibraryMediator();
    private static final LibraryTree LIBRARY_TREE = new LibraryTree();
    private static final LibraryTableMediator LIBRARY_TABLE = LibraryTableMediator.instance();
    private static final LibraryConstructor LIBRARY_CONSTRUCTOR = new LibraryConstructor(LIBRARY_TABLE, LIBRARY_TREE);
    private final PlayListGUI PLAY_LIST = PlayListGUI.instance();
    private final HandleFileUpdate FILE_UPDATER = new HandleFileUpdate();

    public static LibraryMediator instance() {
        return INSTANCE;
    }

    private LibraryMediator() {
        GUIMediator.setSplashScreenString(GUIMediator.getStringResource("SPLASH_STATUS_LIBRARY_WINDOW"));
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        LIBRARY_CONSTRUCTOR.updateTheme();
        LIBRARY_TREE.updateTheme();
    }

    public JComponent getComponent() {
        return LIBRARY_CONSTRUCTOR.getComponent();
    }

    public void launch() {
        LIBRARY_TABLE.launch();
    }

    public void deleteLibraryFile() {
        LIBRARY_TABLE.removeSelection();
    }

    public void clearLibrary() {
        LIBRARY_TREE.clear();
        LIBRARY_TABLE.clearTable();
    }

    public void refresh() {
        LIBRARY_TABLE.clearTable();
        if (LIBRARY_TREE.incompleteDirectoryIsSelected()) {
            this.showIncompleteFiles();
        } else {
            if (LIBRARY_TREE.getSelectedDirectory() != null) {
                this.loadShareableFiles(LIBRARY_TREE.getSelectedDirectory());
                LIBRARY_TABLE.forceResort();
            }
            FileManager fm = RouterService.getFileManager();
            fm.loadSettings(false);
        }
    }

    public void refreshIfIncomplete() {
        if (LIBRARY_TREE.incompleteDirectoryIsSelected()) {
            this.refresh();
        }
    }

    public void cancelEditing() {
        LIBRARY_TREE.cancelEditing();
    }

    public static void launchExplorer() {
        File[] sharedDirectories = LIBRARY_TREE.getSharedDirectories();
        File exploreDir = null;
        if (sharedDirectories != null && sharedDirectories.length > 0) {
            exploreDir = sharedDirectories[0];
        }
        if (LIBRARY_TREE.getSelectedDirectory() != null) {
            exploreDir = LIBRARY_TREE.getSelectedDirectory();
        }
        if (exploreDir == null) {
            return;
        }
        try {
            String explorePath = exploreDir.getCanonicalPath();
            String cmdStr = "";
            if (CommonUtils.isWindows()) {
                cmdStr = "explorer";
            } else if (CommonUtils.isMacOSX()) {
                cmdStr = "open";
            }
            Runtime.getRuntime().exec(new String[]{cmdStr, explorePath});
        }
        catch (SecurityException se) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addSharedLibraryFolder() {
        File dir = FileChooserHandler.getInputDirectory();
        if (dir == null || !dir.isDirectory() || !dir.canRead()) {
            GUIMediator.showError("ERROR_INVALID_SHARED_DIRECTORY");
            return;
        }
        try {
            SharingSettings.addDirectory(dir);
            RouterService.getFileManager().loadSettings(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void handleRootSharedDirectoryChange() {
        File[] sharedDirectories = LIBRARY_TREE.getSharedDirectories();
        SharingSettings.DIRECTORIES_TO_SHARE.setValue(sharedDirectories);
        RouterService.getFileManager().loadSettings(true);
    }

    public void addSharedDirectory(File dir, File parent) {
        LIBRARY_TREE.addSharedDirectory(dir, parent);
    }

    public void addSharedFile(FileDesc file, File parent) {
        if (LIBRARY_TREE.parentIsSelected(parent)) {
            LIBRARY_TABLE.add(file);
        }
    }

    public void updateSharedFile(File file) {
        File selDir = LIBRARY_TREE.getSelectedDirectory();
        if (selDir != null && selDir.equals(FileUtils.getParentFile(file)) && LIBRARY_TABLE.getTable().isShowing()) {
            this.FILE_UPDATER.addFileUpdate(file);
        }
    }

    public void setAnnotateEnabled(boolean enabled) {
        LIBRARY_TABLE.setAnnotateEnabled(enabled);
    }

    public void addNewLibraryFolder() {
        LIBRARY_TREE.addNewLibraryFolder();
    }

    public void unshareLibraryFolder() {
        LIBRARY_TREE.unshareLibraryFolder();
    }

    public void renameLibraryFolder() {
        LIBRARY_TREE.renameLibraryFolder();
    }

    void addFileToPlayList(File toAdd) {
        this.PLAY_LIST.addFileToPlayList(toAdd);
    }

    void launchAudio(File toPlay) {
        this.PLAY_LIST.launchAudio(toPlay);
    }

    void updateTableFiles(File selectedDir) {
        FileDesc[] files = RouterService.getSharedFileDescriptors(selectedDir);
        LIBRARY_TABLE.clearTable();
        LIBRARY_TABLE.setResumeEnabled(false);
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                LIBRARY_TABLE.addUnsorted(files[i]);
                ++i;
            }
        }
        if (RouterService.getNumPendingShared() > 0) {
            this.loadShareableFiles(selectedDir);
        }
        LIBRARY_TABLE.forceResort();
    }

    void loadShareableFiles(File dir) {
        File[] pending = FileUtils.listFiles(dir);
        if (pending != null) {
            int i = 0;
            while (i < pending.length) {
                if (FileManager.isFileShareable(pending[i], pending[i].length())) {
                    LIBRARY_TABLE.addUnsorted(pending[i]);
                }
                ++i;
            }
        }
    }

    void showIncompleteFiles() {
        String[] fileNames;
        LIBRARY_TABLE.clearTable();
        File incFile = SharingSettings.INCOMPLETE_DIRECTORY.getValue();
        if (incFile == null) {
            return;
        }
        LIBRARY_TABLE.setResumeEnabled(true);
        FileDesc[] files = RouterService.getIncompleteFileDescriptors();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                LIBRARY_TABLE.addUnsorted(files[i]);
                ++i;
            }
        }
        if ((fileNames = incFile.list()) != null) {
            int i = 0;
            while (i < fileNames.length) {
                File curFile;
                if (!fileNames[i].equals("downloads.dat") && !fileNames[i].equals("downloads.bak") && (curFile = new File(incFile, fileNames[i])).isFile()) {
                    LIBRARY_TABLE.addUnsorted(curFile);
                }
                ++i;
            }
        }
        LIBRARY_TABLE.forceResort();
    }

    boolean canDragAndDrop() {
        return LIBRARY_TABLE.canDragAndDrop();
    }

    void setMultiSelection(boolean multiSelection) {
        LIBRARY_TABLE.setMultiSelection(multiSelection);
    }

    boolean getTableMultiSelection() {
        return LIBRARY_TABLE.getMultiSelection();
    }

    void handleDropToTreePoint(Point mousePoint) {
        File file = LIBRARY_TREE.getFileForPoint(mousePoint);
        boolean droppingToIncomplete = LIBRARY_TREE.droppingToIncompleteFolder(mousePoint);
        boolean draggingFromIncomplete = LIBRARY_TREE.incompleteDirectoryIsSelected();
        if (file != null) {
            String newFilePath = "";
            try {
                newFilePath = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                return;
            }
            int[] rows = LIBRARY_TABLE.getSelectedRows();
            int length = rows.length - 1;
            while (length >= 0) {
                File newFile;
                File oldFile = LIBRARY_TABLE.getFile(rows[length]);
                boolean renamed = oldFile.renameTo(newFile = new File(newFilePath, oldFile.getName()));
                if (renamed) {
                    if (droppingToIncomplete) {
                        this.handleDropToIncomplete(oldFile);
                    } else if (draggingFromIncomplete) {
                        this.handleDragFromIncomplete(newFile);
                    } else {
                        this.handleStandardDragAndDrop(oldFile, newFile);
                    }
                }
                --length;
            }
        }
    }

    void setCursors(Cursor cursor) {
        LIBRARY_TREE.setCursor(cursor);
        LIBRARY_TABLE.setCursor(cursor);
    }

    Point getTableLocation() {
        return LIBRARY_TABLE.getTableLocation();
    }

    Point getTreeLocation() {
        return LIBRARY_TREE.getTreeLocation();
    }

    Dimension getTableSize() {
        return LIBRARY_TABLE.getTableSize();
    }

    Dimension getTreeSize() {
        return LIBRARY_TREE.getTreeSize();
    }

    int getTableIndexCandidate() {
        return LIBRARY_TABLE.getIndexCandidate();
    }

    ListSelectionModel getTableSelectionModel() {
        return LIBRARY_TABLE.getSelectionModel();
    }

    private void handleDropToIncomplete(File draggedFile) {
        RouterService.getFileManager().removeFileIfShared(draggedFile);
        this.updateTableFiles(LIBRARY_TREE.getSelectedDirectory());
    }

    private void handleDragFromIncomplete(File draggedFile) {
        RouterService.getFileManager().addFileIfShared(draggedFile);
        this.showIncompleteFiles();
    }

    private void handleStandardDragAndDrop(File oldFile, File newFile) {
        RouterService.getFileManager().renameFileIfShared(oldFile, newFile);
        this.updateTableFiles(LIBRARY_TREE.getSelectedDirectory());
    }

    public boolean incompleteDirectoryIsSelected() {
        return LIBRARY_TREE.incompleteDirectoryIsSelected();
    }

    private static final class HandleFileUpdate
    implements Runnable {
        private Vector list = new Vector();
        private boolean active = false;

        public void addFileUpdate(File f) {
            this.list.addElement(f);
            if (!this.active) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            try {
                while (this.list.size() > 0) {
                    File f = (File)this.list.firstElement();
                    this.list.removeElementAt(0);
                    LIBRARY_TABLE.update(f);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (Exception e) {
                GUIMediator.showInternalError(e);
            }
            this.active = false;
        }
    }
}

