/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.library.LibraryTableMediator;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

final class LibraryTableCellEditor
implements TableCellEditor {
    private JTextField _textField;
    private LibraryTableMediator _libraryTable;
    private CellEditorListener _cellEditorListener;

    LibraryTableCellEditor(LibraryTableMediator libraryTable) {
        this._libraryTable = libraryTable;
    }

    public Object getCellEditorValue() {
        String newName = this._textField.getText();
        return this._libraryTable.handleNameChange(newName);
    }

    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            return ((MouseEvent)event).getClickCount() == 1;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this._cellEditorListener = listener;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this._cellEditorListener = null;
    }

    void fireEditingStopped() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    void fireEditingCanceled() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        JTextField field = new JTextField();
        field.addActionListener(new TextFieldListener());
        field.setText(value != null ? value.toString() : "");
        field.selectAll();
        this._textField = field;
        return field;
    }

    private class TextFieldListener
    implements ActionListener {
        private TextFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                LibraryTableCellEditor.this.fireEditingStopped();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

