/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

final class HelpMenu
extends AbstractMenu {
    private final HelpListener HELP_LISTENER = new HelpListener();
    private final FAQListener FAQ_LISTENER = new FAQListener();
    private final ForumListener FORUM_LISTENER = new ForumListener();
    private final FriendListener FRIEND_LISTENER = new FriendListener();
    private final ReviewListener REVIEW_LISTENER = new ReviewListener();
    private final AboutListener ABOUT_LISTENER = new AboutListener();
    private final ErrorListener ERROR_LISTENER = new ErrorListener();
    private final TOTDListener TOTD_LISTENER = new TOTDListener();

    HelpMenu(String key) {
        super(key);
        this.addMenuItem("HELP_USING_LIMEWIRE", this.HELP_LISTENER);
        this.addMenuItem("HELP_TOTD", this.TOTD_LISTENER);
        this.addMenuItem("HELP_FAQ", this.FAQ_LISTENER);
        this.addMenuItem("HELP_FORUM", this.FORUM_LISTENER);
        this.addMenuItem("HELP_FRIEND", this.FRIEND_LISTENER);
        this.addMenuItem("HELP_REVIEW", this.REVIEW_LISTENER);
        if (!CommonUtils.isMacOSX()) {
            this.addSeparator();
            this.addMenuItem("HELP_ABOUT", this.ABOUT_LISTENER);
        }
        if (CommonUtils.isTestingVersion()) {
            this.addSeparator();
            this.addMenuItem("HELP_ERROR", this.ERROR_LISTENER);
        }
    }

    private class AboutListener
    implements ActionListener {
        private AboutListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                GUIMediator.showAboutWindow();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class ReviewListener
    implements ActionListener {
        private ReviewListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String url = CommonUtils.isWindows() ? "http://www.limewire.com/review/pc.htm" : (CommonUtils.isMacClassic() ? "http://www.limewire.com/review/mac_classic.htm" : (CommonUtils.isMacOSX() ? "http://www.limewire.com/review/mac_osx.htm" : (CommonUtils.isLinux() ? "http://www.limewire.com/review/linux.htm" : (CommonUtils.isSolaris() ? "http://www.limewire.com/review/linux.htm" : "http://www.limewire.com/review/pc.htm"))));
                try {
                    GUIMediator.openURL(url);
                }
                catch (IOException ex) {
                    String msgKey = "ERROR_LOCATING_BROWSER_GENERAL";
                    GUIMediator.showError(msgKey);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class FriendListener
    implements ActionListener {
        private FriendListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                try {
                    String url = "http://www.limewire.com/index.jsp/tell_friend";
                    GUIMediator.openURL(url);
                }
                catch (IOException ex) {
                    String msgKey = "ERROR_LOCATING_BROWSER_FRIEND";
                    GUIMediator.showError(msgKey);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class ForumListener
    implements ActionListener {
        private ForumListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                try {
                    String url = "http://www.limewire.com/forum.htm";
                    GUIMediator.openURL(url);
                }
                catch (IOException ex) {
                    String msgKey = "ERROR_LOCATING_BROWSER_FORUM";
                    GUIMediator.showError(msgKey);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class FAQListener
    implements ActionListener {
        private FAQListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                try {
                    String url = "http://www.limewire.com/support/faq.htm";
                    GUIMediator.openURL(url);
                }
                catch (IOException ex) {
                    String msgKey = "ERROR_LOCATING_BROWSER_FAQ";
                    GUIMediator.showError(msgKey);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class HelpListener
    implements ActionListener {
        private HelpListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                try {
                    String url = "http://www.limewire.com/support.htm";
                    GUIMediator.openURL(url);
                }
                catch (IOException ex) {
                    String msgKey = "ERROR_LOCATING_BROWSER_SUPPORT";
                    GUIMediator.showError(msgKey);
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class ErrorListener
    implements ActionListener {
        private ErrorListener() {
        }

        public void actionPerformed(ActionEvent e) {
            throw new RuntimeException("Generated Error");
        }
    }

    private class TOTDListener
    implements ActionListener {
        private TOTDListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                TipOfTheDayMediator.instance().displayTipWindow();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

