/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.gui.menu.SearchMenu;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;

final class ShowHideMenu
extends AbstractMenu {
    ShowHideMenu(String key) {
        super(key);
        this.addToggleMenuItem("VIEW_MONITOR", new ViewListener(1), ApplicationSettings.MONITOR_VIEW_ENABLED.getValue());
        this.addToggleMenuItem("VIEW_CONNECTIONS", new ViewListener(2), ApplicationSettings.CONNECTION_VIEW_ENABLED.getValue());
        this.addToggleMenuItem("VIEW_LIBRARY", new ViewListener(3), ApplicationSettings.LIBRARY_VIEW_ENABLED.getValue());
        this.MENU.add(new SearchMenu("VIEW_SEARCH").getMenu());
        if (!GUIMediator.hasDonated() && CommonUtils.isWindows() && GUIMediator.isBrowserPageLoaded()) {
            this.addToggleMenuItem("VIEW_SHOPPING", new ShoppingViewListener(4), ApplicationSettings.SHOPPING_VIEW_ENABLED.getValue());
        }
    }

    private static class ShoppingViewListener
    implements ActionListener {
        private final int INDEX;

        private ShoppingViewListener(int INDEX) {
            this.INDEX = INDEX;
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                AbstractButton button = (AbstractButton)ae.getSource();
                GUIMediator.instance().setTabVisible(this.INDEX, button.isSelected());
                GUIMediator.instance().setWindow(this.INDEX);
                GUIMediator.instance().wakeupShoppingView();
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e);
            }
        }
    }

    private static class ViewListener
    implements ActionListener {
        private final int INDEX;

        private ViewListener(int INDEX) {
            this.INDEX = INDEX;
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                AbstractButton button = (AbstractButton)ae.getSource();
                GUIMediator.instance().setTabVisible(this.INDEX, button.isSelected());
                GUIMediator.instance().setWindow(this.INDEX);
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e);
            }
        }
    }
}

