/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

final class ThemeMenu
extends AbstractMenu {
    private static final String THEME_PROPERTY = "THEME_NAME";
    private static final ActionListener THEME_CHANGER = new ThemeChangeListener();
    private static final ButtonGroup GROUP = new ButtonGroup();

    ThemeMenu(String key) {
        super(key);
        this.addMenuItem("VIEW_THEMES_GET_MORE", new GetThemesListener());
        this.addMenuItem("VIEW_THEMES_REFRESH", new RefreshThemesListener());
        JMenuItem def = this.addMenuItem("VIEW_THEMES_USE_DEFAULT", THEME_CHANGER);
        final String defaultVal = ThemeSettings.THEME_DEFAULT.getValue().getAbsolutePath();
        def.putClientProperty(THEME_PROPERTY, defaultVal);
        def.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                try {
                    ThemeMenu.setSelection(defaultVal);
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        });
        this.addSeparator();
        this.addThemeItems();
    }

    private static void setSelection(Object value) {
        Enumeration<AbstractButton> items = GROUP.getElements();
        while (items.hasMoreElements()) {
            JMenuItem item = (JMenuItem)items.nextElement();
            if (!value.equals(item.getClientProperty(THEME_PROPERTY))) continue;
            item.setSelected(true);
            break;
        }
    }

    private void addThemeItems() {
        File themeDir = ThemeSettings.THEME_DIR_FILE;
        if (!themeDir.exists()) {
            return;
        }
        String[] allThemes = themeDir.list(new ThemeFileFilter());
        if (allThemes == null) {
            return;
        }
        int i = 0;
        while (i < allThemes.length) {
            File themeFile = new File(themeDir, allThemes[i]);
            JRadioButtonMenuItem theme = new JRadioButtonMenuItem(ThemeSettings.formatName(themeFile.getName()));
            theme.setFont(AbstractMenu.FONT);
            GROUP.add(theme);
            if (themeFile.equals(ThemeSettings.THEME_FILE.getValue())) {
                theme.setSelected(true);
            }
            theme.addActionListener(THEME_CHANGER);
            theme.putClientProperty(THEME_PROPERTY, themeFile.getAbsolutePath());
            this.MENU.add(theme);
            ++i;
        }
    }

    private void removeThemeItems() {
        Enumeration<AbstractButton> items = GROUP.getElements();
        LinkedList removed = new LinkedList();
        while (items.hasMoreElements()) {
            JMenuItem item = (JMenuItem)items.nextElement();
            this.MENU.remove(item);
            removed.add(item);
        }
        Iterator itr = removed.iterator();
        while (itr.hasNext()) {
            GROUP.remove((JMenuItem)itr.next());
        }
    }

    private static void showThemeError(String name) {
        Dimension size = new Dimension(300, 100);
        final JDialog d = new JDialog(GUIMediator.getAppFrame());
        d.setModal(true);
        d.setResizable(false);
        d.setTitle(GUIMediator.getStringResource("ERROR_THEME_OUT_OF_DATE_TITLE"));
        d.setDefaultCloseOperation(2);
        BoxPanel body = new BoxPanel(1);
        BoxPanel text = new BoxPanel(1);
        MultiLineLabel label = new MultiLineLabel(GUIMediator.getStringResource("ERROR_THEME_OUT_OF_DATE"), 250);
        label.setFont(new Font("Dialog", 1, 12));
        text.add(Box.createVerticalGlue());
        text.add(GUIUtils.center(label));
        text.add(Box.createVerticalGlue());
        BoxPanel buttons = new BoxPanel(0);
        JButton getNew = new JButton(GUIMediator.getStringResource("ERROR_THEME_OUT_OF_DATE_GET_MORE"));
        JButton later = new JButton(GUIMediator.getStringResource("ERROR_THEME_OUT_OF_DATE_LATER"));
        getNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    GUIMediator.openURL("http://www.limewire.com/skins2");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                d.dispose();
                ((Component)d).setVisible(false);
            }
        });
        later.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                d.dispose();
                ((Component)d).setVisible(false);
            }
        });
        buttons.add(getNew);
        buttons.add(GUIMediator.getHorizontalSeparator());
        buttons.add(later);
        body.add(text);
        body.add(buttons);
        body.setPreferredSize(size);
        d.getContentPane().add(body);
        d.pack();
        d.setLocationRelativeTo(GUIMediator.getAppFrame());
        d.show();
    }

    public static class ThemeFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            if (!name.endsWith("lwtp")) {
                return false;
            }
            if (!CommonUtils.isMacOSX() && name.equals("default_osx_theme.lwtp")) {
                return false;
            }
            if (!CommonUtils.isWindows() && name.equals("windows_theme.lwtp")) {
                return false;
            }
            if (CommonUtils.isPro() && name.equals("limewire_theme.lwtp")) {
                return false;
            }
            return CommonUtils.isPro() || !name.equals("limewirePro_theme.lwtp");
        }
    }

    protected static class ThemeChangeListener
    implements ActionListener {
        protected ThemeChangeListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                JMenuItem item = (JMenuItem)e.getSource();
                String themePath = (String)item.getClientProperty(ThemeMenu.THEME_PROPERTY);
                File themeFile = new File(themePath);
                if (!themeFile.isFile()) {
                    GUIMediator.showError("ERROR_INVALID_THEME_FILE");
                } else if (!ThemeSettings.THEME_FILE.getValue().equals(themeFile)) {
                    File oldTheme = ThemeSettings.THEME_FILE.getValue();
                    ThemeSettings.THEME_FILE.setValue(themeFile);
                    ThemeFileHandler.reload();
                    if (!ThemeFileHandler.isCurrent()) {
                        ThemeMenu.showThemeError(item.getText());
                        ThemeSettings.THEME_FILE.setValue(oldTheme);
                        ThemeFileHandler.reload();
                        ThemeMenu.setSelection(oldTheme.getAbsolutePath());
                    } else if (CommonUtils.isMacClassic()) {
                        GUIMediator.showMessage("THEME_CHANGED_MESSAGE");
                    } else {
                        GUIMediator.instance().setCurrentTheme();
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class RefreshThemesListener
    implements ActionListener {
        private RefreshThemesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ThemeMenu.this.removeThemeItems();
                ThemeMenu.this.addThemeItems();
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private static class GetThemesListener
    implements ActionListener {
        private GetThemesListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String url = "http://www.limewire.com/skins2";
                GUIMediator.openURL(url);
            }
            catch (IOException ex) {
                GUIMediator.showError("ERROR_LOCATING_BROWSER_THEMES");
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

