/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.mp3.AbstractAudioPlayer;
import com.limegroup.gnutella.util.ManagedThread;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BasicPlayer
extends AbstractAudioPlayer
implements Runnable {
    private static final Log LOG = LogFactory.getLog(class$com$limegroup$gnutella$gui$mp3$BasicPlayer == null ? (class$com$limegroup$gnutella$gui$mp3$BasicPlayer = BasicPlayer.class$("com.limegroup.gnutella.gui.mp3.BasicPlayer")) : class$com$limegroup$gnutella$gui$mp3$BasicPlayer);
    private static final int EXTERNAL_BUFFER_SIZE = 16000;
    private Thread m_thread = null;
    private Object m_dataSource = null;
    private AudioInputStream m_audioInputStream = null;
    private AudioFileFormat m_audioFileFormat = null;
    private SourceDataLine m_line = null;
    private FloatControl m_gainControl = null;
    private FloatControl m_panControl = null;
    public static final int PAUSED = 1;
    public static final int PLAYING = 0;
    public static final int STOPPED = 2;
    public static final int READY = 3;
    private int m_status = 3;
    private long doSeek = -1L;
    private File _file = null;
    private int m_framesRead = 0;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$mp3$BasicPlayer;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public int getStatus() {
        switch (this.m_status) {
            case 1: {
                return 1;
            }
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
        }
        return 2;
    }

    public void unpause() {
        this.resumePlayback();
    }

    public void pause() {
        this.pausePlayback();
    }

    public void stop() {
        this.stopPlayback();
    }

    public void play(File toPlay) throws IOException {
        try {
            this.setDataSource(toPlay);
            this.startPlayback();
        }
        catch (UnsupportedAudioFileException ignored0) {
            GUIMediator.showError("PLAYLIST_CANNOT_PLAY_FILE", (Object)toPlay, "PLAYLIST_FILE_UNSUPPORTED");
        }
        catch (LineUnavailableException ignored1) {
            GUIMediator.showError("PLAYLIST_CANNOT_PLAY_FILE", (Object)toPlay, "PLAYLIST_LINE_UNAVAILABLE");
        }
        catch (FileNotFoundException ignored2) {
            GUIMediator.showError("PLAYLIST_CANNOT_PLAY_FILE", (Object)toPlay, "PLAYLIST_FILE_MISSING");
        }
        catch (EOFException ignored3) {
            GUIMediator.showError("PLAYLIST_CANNOT_PLAY_FILE", (Object)toPlay, "PLAYLIST_FILE_CORRUPT");
        }
    }

    public int getFrameSeek() {
        return 0;
    }

    public void refresh() {
        if (this.getStatus() == 0) {
            this.fireAudioPositionUpdated(this.m_framesRead);
        }
    }

    private void setDataSource(File file) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (file != null) {
            this.m_dataSource = file;
            this.initAudioInputStream();
        }
    }

    private void setDataSource(URL url) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (url != null) {
            this.m_dataSource = url;
            this.initAudioInputStream();
        }
    }

    private void initAudioInputStream() throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (this.m_dataSource instanceof URL) {
            this.initAudioInputStream((URL)this.m_dataSource);
        } else if (this.m_dataSource instanceof File) {
            this.initAudioInputStream((File)this.m_dataSource);
        }
    }

    private void initAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this._file = file;
        this.m_audioInputStream = AudioSystem.getAudioInputStream(file);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(file);
    }

    private void initAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        this.m_audioInputStream = AudioSystem.getAudioInputStream(url);
        this.m_audioFileFormat = AudioSystem.getAudioFileFormat(url);
    }

    protected void initLine() throws LineUnavailableException {
        if (this.m_line == null) {
            this.createLine();
            LOG.trace("Create Line OK ");
            this.openLine();
        } else {
            AudioFormat audioInputStreamFormat;
            AudioFormat lineAudioFormat = this.m_line.getFormat();
            AudioFormat audioFormat = audioInputStreamFormat = this.m_audioInputStream == null ? null : this.m_audioInputStream.getFormat();
            if (!lineAudioFormat.equals(audioInputStreamFormat)) {
                this.m_line.close();
                this.openLine();
            }
        }
    }

    private void createLine() throws LineUnavailableException {
        if (this.m_line == null) {
            AudioFormat sourceFormat = this.m_audioInputStream.getFormat();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Source format : " + sourceFormat);
            }
            AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, sourceFormat.getSampleRate(), false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Target format: " + targetFormat);
            }
            this.m_audioInputStream = AudioSystem.getAudioInputStream(targetFormat, this.m_audioInputStream);
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Create Line : " + audioFormat);
            }
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = BasicPlayer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat, -1);
            this.m_line = (SourceDataLine)AudioSystem.getLine(info);
            Control[] c = this.m_line.getControls();
            int p = 0;
            while (p < c.length) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Controls : " + c[p].toString());
                }
                ++p;
            }
            if (this.m_line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                this.m_gainControl = (FloatControl)this.m_line.getControl(FloatControl.Type.MASTER_GAIN);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Master Gain Control : [" + this.m_gainControl.getMinimum() + "," + this.m_gainControl.getMaximum() + "]," + this.m_gainControl.getPrecision());
                }
            }
            if (this.m_line.isControlSupported(FloatControl.Type.PAN)) {
                this.m_panControl = (FloatControl)this.m_line.getControl(FloatControl.Type.PAN);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Pan Control : [" + this.m_panControl.getMinimum() + "," + this.m_panControl.getMaximum() + "]," + this.m_panControl.getPrecision());
                }
            }
        }
    }

    private void openLine() throws LineUnavailableException {
        if (this.m_line != null) {
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            if (LOG.isDebugEnabled()) {
                LOG.debug("AudioFormat : " + audioFormat);
            }
            this.m_line.open(audioFormat, this.m_line.getBufferSize());
        }
    }

    private void stopPlayback() {
        if (this.m_status == 0 || this.m_status == 1) {
            if (this.m_line != null) {
                this.m_line.flush();
                this.m_line.stop();
            }
            this.m_status = 2;
            LOG.debug("Stop called");
        }
    }

    private void pausePlayback() {
        if (this.m_line != null && this.m_status == 0) {
            this.m_line.flush();
            this.m_line.stop();
            this.m_status = 1;
            LOG.debug("Pause called");
        }
    }

    private void resumePlayback() {
        if (this.m_line != null && this.m_status == 1) {
            this.m_line.start();
            this.m_status = 0;
            LOG.debug("Resume called");
        }
    }

    private String startPlayback() {
        if (this.m_status == 2 || this.m_status == 3) {
            LOG.debug("Start called");
            if (this.m_thread != null && this.m_thread.isAlive()) {
                LOG.debug("WARNING: old thread still running!!");
                int cnt = 0;
                while (this.m_status != 3) {
                    try {
                        if (this.m_thread != null) {
                            Thread.sleep(1000L);
                            if (++cnt > 2) {
                                this.m_thread.interrupt();
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.debug("Waiting Error", e);
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Waiting ... " + cnt);
                }
            }
            try {
                this.initLine();
            }
            catch (Exception e) {
                LOG.debug("cannot init Line", e);
                return "ERROR";
            }
            LOG.trace("Creating new ManagedThread");
            this.m_thread = new ManagedThread(this, "BasicPlayer");
            this.m_thread.setDaemon(true);
            this.m_thread.start();
            if (this.m_line != null) {
                this.m_line.start();
            }
        }
        return null;
    }

    public void run() {
        LOG.debug("Thread Running");
        int nBytesRead = 1;
        this.m_status = 0;
        int nBytesCursor = 0;
        byte[] abData = new byte[16000];
        float nFrameSize = this.m_line.getFormat().getFrameSize();
        float nFrameRate = this.m_line.getFormat().getFrameRate();
        float bytesPerSecond = nFrameSize * nFrameRate;
        int secondsTotal = Math.round((float)this.m_audioFileFormat.getByteLength() / bytesPerSecond);
        secondsTotal = (int)Math.round(this.getTotalLengthInSeconds());
        this.fireSeekSetupRequired(secondsTotal);
        while (nBytesRead != -1 && this.m_status != 2) {
            if (this.m_status == 0) {
                try {
                    if (this.doSeek > -1L) {
                        if (this.getAudioFileFormat() != null && this.getAudioFileFormat().getType().toString().startsWith("WAV")) {
                            if (secondsTotal != -1 && secondsTotal > 0) {
                                this.m_line.flush();
                                this.m_line.stop();
                                this.m_audioInputStream.close();
                                this.m_audioInputStream = AudioSystem.getAudioInputStream(this._file);
                                nBytesCursor = 0;
                                if ((long)this.m_audioFileFormat.getByteLength() - this.doSeek < (long)abData.length) {
                                    this.doSeek = this.m_audioFileFormat.getByteLength() - abData.length;
                                }
                                this.doSeek -= this.doSeek % 4L;
                                int toSkip = (int)this.doSeek;
                                while (toSkip > 0 && nBytesRead > 0) {
                                    nBytesRead = toSkip > abData.length ? this.m_audioInputStream.read(abData, 0, abData.length) : this.m_audioInputStream.read(abData, 0, toSkip);
                                    toSkip -= nBytesRead;
                                    nBytesCursor += nBytesRead;
                                }
                                this.m_line.start();
                            } else if (LOG.isDebugEnabled()) {
                                LOG.debug("Seek not supported for this InputStream : " + secondsTotal);
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Seek not supported for this InputStream : " + secondsTotal);
                        }
                        this.doSeek = -1L;
                    }
                    nBytesRead = this.m_audioInputStream.read(abData, 0, abData.length);
                }
                catch (Exception e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("InputStream error : (" + nBytesRead + ")", e);
                    }
                    e.printStackTrace();
                    this.m_status = 2;
                }
                if (nBytesRead < 0) continue;
                if ((float)nBytesRead % nFrameSize != 0.0f) {
                    nBytesRead = (int)((float)nBytesRead - (float)nBytesRead % nFrameSize);
                }
                int nBytesWritten = this.m_line.write(abData, 0, nBytesRead);
                this.m_framesRead = Math.round((float)(nBytesCursor += nBytesWritten) / bytesPerSecond);
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.debug("can't sleep", e);
            }
        }
        if (this.m_line != null) {
            try {
                try {
                    this.m_line.drain();
                    this.m_line.stop();
                    this.m_line.close();
                }
                catch (Exception e) {
                    LOG.trace("Cannot Free Audio ressources", e);
                    Object var10_14 = null;
                    this.m_line = null;
                }
                Object var10_13 = null;
                this.m_line = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                this.m_line = null;
                throw throwable;
            }
        }
        LOG.trace("Thread Stopped");
        this.m_status = 3;
        this.firePlayComplete();
    }

    public boolean hasGainControl() {
        return this.m_gainControl != null;
    }

    public void setGain(double fGain) {
        if (this.hasGainControl()) {
            double minGainDB = this.getMinimum();
            double ampGainDB = 0.5f * this.getMaximum() - this.getMinimum();
            double cste = Math.log(10.0) / 20.0;
            double valueDB = minGainDB + 1.0 / cste * Math.log(1.0 + (Math.exp(cste * ampGainDB) - 1.0) * fGain);
            this.m_gainControl.setValue((float)valueDB);
        }
    }

    public float getGain() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getValue();
        }
        return 0.0f;
    }

    public float getMaximum() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMaximum();
        }
        return 0.0f;
    }

    public float getMinimum() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMinimum();
        }
        return 0.0f;
    }

    public boolean hasPanControl() {
        return this.m_panControl != null;
    }

    public float getPrecision() {
        if (this.hasPanControl()) {
            return this.m_panControl.getPrecision();
        }
        return 0.0f;
    }

    public float getPan() {
        if (this.hasPanControl()) {
            return this.m_panControl.getValue();
        }
        return 0.0f;
    }

    public void setPan(float fPan) {
        if (this.hasPanControl()) {
            this.m_panControl.setValue(fPan);
        }
    }

    public void setSeek(double seek) throws IOException {
        long newPos;
        double length = -1.0;
        if (this.m_audioFileFormat != null && this.m_audioFileFormat.getByteLength() != -1) {
            length = this.m_audioFileFormat.getByteLength();
        }
        this.doSeek = newPos = Math.round(seek * length);
    }

    public AudioFormat getAudioFormat() {
        if (this.m_audioFileFormat != null) {
            return this.m_audioFileFormat.getFormat();
        }
        return null;
    }

    public AudioFileFormat getAudioFileFormat() {
        if (this.m_audioFileFormat != null) {
            return this.m_audioFileFormat;
        }
        return null;
    }

    public double getTotalLengthInSeconds() {
        double lenghtInSecond = 0.0;
        if (this.getAudioFileFormat() != null) {
            int FL = this.getAudioFileFormat().getFrameLength();
            int FS = this.getAudioFormat().getFrameSize();
            float SR = this.getAudioFormat().getSampleRate();
            float FR = this.getAudioFormat().getFrameRate();
            int TL = this.getAudioFileFormat().getByteLength();
            String type = this.getAudioFileFormat().getType().toString();
            String encoding = this.getAudioFormat().getEncoding().toString();
            if (FL != -1 && (type.startsWith("MP3") || type.startsWith("VORBIS"))) {
                StringTokenizer st = new StringTokenizer(type, "x");
                st.nextToken();
                st.nextToken();
                String totalMSStr = st.nextToken();
                lenghtInSecond = Math.round(Integer.parseInt(totalMSStr) / 1000);
            } else {
                int br = this.getBitRate();
                lenghtInSecond = br > 0 ? (double)(TL * 8 / br) : (double)((float)TL / ((float)FS * SR));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Type=" + type + " Encoding=" + encoding + " FL=" + FL + " FS=" + FS + " SR=" + SR + " FR=" + FR + " TL=" + TL + ", lenghtInSecond=" + lenghtInSecond);
            }
        }
        if (lenghtInSecond < 0.0) {
            lenghtInSecond = 0.0;
        }
        return lenghtInSecond;
    }

    public int getBitRate() {
        int bitRate = 0;
        if (this.getAudioFileFormat() != null) {
            int FL = this.getAudioFileFormat().getFrameLength();
            int FS = this.getAudioFormat().getFrameSize();
            float SR = this.getAudioFormat().getSampleRate();
            float FR = this.getAudioFormat().getFrameRate();
            int TL = this.getAudioFileFormat().getByteLength();
            String type = this.getAudioFileFormat().getType().toString();
            String encoding = this.getAudioFormat().getEncoding().toString();
            if (type != null && (type.startsWith("MP3") || type.startsWith("VORBIS"))) {
                StringTokenizer st = new StringTokenizer(type, "x");
                if (st.hasMoreTokens()) {
                    st.nextToken();
                    String bitRateStr = st.nextToken();
                    bitRate = Math.round(Integer.parseInt(bitRateStr));
                }
            } else {
                bitRate = Math.round((float)FS * FR * 8.0f);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Type=" + type + " Encoding=" + encoding + " FL=" + FL + " FS=" + FS + " SR=" + SR + " FR=" + FR + " TL=" + TL + ", bitRate=" + bitRate);
            }
        }
        if (bitRate <= 0 && this.m_line != null) {
            bitRate = Math.round((float)this.m_line.getFormat().getFrameSize() * this.m_line.getFormat().getFrameRate() * 8.0f);
        }
        return bitRate;
    }

    protected InputStream openInput(File file) throws IOException {
        FileInputStream fileIn = new FileInputStream(file);
        BufferedInputStream bufIn = new BufferedInputStream(fileIn);
        return bufIn;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

