/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.MediaButton;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.mp3.AudioPlayer;
import com.limegroup.gnutella.gui.mp3.AudioPlayerListener;
import com.limegroup.gnutella.gui.mp3.BasicPlayer;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.mp3.SongProgressBar;
import com.limegroup.gnutella.settings.ThemeSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.LinkedList;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class MediaPlayerComponent
implements AudioPlayerListener,
RefreshListener,
ThemeObserver {
    private static AudioPlayer myPlayer;
    private JProgressBar myProgressBar;
    private static PlayListGUI myPlayList;
    private static PlayThread myPlayThread;
    private File myCurrentPlayingFile = null;
    private int currBeginIndex = -1;
    private static final int STRING_SIZE_TO_SHOW = 24;
    private static int lastButtonPressed;
    private static final int PLAY_BUTTON_INDEX = 0;
    private static final int STOP_BUTTON_INDEX = 2;
    private static final MediaButton PLAY_BUTTON;
    private static final MediaButton PAUSE_BUTTON;
    private static final MediaButton STOP_BUTTON;
    private static final MediaButton FORWARD_BUTTON;
    private static final MediaButton REWIND_BUTTON;
    private static MediaPlayerComponent myInstance;
    private JPanel myMediaPanel = null;
    private final String INITIAL_DISPLAY_STRING = GUIMediator.getStringResource("MEDIA_PLAYER_DEFAULT_STRING");
    private String currentFileName;
    private Object cfnLock = new Object();
    int iterations = 0;
    private final boolean debugOn = false;

    public MediaPlayerComponent() {
        myPlayer = new BasicPlayer();
        myPlayer.addAudioPlayerListener(this);
        myPlayThread = new PlayThread();
        myPlayThread.start();
        myInstance = this;
        GUIMediator.addRefreshListener(this);
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        PLAY_BUTTON.updateTheme();
        PAUSE_BUTTON.updateTheme();
        STOP_BUTTON.updateTheme();
        FORWARD_BUTTON.updateTheme();
        REWIND_BUTTON.updateTheme();
        Dimension progressBarDimension = CommonUtils.isMacOSX() && ThemeSettings.THEME_FILE.getValue().equals(ThemeSettings.THEME_DEFAULT.getValue()) ? new Dimension(110, 25) : new Dimension(110, 15);
        this.myProgressBar.setMaximumSize(progressBarDimension);
        this.myProgressBar.setPreferredSize(progressBarDimension);
        this.myProgressBar.setString(this.INITIAL_DISPLAY_STRING);
    }

    private JPanel constructMediaPanel() {
        BoxPanel retPanel = new BoxPanel(0);
        BoxPanel buttonPanel = new BoxPanel(0);
        int tempWidth = 0;
        int tempHeight = 0;
        tempWidth += PLAY_BUTTON.getIcon().getIconWidth() + 2;
        tempHeight += PLAY_BUTTON.getIcon().getIconHeight() + 2;
        tempWidth += PAUSE_BUTTON.getIcon().getIconWidth() + 2;
        tempWidth += STOP_BUTTON.getIcon().getIconWidth() + 2;
        tempWidth += FORWARD_BUTTON.getIcon().getIconWidth() + 2;
        tempWidth += REWIND_BUTTON.getIcon().getIconWidth() + 2;
        this.myProgressBar = new SongProgressBar();
        Dimension progressBarDimension = CommonUtils.isMacOSX() ? new Dimension(110, 25) : new Dimension(110, 15);
        this.myProgressBar.setMaximumSize(progressBarDimension);
        this.myProgressBar.setPreferredSize(progressBarDimension);
        this.myProgressBar.setString(this.INITIAL_DISPLAY_STRING);
        PLAY_BUTTON.addActionListener(new PlayListener());
        PAUSE_BUTTON.addActionListener(new PauseListener());
        STOP_BUTTON.addActionListener(new StopListener());
        FORWARD_BUTTON.addActionListener(new NextListener());
        REWIND_BUTTON.addActionListener(new BackListener());
        this.myProgressBar.addChangeListener(new SeekChangeListener());
        this.updatePBValue(0);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.setMaximumSize(new Dimension(tempWidth, tempHeight));
        buttonPanel.setMinimumSize(new Dimension(tempWidth, tempHeight));
        buttonPanel.add(REWIND_BUTTON);
        buttonPanel.add(PLAY_BUTTON);
        buttonPanel.add(PAUSE_BUTTON);
        buttonPanel.add(STOP_BUTTON);
        buttonPanel.add(FORWARD_BUTTON);
        buttonPanel.add(Box.createHorizontalGlue());
        retPanel.add(Box.createVerticalGlue());
        retPanel.add(buttonPanel);
        retPanel.add(this.myProgressBar);
        retPanel.add(Box.createVerticalGlue());
        BoxPanel tempPanel = retPanel;
        retPanel = new BoxPanel(0);
        retPanel.add(Box.createHorizontalGlue());
        retPanel.add(tempPanel);
        myPlayList = PlayListGUI.instance();
        return retPanel;
    }

    private void debug(String out) {
    }

    public JPanel getMediaPanel() {
        if (this.myMediaPanel == null) {
            this.myMediaPanel = this.constructMediaPanel();
        }
        return this.myMediaPanel;
    }

    public static void launchAudio(File toPlay) {
        if (myInstance != null && toPlay != null) {
            switch (myPlayer.getStatus()) {
                case 2: {
                    myPlayThread.addFileToPlay(toPlay);
                    break;
                }
                case 0: {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(toPlay);
                    break;
                }
                case 1: {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(toPlay);
                }
            }
        }
    }

    void pauseSong() {
        if (myPlayer.getStatus() == 1) {
            if (myPlayer.getFrameSeek() != 0) {
                myPlayer.stop();
            } else {
                myPlayer.unpause();
            }
        } else {
            myPlayer.pause();
        }
    }

    public void playComplete() {
        this.updatePBValue(this.myProgressBar.getMaximum());
        this.updatePBString("");
        if (lastButtonPressed == 2 || !myPlayList.shouldRepeat()) {
            myPlayList.playComplete(true);
        } else {
            myPlayList.playComplete(false);
        }
        if (myPlayList.shouldRepeat() && lastButtonPressed != 2) {
            myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
        }
    }

    private void playPressedAndPaused() {
        if (myPlayer.getStatus() == 1 && myPlayer.getFrameSeek() == 0) {
            myPlayer.unpause();
        }
    }

    public void setUpSeek(int lengthInFrames) {
        try {
            this.updatePBValue(0);
            this.updatePBMaximum(lengthInFrames);
            Object object = this.cfnLock;
            synchronized (object) {
                this.currentFileName = this.myCurrentPlayingFile.getName();
                if (this.currentFileName.length() > 24) {
                    this.currentFileName = this.currentFileName + " *** " + this.currentFileName + " *** ";
                }
                this.updatePBString(this.currentFileName);
                this.currBeginIndex = -5;
            }
        }
        catch (Exception e) {
            GUIMediator.showInternalError(e);
        }
    }

    void skipSong() {
        if (myPlayer.getStatus() == 0 && myPlayList.shouldRepeat()) {
            myPlayer.stop();
        }
    }

    public static void audioFileDoubleClicked() {
        if (myInstance == null) {
            return;
        }
        switch (myPlayer.getStatus()) {
            case 2: {
                lastButtonPressed = 0;
                myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                break;
            }
            case 0: {
                if (!myPlayList.shouldRepeat()) {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                    break;
                }
                myInstance.skipSong();
                break;
            }
            case 1: {
                if (!myPlayList.shouldRepeat()) {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                    break;
                }
                myPlayer.stop();
                myInstance.skipSong();
            }
        }
    }

    void stopSong() {
        myPlayer.stop();
    }

    private void updatePBMaximum(final int update) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setMaximum(update);
            }
        });
    }

    private void updatePBString(final String update) {
        if (update == null) {
            new Throwable().printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setString(update);
            }
        });
    }

    private void updatePBValue(final int update) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setValue(update);
            }
        });
    }

    public void updateAudioPosition(int value) {
        this.updatePBValue(value);
        Object object = this.cfnLock;
        synchronized (object) {
            if (this.currentFileName == null) {
                return;
            }
            if (this.currentFileName.length() <= 24) {
                return;
            }
            Assert.that(this.currentFileName.length() > 48);
            this.currBeginIndex += 5;
            if (this.currBeginIndex + 24 >= this.currentFileName.length()) {
                this.currBeginIndex -= this.currentFileName.length() / 2;
            }
            this.updatePBString(this.currentFileName.substring(this.currBeginIndex, this.currBeginIndex + 24));
        }
    }

    public void refresh() {
        myPlayer.refresh();
    }

    static {
        myPlayThread = null;
        lastButtonPressed = -1;
        PLAY_BUTTON = new MediaButton("MEDIA_PLAY_BUTTON_TIP", "play_up.gif", "play_dn.gif");
        PAUSE_BUTTON = new MediaButton("MEDIA_PAUSE_BUTTON_TIP", "pause_up.gif", "pause_dn.gif");
        STOP_BUTTON = new MediaButton("MEDIA_STOP_BUTTON_TIP", "stop_up.gif", "stop_dn.gif");
        FORWARD_BUTTON = new MediaButton("MEDIA_FORWARD_BUTTON_TIP", "forward_up.gif", "forward_dn.gif");
        REWIND_BUTTON = new MediaButton("MEDIA_REWIND_BUTTON_TIP", "rewind_up.gif", "rewind_dn.gif");
    }

    private class PlayThread
    extends ManagedThread {
        private LinkedList list = new LinkedList();
        private Object lock = new Object();
        private boolean shouldRun = true;

        PlayThread() {
            super("PlayThread");
        }

        private void shutdown() {
            this.shouldRun = false;
        }

        public void managedRun() {
            MediaPlayerComponent.this.debug("PlayThread.run(): entered.");
            while (this.shouldRun) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.list.isEmpty()) {
                        try {
                            MediaPlayerComponent.this.debug("PlayThread.run(): waiting for a file.");
                            this.lock.wait();
                            MediaPlayerComponent.this.debug("PlayThread.run(): woken up.");
                        }
                        catch (InterruptedException ignored) {
                            // empty catch block
                        }
                    }
                }
                Assert.that(!this.list.isEmpty());
                MediaPlayerComponent.this.debug("PlayThread.run(): myPlayer.getStatus() = " + myPlayer.getStatus());
                if (myPlayer.getStatus() != 2) continue;
                File playFile = null;
                while (!this.list.isEmpty()) {
                    playFile = this.getFileToPlay();
                    try {
                        if (this.list.isEmpty()) {
                            Thread.sleep(250L);
                            continue;
                        }
                        Thread.sleep(50L);
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                }
                MediaPlayerComponent.this.debug("PlayThread.run(): playing file " + playFile);
                MediaPlayerComponent.this.myCurrentPlayingFile = playFile;
                try {
                    myPlayer.play(playFile);
                }
                catch (IOException ioe) {
                    GUIMediator.showInternalError(ioe);
                }
            }
        }

        public void addFileToPlay(File f) {
            if (f != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.list.addLast(f);
                    this.lock.notify();
                }
            }
        }

        private File getFileToPlay() {
            File retFile = null;
            Object object = this.lock;
            synchronized (object) {
                retFile = (File)this.list.removeFirst();
            }
            return retFile;
        }
    }

    private class SeekChangeListener
    implements ChangeListener {
        private SeekChangeListener() {
        }

        public void stateChanged(ChangeEvent ce) {
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                MediaPlayerComponent.this.pauseSong();
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e);
            }
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                if (myPlayer.getStatus() != 2) {
                    myPlayList.setBackwardsMode();
                    if (myPlayer.getStatus() == 1) {
                        myPlayer.unpause();
                    }
                    MediaPlayerComponent.this.skipSong();
                }
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e);
            }
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                if (myPlayer.getStatus() != 2) {
                    if (myPlayer.getStatus() == 1) {
                        myPlayer.unpause();
                    }
                    MediaPlayerComponent.this.skipSong();
                }
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e);
            }
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                lastButtonPressed = 2;
                MediaPlayerComponent.this.stopSong();
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e);
            }
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        public void actionPerformed(ActionEvent ae) {
            try {
                lastButtonPressed = 0;
                if (myPlayer.getStatus() == 1) {
                    MediaPlayerComponent.this.playPressedAndPaused();
                } else if (myPlayer.getStatus() == 2) {
                    myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                } else if (myPlayer.getStatus() == 0 && myPlayList.songIsSelected()) {
                    MediaPlayerComponent.this.skipSong();
                }
            }
            catch (Throwable e) {
                GUIMediator.showInternalError(e);
            }
        }
    }
}

