/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.mp3.PlayList;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.mp3.PlayingSongRenderer;
import com.limegroup.gnutella.mp3.MP3Info;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.sun.java.util.collections.ArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class PlayListGUI
extends PaddedPanel
implements MouseListener,
ThemeObserver {
    public static final String TEMP_PL_NAME = ".temp.m3u.LW";
    private static PlayListGUI _instance = null;
    private BasicTableModel _tableModel;
    private JTable _table;
    private PlayList _playList;
    private PlayList _tempPL;
    private boolean _repeatSongs = true;
    private boolean _shuffleSongs = false;
    private final JScrollPane SCROLL_PANE;
    private int _playIndex = -1;
    private ArrayList _unsavedFiles = new ArrayList();
    private File lastOpenedPlaylist;
    private File lastSavedPlaylist;
    private boolean debugOn = true;
    static /* synthetic */ Class class$java$lang$String;

    public boolean shouldRepeat() {
        return this._repeatSongs;
    }

    public int getPlayIndex() {
        return this._playIndex;
    }

    private void resetPlayIndex() {
        this._playIndex = -1;
    }

    public static PlayListGUI instance() {
        if (_instance == null) {
            _instance = new PlayListGUI();
        }
        return _instance;
    }

    private PlayListGUI() {
        super(GUIMediator.getStringResource("PLAYLIST_TITLE"));
        this._tableModel = new BasicTableModel();
        this._tableModel.addColumn(GUIMediator.getStringResource("PLAYLIST_TABLE_NAME"));
        this._tableModel.addColumn(GUIMediator.getStringResource("PLAYLIST_TABLE_LENGTH"));
        this._tableModel.addColumn(GUIMediator.getStringResource("PLAYLIST_TABLE_BITRATE"));
        this._table = new JTable(this._tableModel);
        this._table.setShowGrid(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.getColumnModel().getColumn(0).setPreferredWidth(450);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(20);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(20);
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = PlayListGUI.class$("java.lang.String")) : class$java$lang$String, new PlayingSongRenderer());
        this._table.addMouseListener(this);
        JTableHeader th = this._table.getTableHeader();
        th.addMouseListener(new SortTableListener());
        this.SCROLL_PANE = new JScrollPane(this._table);
        this.add(this.SCROLL_PANE);
        this.SCROLL_PANE.setPreferredSize(new Dimension(10000, 10000));
        String[] buttonLabelKeys = new String[]{"PLAYLIST_LOAD_BUTTON_LABEL", "PLAYLIST_SAVE_BUTTON_LABEL", "PLAYLIST_DELETE_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"PLAYLIST_LOAD_BUTTON_TIP", "PLAYLIST_SAVE_BUTTON_TIP", "PLAYLIST_DELETE_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new LoadListener(), new SaveListener(), new DeleteListener()};
        this.add(Box.createVerticalStrut(6));
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.add((Component)new ButtonRow(buttonLabelKeys, toolTipKeys, listeners, 0, 14), "West");
        JLabel playOptionsLabel = new JLabel(GUIMediator.getStringResource("PLAYLIST_OPTIONS_STRING"));
        final JCheckBox shuffleCheckBox = new JCheckBox(GUIMediator.getStringResource("PLAYLIST_OPTIONS_SHUFFLE"), false);
        shuffleCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PlayListGUI.this._shuffleSongs = !PlayListGUI.this._shuffleSongs;
                    PlayList plToToggle = PlayListGUI.this.getCurrentPlayList();
                    if (plToToggle != null && plToToggle.isShuffled() != PlayListGUI.this._shuffleSongs) {
                        plToToggle.toggleShuffle();
                    }
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        });
        JCheckBox repeatCheckBox = new JCheckBox(GUIMediator.getStringResource("PLAYLIST_OPTIONS_CONTINUE"), true);
        repeatCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PlayListGUI.this._repeatSongs = !PlayListGUI.this._repeatSongs;
                    shuffleCheckBox.setEnabled(PlayListGUI.this._repeatSongs);
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        });
        JPanel checkBoxPanel = new JPanel();
        checkBoxPanel.add(playOptionsLabel);
        checkBoxPanel.add(repeatCheckBox);
        checkBoxPanel.add(shuffleCheckBox);
        optionsPanel.add((Component)checkBoxPanel, "East");
        this.add(optionsPanel);
        try {
            this._tempPL = new PlayList(TEMP_PL_NAME);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        this.updateTheme();
        GUIMediator.addThemeObserver(this);
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        this.SCROLL_PANE.getViewport().setBackground(tableColor);
    }

    public File getFileToPlay() {
        File retFile = null;
        PlayList plToUse = this.getCurrentPlayList();
        int[] sel = this._table.getSelectedRows();
        if (plToUse != null) {
            int oldIndex = this._playIndex;
            if (sel.length > 0) {
                retFile = plToUse.getSong(sel[0]);
                this._playIndex = plToUse.setCurrSongIndex(sel[0]);
                this._table.clearSelection();
            } else if (this.shouldRepeat()) {
                retFile = plToUse.getNextSong();
                this._playIndex = plToUse.getCurrSongIndex();
            }
            this.focusChange(this._playIndex);
            if (oldIndex >= 0) {
                this._tableModel.fireTableRowsUpdated(oldIndex, oldIndex);
            }
            if (this._playIndex >= 0) {
                this._tableModel.fireTableRowsUpdated(this._playIndex, this._playIndex);
            }
        }
        return retFile;
    }

    public boolean songIsSelected() {
        boolean retBool = false;
        int[] selRows = this._table.getSelectedRows();
        if (selRows.length > 0) {
            retBool = true;
        }
        return retBool;
    }

    public void setBackwardsMode() {
        PlayList plToModify = this.getCurrentPlayList();
        if (plToModify != null) {
            plToModify.setBackwardsMode();
        }
    }

    public void playComplete(boolean hardStop) {
        if (hardStop) {
            int temp = this._playIndex;
            this.resetPlayIndex();
            if (temp >= 0) {
                this._tableModel.fireTableRowsUpdated(temp, temp);
            }
        }
    }

    public void addFileToPlayList(File toAdd) {
        if (this._playList != null) {
            this._playList.addSong(toAdd);
        } else {
            if (this._tempPL != null) {
                this._tempPL.addSong(toAdd);
            }
            this._unsavedFiles.add(toAdd);
        }
        ArrayList newRow = this.constructRow(toAdd);
        this._tableModel.addRow(newRow);
    }

    private void focusChange(int row) {
        if (row > -1 && row < this._tableModel.getRowCount()) {
            this._table.setRowSelectionInterval(row, row);
            Rectangle cellRect = this._table.getCellRect(row, 0, false);
            if (cellRect != null) {
                this._table.scrollRectToVisible(cellRect);
            }
        }
        this._table.clearSelection();
    }

    private ArrayList constructRow(File constructFrom) {
        ArrayList retList = new ArrayList();
        retList.add(constructFrom.getName());
        try {
            MP3Info info = new MP3Info(constructFrom.getCanonicalPath());
            retList.add(this.getSecondsLength(info));
            retList.add(new String() + info.getBitRate());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return retList;
    }

    private void fillUpJTable(PlayList plToUse) {
        int begin = 0;
        int end = 0;
        int i = 0;
        while (i < plToUse.getNumSongs()) {
            File currSong = plToUse.getSong(i);
            ArrayList toAdd = this.constructRow(currSong);
            this._tableModel.addRowSansUpdate(toAdd);
            if (i % 19 == 0 || i == plToUse.getNumSongs() - 1) {
                end = i;
                final int beginFinal = begin;
                final int endFinal = end;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PlayListGUI.this._tableModel.updateRows(beginFinal, endFinal);
                    }
                });
                begin = end + 1;
            }
            ++i;
        }
    }

    private String getSecondsLength(MP3Info info) {
        StringBuffer retStringB = new StringBuffer();
        long numSeconds = info.getLengthInSeconds();
        long numMinutes = numSeconds / 60L;
        long remSeconds = numSeconds - 60L * numMinutes;
        retStringB.append("" + numMinutes);
        retStringB.append(":");
        if (remSeconds > 9L) {
            retStringB.append("" + remSeconds);
        } else {
            retStringB.append("0" + remSeconds);
        }
        return retStringB.toString();
    }

    private PlayList getCurrentPlayList() {
        PlayList retPL = null;
        retPL = this._playList != null ? this._playList : this._tempPL;
        return retPL;
    }

    public void launchAudio(File audio) {
        GUIMediator.instance().launchAudio(audio);
        this.resetPlayIndex();
    }

    private void debug(String out) {
        if (this.debugOn) {
            System.out.println(out);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() > 1) {
            GUIMediator.instance().audioFileDoubleClicked();
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ void access$1200(PlayListGUI x0, PlayList x1) {
        x0.fillUpJTable(x1);
    }

    static /* synthetic */ void access$2100(PlayListGUI x0, int x1) {
        x0.focusChange(x1);
    }

    private class SortTableListener
    extends MouseAdapter {
        private SortTableListener() {
        }

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = PlayListGUI.this._table.getColumnModel();
            int viewColumn = columnModel.getColumnIndexAtX(e.getX());
            int column = PlayListGUI.this._table.convertColumnIndexToModel(viewColumn);
            if (e.getClickCount() == 1 && column == 0) {
                PlayListGUI playListGUI = PlayListGUI.instance();
                synchronized (playListGUI) {
                    PlayList plToSort = PlayListGUI.this.getCurrentPlayList();
                    if (plToSort != null) {
                        File currSong = null;
                        if (PlayListGUI.this._playIndex > -1) {
                            currSong = plToSort.getSong(PlayListGUI.this._playIndex);
                        }
                        plToSort.sortByName();
                        PlayListGUI.this._tableModel.clearTable();
                        if (PlayListGUI.this._playIndex > -1 && currSong != null) {
                            PlayListGUI.this._playIndex = plToSort.getIndexOfSong(currSong);
                            plToSort.setCurrSongIndex(PlayListGUI.this._playIndex);
                        }
                        new ManagedThread(this, plToSort, "PlayListSorter"){
                            private final /* synthetic */ PlayList val$plToSort;
                            private final /* synthetic */ SortTableListener this$1;
                            {
                                this.this$1 = this$1;
                                this.val$plToSort = val$plToSort;
                            }

                            public void managedRun() {
                                PlayListGUI playListGUI = PlayListGUI.instance();
                                synchronized (playListGUI) {
                                    PlayListGUI.access$1200(SortTableListener.access$1900(this.this$1), this.val$plToSort);
                                    if (PlayListGUI.access$1800(SortTableListener.access$1900(this.this$1)) > 0) {
                                        SwingUtilities.invokeLater(new Runnable(this){
                                            private final /* synthetic */ 5 this$2;
                                            {
                                                this.this$2 = this$2;
                                            }

                                            public void run() {
                                                PlayListGUI.access$2100(SortTableListener.access$1900(5.access$2000(this.this$2)), PlayListGUI.access$1800(SortTableListener.access$1900(5.access$2000(this.this$2))));
                                            }
                                        });
                                    }
                                }
                            }

                            static /* synthetic */ SortTableListener access$2000(5 x0) {
                                return x0.this$1;
                            }
                        }.start();
                    }
                }
            }
        }

        static /* synthetic */ PlayListGUI access$1900(SortTableListener x0) {
            return x0.PlayListGUI.this;
        }
    }

    private class BasicTableModel
    extends AbstractTableModel {
        private ArrayList names;
        private ArrayList data;
        private Class stringClass = new String().getClass();

        public BasicTableModel() {
            this.names = new ArrayList();
            this.data = new ArrayList();
        }

        public String getColumnName(int col) {
            return (String)this.names.get(col);
        }

        public int getColumnCount() {
            return this.names.size();
        }

        public int getRowCount() {
            return this.data.size();
        }

        public Object getValueAt(int row, int col) {
            String result = null;
            try {
                ArrayList rowList = (ArrayList)this.data.get(row);
                if (col < rowList.size()) {
                    result = (String)rowList.get(col);
                }
            }
            catch (Exception runtime) {
                // empty catch block
            }
            return result;
        }

        public Class getColumnClass(int colIndex) {
            return this.stringClass;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object value, int row, int col) {
            ArrayList rowList = (ArrayList)this.data.get(row);
            if (col >= rowList.size()) {
                while (col >= rowList.size()) {
                    rowList.add(null);
                }
            }
            rowList.set(col, value);
            this.fireTableCellUpdated(row, col);
        }

        public void addColumn(String name) {
            this.names.add(name);
            this.fireTableStructureChanged();
        }

        public int addRow() {
            ArrayList row = new ArrayList();
            return this.addRow(row);
        }

        public int addRow(ArrayList row) {
            this.data.add(row);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            return this.data.size() - 1;
        }

        public int addRowSansUpdate(ArrayList row) {
            this.data.add(row);
            return this.data.size() - 1;
        }

        public void updateRows(int begin, int end) {
            this.fireTableRowsInserted(begin, end);
        }

        public void deleteRow(int row) {
            if (row == -1) {
                return;
            }
            this.data.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        public void clearTable() {
            this.data.clear();
            this.fireTableDataChanged();
        }
    }

    private class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                PlayList plToUse = PlayListGUI.this.getCurrentPlayList();
                int[] sel = PlayListGUI.this._table.getSelectedRows();
                if (sel.length > 0 && plToUse != null) {
                    int i = 0;
                    while (i < sel.length) {
                        int indexToDel = sel[i] - i;
                        plToUse.deleteSong(indexToDel);
                        if (PlayListGUI.this._playIndex == indexToDel) {
                            PlayListGUI.this.resetPlayIndex();
                        } else if (PlayListGUI.this._playIndex > indexToDel) {
                            PlayListGUI.this._playIndex--;
                        }
                        PlayListGUI.this._tableModel.deleteRow(indexToDel);
                        ++i;
                    }
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (PlayListGUI.this._playList == null) {
                    File selFile;
                    String parent;
                    File parentFile = null;
                    if (PlayListGUI.this.lastSavedPlaylist != null && (parent = PlayListGUI.this.lastSavedPlaylist.getParent()) != null) {
                        parentFile = new File(parent);
                    }
                    if (parentFile == null) {
                        parentFile = CommonUtils.getCurrentDirectory();
                    }
                    if ((selFile = FileChooserHandler.getInputFile((Component)PlayListGUI.instance(), "PLAYLIST_DIALOG_SAVE_TITLE", "PLAYLIST_DIALOG_SAVE_SAVE", parentFile)) != null) {
                        try {
                            PlayListGUI.this.lastSavedPlaylist = selFile;
                            if (selFile.exists()) {
                                selFile.delete();
                            }
                            PlayListGUI.this._playList = new PlayList(selFile.getCanonicalPath());
                            if (PlayListGUI.this._playList.isShuffled() != PlayListGUI.this._shuffleSongs) {
                                PlayListGUI.this._playList.toggleShuffle();
                            }
                            int i = 0;
                            while (i < PlayListGUI.this._unsavedFiles.size()) {
                                File currFile = (File)PlayListGUI.this._unsavedFiles.get(i);
                                PlayListGUI.this._playList.addSong(currFile);
                                ++i;
                            }
                            PlayListGUI.this._unsavedFiles.clear();
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        PlayListGUI.this._tempPL = null;
                    }
                }
                if (PlayListGUI.this._playList != null) {
                    try {
                        PlayListGUI.this._playList.save();
                    }
                    catch (Exception ignored) {}
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private static class PlayListFileFilter
    extends FileFilter {
        private PlayListFileFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String name = f.getName();
            return name.endsWith("m3u");
        }

        public String getDescription() {
            return GUIMediator.getStringResource("PLAYLIST_FILE_DESCRIPTION");
        }
    }

    private class LoadListener
    implements ActionListener {
        private LoadListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File selFile;
                String parent;
                File parentFile = null;
                if (PlayListGUI.this.lastOpenedPlaylist != null && (parent = PlayListGUI.this.lastOpenedPlaylist.getParent()) != null) {
                    parentFile = new File(parent);
                }
                if (parentFile == null) {
                    parentFile = CommonUtils.getCurrentDirectory();
                }
                if ((selFile = FileChooserHandler.getInputFile((Component)PlayListGUI.instance(), "PLAYLIST_DIALOG_OPEN_TITLE", parentFile, new PlayListFileFilter())) != null) {
                    PlayListGUI.this.lastOpenedPlaylist = selFile;
                    new ManagedThread(this, selFile, "PlayListLoader"){
                        private final /* synthetic */ File val$selFile;
                        private final /* synthetic */ LoadListener this$1;
                        {
                            this.this$1 = this$1;
                            this.val$selFile = val$selFile;
                        }

                        public void managedRun() {
                            try {
                                PlayListGUI.access$1000(LoadListener.access$900(this.this$1)).clearTable();
                                PlayListGUI.access$1102(LoadListener.access$900(this.this$1), new PlayList(this.val$selFile.getCanonicalPath()));
                                if (PlayListGUI.access$1100(LoadListener.access$900(this.this$1)).isShuffled() != PlayListGUI.access$400(LoadListener.access$900(this.this$1))) {
                                    PlayListGUI.access$1100(LoadListener.access$900(this.this$1)).toggleShuffle();
                                }
                                PlayListGUI.access$1200(LoadListener.access$900(this.this$1), PlayListGUI.access$1100(LoadListener.access$900(this.this$1)));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }.start();
                    PlayListGUI.this.resetPlayIndex();
                }
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }

        static /* synthetic */ PlayListGUI access$900(LoadListener x0) {
            return x0.PlayListGUI.this;
        }
    }
}

