/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Comparator;
import java.io.File;

class PlayListSorter
implements Comparator {
    private static PlayListSorter ascendingInstance = null;
    private static PlayListSorter descendingInstance = null;
    private boolean ascending;

    public static PlayListSorter getInstance(boolean ascending) {
        if (ascending) {
            if (ascendingInstance == null) {
                ascendingInstance = new PlayListSorter(true);
            }
            return ascendingInstance;
        }
        if (descendingInstance == null) {
            descendingInstance = new PlayListSorter(false);
        }
        return descendingInstance;
    }

    public int compare(Object o1, Object o2) {
        try {
            String s1 = ((File)o1).getName();
            String s2 = ((File)o2).getName();
            int order = StringUtils.compareIgnoreCase(s1, s2);
            if (order == 0) {
                order = s1.compareTo(s2);
            }
            return this.ascending ? order : -order;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private PlayListSorter(boolean ascending) {
        this.ascending = ascending;
    }
}

