/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import javazoom.jl.decoder.Obuffer;

public final class WaveStreamObuffer
extends Obuffer {
    private final short[] buffer = new short[2304];
    private final short[] bufferp = new short[2];
    private int channels;

    public WaveStreamObuffer(int number_of_channels, int freq) {
        this.channels = number_of_channels;
        int i = 0;
        while (i < this.channels) {
            this.bufferp[i] = (short)i;
            ++i;
        }
    }

    public final void append(int channel, short value) {
        this.buffer[this.bufferp[channel]] = value;
        int n = channel;
        this.bufferp[n] = (short)(this.bufferp[n] + this.channels);
    }

    public final void appendSamples(int channel, float[] f) {
        int i = 0;
        while (i < 32) {
            float currFloat;
            int s;
            this.buffer[this.bufferp[channel]] = s = (short)((currFloat = f[i++]) > 32767.0f ? Short.MAX_VALUE : (short)(currFloat < -32768.0f ? Short.MIN_VALUE : (short)currFloat));
            int n = channel;
            this.bufferp[n] = (short)(this.bufferp[n] + this.channels);
        }
    }

    public void write_buffer(int val) {
        int i = 0;
        while (i < this.channels) {
            this.bufferp[i] = (short)i;
            ++i;
        }
    }

    public byte[] get_data() {
        byte[] theData = new byte[this.buffer.length * 2];
        int yc = 0;
        int y = 0;
        while (y < this.buffer.length * 2) {
            theData[y] = (byte)(this.buffer[yc] & 0xFF);
            theData[y + 1] = (byte)(this.buffer[yc++] >>> 8 & 0xFF);
            y += 2;
        }
        return theData;
    }

    public void close() {
    }

    public void clear_buffer() {
    }

    public void set_stop_flag() {
    }
}

