/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.options.OptionsTreeNode;
import java.io.IOException;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;

final class OptionsTreeModel {
    private DefaultTreeModel _treeModel;
    private final OptionsTreeNode ROOT = new OptionsTreeNode("OPTIONS_ROOT_NODE", "");

    OptionsTreeModel() {
        this._treeModel = new DefaultTreeModel(this.ROOT);
    }

    final void addNode(String parentKey, String key, String displayName) {
        MutableTreeNode parentNode;
        OptionsTreeNode newNode = new OptionsTreeNode(key, displayName);
        if (parentKey == "OPTIONS_ROOT_NODE") {
            parentNode = this.ROOT;
        } else {
            try {
                parentNode = this.getParentNode(this.ROOT, parentKey);
            }
            catch (IOException ioe) {
                return;
            }
            if (parentNode == null) {
                return;
            }
        }
        this._treeModel.insertNodeInto(newNode, parentNode, parentNode.getChildCount());
        this._treeModel.reload(parentNode);
    }

    private final MutableTreeNode getParentNode(MutableTreeNode node, String parentKey) throws IOException {
        int i = 0;
        int length = node.getChildCount();
        while (i < length) {
            OptionsTreeNode curNode = (OptionsTreeNode)node.getChildAt(i);
            if (curNode.getTitleKey().equals(parentKey)) {
                return curNode;
            }
            this.getParentNode(curNode, parentKey);
            if (curNode.isRoot() && i == length - 1) {
                String msg = "Parent node not in options tree.";
                throw new IOException(msg);
            }
            ++i;
        }
        return null;
    }

    final TreeModel getTreeModel() {
        return this._treeModel;
    }
}

