/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.util.ManagedThread;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JTextField;

public final class ExtensionsPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_SHARED_EXTENSIONS_BOX_LABEL";
    private JTextField _extField = new SizedTextField();
    private String _extensions;

    public ExtensionsPaneItem(String key) {
        super(key);
        LabeledComponent comp = new LabeledComponent("OPTIONS_SHARED_EXTENSIONS_BOX_LABEL", this._extField, 13);
        String[] labelKeys = new String[]{"OPTIONS_SHARED_EXTENSIONS_DEFAULT_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"OPTIONS_SHARED_EXTENSIONS_DEFAULT_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new DefaultExtensionsListener()};
        ButtonRow br = new ButtonRow(labelKeys, toolTipKeys, listeners, 0, 12);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(br);
    }

    public void initOptions() {
        this._extensions = SharingSettings.EXTENSIONS_TO_SHARE.getValue();
        this._extField.setText(this._extensions);
    }

    public boolean applyOptions() throws IOException {
        String ext = this._extField.getText();
        if (!ext.equals(this._extensions)) {
            SharingSettings.EXTENSIONS_TO_SHARE.setValue(this._extField.getText());
            ManagedThread loadFileManagerSettings = new ManagedThread("ExtensionsChangedReloader"){

                public void managedRun() {
                    FileManager fm = RouterService.getFileManager();
                    fm.loadSettings(true);
                }
            };
            loadFileManagerSettings.setDaemon(true);
            loadFileManagerSettings.start();
            this._extensions = this._extField.getText();
        }
        return false;
    }

    private class DefaultExtensionsListener
    implements ActionListener {
        private DefaultExtensionsListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SharingSettings.EXTENSIONS_TO_SHARE.revertToDefault();
                ExtensionsPaneItem.this._extField.setText(SharingSettings.EXTENSIONS_TO_SHARE.getValue());
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

