/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public final class ProxyLoginPaneItem
extends AbstractPaneItem {
    private final String PROXY_AUTHENTICATE_CHECK_BOX_LABEL = "OPTIONS_PROXY_LOGIN_AUTHENTICATE_LABEL";
    private final String PROXY_USERNAME_LABEL_KEY = "OPTIONS_PROXY_LOGIN_USERNAME_LABEL";
    private final String PROXY_PASSWORD_LABEL_KEY = "OPTIONS_PROXY_LOGIN_PASSWORD_LABEL";
    private final JTextField PROXY_USERNAME_FIELD = new SizedTextField(12, new Dimension(60, 20));
    private final JTextField PROXY_PASSWORD_FIELD = new SizedTextField(12, new Dimension(60, 20));
    private final JCheckBox CHECK_BOX = new JCheckBox();

    public ProxyLoginPaneItem(String key) {
        super(key);
        this.CHECK_BOX.addItemListener(new LocalAuthenticateListener());
        LabeledComponent checkBox = new LabeledComponent("OPTIONS_PROXY_LOGIN_AUTHENTICATE_LABEL", this.CHECK_BOX, 120);
        LabeledComponent username = new LabeledComponent("OPTIONS_PROXY_LOGIN_USERNAME_LABEL", this.PROXY_USERNAME_FIELD, 120);
        LabeledComponent password = new LabeledComponent("OPTIONS_PROXY_LOGIN_PASSWORD_LABEL", this.PROXY_PASSWORD_FIELD, 120);
        this.add(checkBox.getComponent());
        this.add(username.getComponent());
        this.add(password.getComponent());
    }

    public void initOptions() {
        String username = ConnectionSettings.PROXY_USERNAME.getValue();
        String password = ConnectionSettings.PROXY_PASS.getValue();
        boolean authenticate = ConnectionSettings.PROXY_AUTHENTICATE.getValue();
        this.PROXY_USERNAME_FIELD.setText(username);
        this.PROXY_PASSWORD_FIELD.setText(password);
        this.CHECK_BOX.setSelected(authenticate && ConnectionSettings.CONNECTION_METHOD.getValue() != 1);
        this.PROXY_USERNAME_FIELD.setEditable(this.CHECK_BOX.isSelected());
        this.PROXY_PASSWORD_FIELD.setEditable(this.CHECK_BOX.isSelected());
    }

    public boolean applyOptions() throws IOException {
        String username = this.PROXY_USERNAME_FIELD.getText();
        String password = this.PROXY_PASSWORD_FIELD.getText();
        boolean authenticate = this.CHECK_BOX.isSelected();
        ConnectionSettings.PROXY_USERNAME.setValue(username);
        ConnectionSettings.PROXY_PASS.setValue(password);
        ConnectionSettings.PROXY_AUTHENTICATE.setValue(authenticate);
        return false;
    }

    private class LocalAuthenticateListener
    implements ItemListener {
        private LocalAuthenticateListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ProxyLoginPaneItem.this.PROXY_USERNAME_FIELD.setEditable(ProxyLoginPaneItem.this.CHECK_BOX.isSelected());
            ProxyLoginPaneItem.this.PROXY_PASSWORD_FIELD.setEditable(ProxyLoginPaneItem.this.CHECK_BOX.isSelected());
        }
    }
}

