/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SaveDirectoryHandler;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.SharingSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JTextField;

public final class SaveDirPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_SAVE_DIR_BOX_LABEL";
    private JTextField _saveField = new SizedTextField();
    private String _saveDirectory;

    public SaveDirPaneItem(String key) {
        super(key);
        LabeledComponent comp = new LabeledComponent("OPTIONS_SAVE_DIR_BOX_LABEL", this._saveField, 13);
        String[] labelKeys = new String[]{"OPTIONS_SAVE_DIR_BROWSE_BUTTON_LABEL", "OPTIONS_SAVE_DIR_DEFAULT_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"OPTIONS_SAVE_DIR_BROWSE_BUTTON_TIP", "OPTIONS_SAVE_DIR_DEFAULT_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new SelectSaveDirectoryListener(), new DefaultListener()};
        ButtonRow br = new ButtonRow(labelKeys, toolTipKeys, listeners, 0, 12);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(br);
    }

    public void initOptions() {
        try {
            File file = SharingSettings.getSaveDirectory();
            if (file == null) {
                throw new FileNotFoundException();
            }
            this._saveDirectory = file.getCanonicalPath();
        }
        catch (FileNotFoundException fnfe) {
            this._saveDirectory = "";
        }
        catch (IOException ioe) {
            this._saveDirectory = "";
        }
        this._saveField.setText(this._saveDirectory);
    }

    public boolean applyOptions() throws IOException {
        String save = this._saveField.getText();
        if (!save.equals(this._saveDirectory)) {
            AbstractPaneItem.MEDIATOR.setSaveDirectoryChanged(true);
            try {
                File saveDir = new File(save);
                if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
                    throw new IOException();
                }
                SharingSettings.setSaveDirectory(saveDir);
                this._saveDirectory = save;
            }
            catch (IOException ioe) {
                GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY");
                this._saveField.setText(this._saveDirectory);
                throw new IOException();
            }
            catch (NullPointerException npe) {
                GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY");
                this._saveField.setText(this._saveDirectory);
                throw new IOException();
            }
        }
        return false;
    }

    private class SelectSaveDirectoryListener
    implements ActionListener {
        private SelectSaveDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File dir = FileChooserHandler.getInputDirectory(AbstractPaneItem.MEDIATOR.getMainOptionsComponent());
                if (dir == null) {
                    return;
                }
                if (!SaveDirectoryHandler.isSaveDirectoryValid(dir)) {
                    GUIMediator.showError("ERROR_INVALID_SAVE_DIRECTORY_SELECTION");
                    return;
                }
                try {
                    String newDir = dir.getCanonicalPath();
                    if (!newDir.equals(SaveDirPaneItem.this._saveDirectory)) {
                        AbstractPaneItem.MEDIATOR.setSaveDirectoryChanged(true);
                        SaveDirPaneItem.this._saveField.setText(newDir);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                SaveDirPaneItem.this._saveField.setText(SharingSettings.DEFAULT_SAVE_DIR.getAbsolutePath());
            }
            catch (Throwable t) {
                ErrorService.error(t);
            }
        }
    }
}

