/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JComboBox;

public final class SpeedPaneItem
extends AbstractPaneItem {
    private final String[] SPEED_MENU_ITEMS = new String[]{GUIConstants.MODEM_SPEED, GUIConstants.CABLE_SPEED, GUIConstants.T1_SPEED, GUIConstants.T3_SPEED};
    private final String OPTION_LABEL = "OPTIONS_SPEED_BOX_LABEL";
    private final JComboBox SPEED_BOX = new JComboBox<String>(this.SPEED_MENU_ITEMS);
    private String _speed;

    public SpeedPaneItem(String key) {
        super(key);
        this.SPEED_BOX.setMaximumSize(new Dimension(10, 25));
        LabeledComponent comp = new LabeledComponent("OPTIONS_SPEED_BOX_LABEL", this.SPEED_BOX, 120);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this._speed = this.getSpeedString(ConnectionSettings.CONNECTION_SPEED.getValue());
        this.SPEED_BOX.setSelectedItem(this._speed);
    }

    public boolean applyOptions() throws IOException {
        String speed = (String)this.SPEED_BOX.getSelectedItem();
        if (!speed.equals(this._speed)) {
            int speedInt = this.getSpeedInt(speed);
            if (speedInt < 0 || 20000 < speedInt) {
                throw new IllegalArgumentException();
            }
            ConnectionSettings.CONNECTION_SPEED.setValue(speedInt);
            this._speed = speed;
        }
        return false;
    }

    private String getSpeedString(int i) {
        String speed = i == 56 ? GUIConstants.MODEM_SPEED : (i == 350 ? GUIConstants.CABLE_SPEED : (i == 1000 ? GUIConstants.T1_SPEED : (i == 3000 ? GUIConstants.T3_SPEED : GUIConstants.MODEM_SPEED)));
        return speed;
    }

    private int getSpeedInt(String s) {
        int i = s.equals(GUIConstants.MODEM_SPEED) ? 56 : (s.equals(GUIConstants.CABLE_SPEED) ? 350 : (s.equals(GUIConstants.T1_SPEED) ? 1000 : (s.equals(GUIConstants.T3_SPEED) ? 3000 : 56)));
        return i;
    }
}

