/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import java.awt.Color;
import java.awt.Graphics;

public final class Ditherer {
    private final int _redT;
    private final int _greenT;
    private final int _blueT;
    private final int _redB;
    private final int _greenB;
    private final int _blueB;
    private final int STEPS;
    private final Color top;
    private final Color bottom;

    Ditherer(int steps, Color top, Color bottom) {
        this.STEPS = steps;
        this._redT = top.getRed();
        this._greenT = top.getGreen();
        this._blueT = top.getBlue();
        this._redB = bottom.getRed();
        this._greenB = bottom.getGreen();
        this._blueB = bottom.getBlue();
        this.top = top;
        this.bottom = bottom;
    }

    Color getTop() {
        return this.top;
    }

    Color getBottom() {
        return this.bottom;
    }

    public void draw(Graphics g, int height, int width) {
        Color c;
        float redStep = (float)(this._redB - this._redT) / (float)this.STEPS;
        float greenStep = (float)(this._greenB - this._greenT) / (float)this.STEPS;
        float blueStep = (float)(this._blueB - this._blueT) / (float)this.STEPS;
        float red = this._redT;
        float green = this._greenT;
        float blue = this._blueT;
        int yStep = height / this.STEPS;
        int y = 0;
        int i = 0;
        while (i < this.STEPS) {
            c = new Color(Ditherer.round(red), Ditherer.round(green), Ditherer.round(blue));
            g.setColor(c);
            g.fillRect(0, y, width, yStep);
            y += yStep;
            red += redStep;
            green += greenStep;
            blue += blueStep;
            ++i;
        }
        c = new Color(Ditherer.round(red), Ditherer.round(green), Ditherer.round(blue));
        g.setColor(c);
        g.fillRect(0, y, width, height - y);
    }

    private static int round(float color) {
        int ret = Math.round(color);
        if (ret < 0) {
            return 0;
        }
        if (ret > 255) {
            return 255;
        }
        return ret;
    }
}

