/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.ListModelMap;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.Selector;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.Comparators;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.event.ListDataListener;

final class MetadataModel {
    static final String TYPE = "RESULT_PANEL_TYPE";
    static final String SPEED = "RESULT_PANEL_SPEED";
    static final String VENDOR = "RESULT_PANEL_VENDOR";
    private final ListModelMap MODEL = new Model();
    private static final String UNKNOWN = "unknown";
    private final ListModelMap PROPERTIES = new Model(Comparators.stringComparator());

    MetadataModel() {
        this.initialize();
    }

    void clear() {
        this.MODEL.clear();
        this.PROPERTIES.clear();
        this.initialize();
    }

    void addNew(TableLine line) {
        NamedMediaType mt = line.getNamedMediaType();
        this.addProperties(line);
        if (mt == null) {
            return;
        }
        ListModelMap fieldMap = this.getMap(this.MODEL, mt);
        LimeXMLDocument doc = line.getXMLDocument();
        if (doc != null) {
            this.addDocument(fieldMap, doc, line);
        } else {
            this.getCollection(fieldMap, UNKNOWN).add(line);
        }
    }

    void remove(TableLine line) {
        NamedMediaType mt = line.getNamedMediaType();
        this.removeProperties(line);
        if (mt == null) {
            return;
        }
        ListModelMap fieldMap = this.getMap(this.MODEL, mt);
        LimeXMLDocument doc = line.getXMLDocument();
        if (doc != null) {
            this.removeDocument(fieldMap, doc, line);
        } else {
            this.getCollection(fieldMap, UNKNOWN).remove(line);
        }
    }

    void addNewDocument(LimeXMLDocument doc, TableLine line) {
        NamedMediaType mt = line.getNamedMediaType();
        ListModelMap fieldMap = this.getMap(this.MODEL, mt);
        this.addDocument(fieldMap, doc, line);
    }

    void addField(String field, String value, TableLine line) {
        NamedMediaType mt = line.getNamedMediaType();
        ListModelMap fieldMap = this.getMap(this.MODEL, mt);
        ListModelMap valueMap = this.getMap(fieldMap, field);
        this.getCollection(valueMap, value).add(line);
    }

    void updateProperty(String property, Object current, Object old, TableLine line) {
        ListModelMap map = this.getMap(this.PROPERTIES, property);
        this.getCollection(map, old).remove(line);
        this.getCollection(map, current).add(line);
    }

    ListModelMap getListModelMap(Selector selector) {
        switch (selector.getSelectorType()) {
            case 1: {
                return this.MODEL;
            }
            case 2: {
                NamedMediaType mt = NamedMediaType.getFromDescription(selector.getSchema());
                return this.getMap(this.getMap(this.MODEL, mt), selector.getValue());
            }
            case 3: {
                return this.getMap(this.PROPERTIES, selector.getValue());
            }
        }
        return null;
    }

    List getSelectorOptions() {
        LinkedList list = new LinkedList();
        list.add(Selector.createSchemaSelector());
        Iterator i = this.MODEL.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            NamedMediaType nmt = (NamedMediaType)entry.getKey();
            String schema = nmt.getMediaType().getMimeType();
            Iterator fields = ((Map)entry.getValue()).keySet().iterator();
            while (fields.hasNext()) {
                String next = (String)fields.next();
                if (UNKNOWN.equals(next)) continue;
                list.add(Selector.createFieldSelector(schema, next));
            }
        }
        Iterator i2 = this.PROPERTIES.keySet().iterator();
        while (i2.hasNext()) {
            list.add(Selector.createPropertySelector((String)i2.next()));
        }
        return list;
    }

    ListModelMap getCrossSection(ListModelMap parent, Object selection, ListModelMap child) {
        Collection elements;
        if (selection != null && !MetadataModel.isAll(selection)) {
            Object values = parent.get(selection);
            if (values == null) {
                throw new IllegalArgumentException("invalid selection");
            }
            elements = this.getAllValues(values);
        } else {
            elements = this.getAllValues(parent);
        }
        Model ret = new Model(child.comparator());
        Iterator i = child.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            if (!DataUtils.containsAny(elements, this.getAllValues(entry.getValue()))) continue;
            ret.put(entry.getKey(), entry.getValue());
        }
        return ret;
    }

    private void initialize() {
        this.PROPERTIES.put(TYPE, new Model());
        this.PROPERTIES.put(SPEED, new Model());
    }

    private void addDocument(Map fieldMap, LimeXMLDocument doc, TableLine line) {
        boolean added = false;
        Iterator i = doc.getNameValueSet().iterator();
        while (i.hasNext()) {
            added = true;
            Map.Entry entry = (Map.Entry)i.next();
            String field = (String)entry.getKey();
            String value = (String)entry.getValue();
            ListModelMap valueMap = this.getMap(fieldMap, field);
            this.getCollection(valueMap, value).add(line);
        }
        if (!added) {
            this.getCollection(fieldMap, UNKNOWN).add(line);
        }
    }

    private void removeDocument(Map fieldMap, LimeXMLDocument doc, TableLine line) {
        boolean removed = false;
        Iterator i = doc.getNameValueSet().iterator();
        while (i.hasNext()) {
            removed = true;
            Map.Entry entry = (Map.Entry)i.next();
            String field = (String)entry.getKey();
            String value = (String)entry.getValue();
            ListModelMap valueMap = this.getMap(fieldMap, field);
            this.getCollection(valueMap, value).remove(line);
        }
        if (!removed) {
            this.getCollection(fieldMap, UNKNOWN).remove(line);
        }
    }

    private void addProperties(TableLine line) {
        ListModelMap extMap = this.getMap(this.PROPERTIES, TYPE);
        this.getCollection(extMap, line.getIconAndExtension()).add(line);
        ListModelMap speedMap = this.getMap(this.PROPERTIES, SPEED);
        this.getCollection(speedMap, line.getSpeed()).add(line);
        ListModelMap vendorMap = this.getMap(this.PROPERTIES, VENDOR);
        this.getCollection(vendorMap, line.getVendor()).add(line);
    }

    private void removeProperties(TableLine line) {
        ListModelMap extMap = this.getMap(this.PROPERTIES, TYPE);
        this.getCollection(extMap, line.getIconAndExtension()).remove(line);
        ListModelMap speedMap = this.getMap(this.PROPERTIES, SPEED);
        this.getCollection(speedMap, line.getSpeed()).remove(line);
        ListModelMap vendorMap = this.getMap(this.PROPERTIES, VENDOR);
        this.getCollection(vendorMap, line.getVendor()).remove(line);
    }

    private Collection getAllValues(Object parent) {
        if (parent instanceof Collection) {
            return (Collection)parent;
        }
        if (parent instanceof Map) {
            HashSet values = new HashSet();
            Iterator i = ((Map)parent).values().iterator();
            while (i.hasNext()) {
                values.addAll(this.getAllValues(i.next()));
            }
            return values;
        }
        throw new IllegalArgumentException("parent: " + parent);
    }

    private ListModelMap getMap(Map parent, Object key) {
        ListModelMap m = (ListModelMap)parent.get(key);
        if (m == null) {
            m = new Model(Comparators.caseInsensitiveStringComparator());
            parent.put(key, m);
        }
        return m;
    }

    private Collection getCollection(Map parent, Object key) {
        Collection l;
        if (key instanceof String) {
            key = ((String)key).trim();
        }
        if ((l = (Collection)parent.get(key)) == null) {
            l = new HashSet();
            parent.put(key, l);
        }
        return l;
    }

    static boolean isAll(Object value) {
        return value instanceof All;
    }

    private static class All {
        private static final String ALL = GUIMediator.getStringResource("SEARCH_FILTER_ALL") + " (";
        final int number;

        private All(int number) {
            this.number = number;
        }

        public String toString() {
            return ALL + this.number + ")";
        }
    }

    private static class SimpleListModel
    extends AbstractListModel {
        private SimpleListModel() {
        }

        public int getSize() {
            throw new IllegalStateException();
        }

        public Object getElementAt(int idx) {
            throw new IllegalStateException();
        }

        public void fireContentsChanged(Object src, int a, int b) {
            super.fireContentsChanged(src, a, b);
        }
    }

    private static class Model
    extends TreeMap
    implements ListModelMap {
        private final SimpleListModel DELEGATE = new SimpleListModel();

        Model() {
        }

        Model(Comparator comp) {
            super(comp);
        }

        public Object put(Object a, Object b) {
            Object o = super.put(a, b);
            this.DELEGATE.fireContentsChanged(this, 0, this.size());
            return o;
        }

        public void fireContentsChanged() {
            this.DELEGATE.fireContentsChanged(this, 0, this.size());
        }

        public void addListDataListener(ListDataListener l) {
            this.DELEGATE.addListDataListener(l);
        }

        public void removeListDataListener(ListDataListener l) {
            this.DELEGATE.removeListDataListener(l);
        }

        public int getSize() {
            return this.size() + 1;
        }

        public Object getElementAt(int idx) {
            if (idx == 0) {
                return new All(this.size());
            }
            if (idx > this.size()) {
                throw new IndexOutOfBoundsException("index: " + idx + ", size: " + this.getSize());
            }
            Iterator i = this.keySet().iterator();
            int j = 1;
            while (j < idx) {
                i.next();
                ++j;
            }
            return i.next();
        }

        public boolean contains(Object o) {
            if (MetadataModel.isAll(o)) {
                return true;
            }
            return this.containsKey(o);
        }

        public int indexOf(Object o) {
            if (MetadataModel.isAll(o)) {
                return 0;
            }
            Iterator iter = this.keySet().iterator();
            int i = 1;
            while (iter.hasNext()) {
                if (this.compare(o, iter.next()) == 0) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Iterator iterator() {
            return this.keySet().iterator();
        }

        private int compare(Object k1, Object k2) {
            return this.comparator() == null ? ((Comparable)k1).compareTo(k2) : this.comparator().compare(k1, k2);
        }
    }
}

