/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

final class QualityRenderer
implements TableCellRenderer,
ThemeObserver {
    private static Border _noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private Color _unselectedForeground;
    private Color _unselectedBackground;
    private final JLabel STAR_ONE = new JLabel();
    private final JLabel STAR_TWO = new JLabel();
    private final JLabel STAR_THREE = new JLabel();
    private final JLabel STAR_FOUR = new JLabel();
    private final JLabel STAR_FIVE = new JLabel();
    private final JLabel SAVED_FILE = new JLabel();
    private final JLabel DOWNLOADING_FILE = new JLabel();
    private final JLabel INCOMPLETE_FILE = new JLabel();
    static final int SAVED_FILE_QUALITY = 1002;
    static final int DOWNLOADING_FILE_QUALITY = 1001;
    static final int INCOMPLETE_FILE_QUALITY = 1000;
    static final int MULTICAST_QUALITY = 4;
    static final int EXCELLENT_QUALITY = 3;
    static final int GOOD_QUALITY = 2;
    static final int FAIR_QUALITY = 1;
    static final int POOR_QUALITY = 0;

    QualityRenderer() {
        this.fix(this.STAR_ONE);
        this.fix(this.STAR_TWO);
        this.fix(this.STAR_THREE);
        this.fix(this.STAR_FOUR);
        this.fix(this.STAR_FIVE);
        this.fix(this.SAVED_FILE);
        this.fix(this.DOWNLOADING_FILE);
        this.fix(this.INCOMPLETE_FILE);
        this.updateTheme();
        GUIMediator.addThemeObserver(this);
    }

    private void fix(JLabel label) {
        label.setBorder(_noFocusBorder);
        label.setOpaque(true);
        label.setHorizontalAlignment(0);
    }

    public void updateTheme() {
        this.STAR_ONE.setIcon(GUIMediator.getThemeImage("01_star.gif"));
        this.STAR_TWO.setIcon(GUIMediator.getThemeImage("02_star.gif"));
        this.STAR_THREE.setIcon(GUIMediator.getThemeImage("03_star.gif"));
        this.STAR_FOUR.setIcon(GUIMediator.getThemeImage("04_star.gif"));
        this.STAR_FIVE.setIcon(GUIMediator.getThemeImage("05_star.gif"));
        this.SAVED_FILE.setIcon(GUIMediator.getThemeImage("complete.gif"));
        this.DOWNLOADING_FILE.setIcon(GUIMediator.getThemeImage("downloading.gif"));
        this.INCOMPLETE_FILE.setIcon(GUIMediator.getThemeImage("incomplete.gif"));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel curLabel;
        int numStars = value == null ? 0 : (Integer)value;
        switch (numStars) {
            case 1002: {
                curLabel = this.SAVED_FILE;
                break;
            }
            case 1001: {
                curLabel = this.DOWNLOADING_FILE;
                break;
            }
            case 1000: {
                curLabel = this.INCOMPLETE_FILE;
                break;
            }
            case 4: {
                curLabel = this.STAR_FIVE;
                break;
            }
            case 3: {
                curLabel = this.STAR_FOUR;
                break;
            }
            case 2: {
                curLabel = this.STAR_THREE;
                break;
            }
            case 1: {
                curLabel = this.STAR_TWO;
                break;
            }
            default: {
                curLabel = this.STAR_ONE;
            }
        }
        if (isSelected) {
            curLabel.setForeground(table.getSelectionForeground());
            curLabel.setBackground(table.getSelectionBackground());
        } else {
            curLabel.setForeground(this._unselectedForeground != null ? this._unselectedForeground : table.getForeground());
            curLabel.setBackground(this._unselectedBackground != null ? this._unselectedBackground : table.getBackground());
        }
        return curLabel;
    }
}

