/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.GUIUtils;
import com.sun.java.util.collections.Comparable;

class ResultSpeed
implements Comparable {
    private int speed;
    private String description;
    private boolean isMeasured;

    public ResultSpeed(int speed, boolean isMeasured) {
        this.speed = speed;
        this.isMeasured = isMeasured;
        this.description = GUIUtils.speed2name(speed);
    }

    public int intValue() {
        return this.speed;
    }

    public String stringValue() {
        return this.description;
    }

    public boolean isMeasured() {
        return this.isMeasured;
    }

    public int isFaster(ResultSpeed other) {
        return this.speed - other.speed;
    }

    public boolean equals(Object other) {
        if (other instanceof ResultSpeed) {
            ResultSpeed o = (ResultSpeed)other;
            return o.speed == this.speed;
        }
        return false;
    }

    public int compareTo(Object other) {
        ResultSpeed o = (ResultSpeed)other;
        int diff = this.speed - o.speed;
        if (diff == 0) {
            return 0;
        }
        int strDiff = this.description.compareTo(o.description);
        if (strDiff == 0) {
            return 0;
        }
        return diff;
    }

    public boolean isSameSpeed(ResultSpeed other) {
        return this.description.equals(other.description);
    }

    public String toString() {
        return this.stringValue();
    }
}

