/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.DisplayManager;
import com.limegroup.gnutella.gui.tables.ColumnSelectionMenu;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.xml.XMLStringUtils;
import com.sun.java.util.collections.List;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

final class SearchColumnSelectionMenu
extends ColumnSelectionMenu {
    public SearchColumnSelectionMenu(LimeJTable table) {
        super(table);
    }

    protected void addTableColumnChoices(ActionListener listener, DataLineModel model, LimeJTable table) {
        String currentSchema = "";
        JMenu currentSchemaMenu = null;
        int i = 0;
        while (i < model.getColumnCount()) {
            JMenuItem item = this.createColumnMenuItem(listener, model, table, i);
            String schema = this.schemaOf(item);
            if (schema != null) {
                if (!schema.equals(currentSchema)) {
                    currentSchema = schema;
                    currentSchemaMenu = new JMenu(currentSchema);
                    this._menu.add(currentSchemaMenu);
                }
                currentSchemaMenu.add(item);
            } else {
                this._menu.add(item);
            }
            ++i;
        }
    }

    private String schemaOf(JMenuItem item) {
        String field = (String)item.getClientProperty("columnId");
        if (!field.endsWith("__")) {
            return null;
        }
        List nodes = XMLStringUtils.split(field);
        String root = (String)nodes.get(0);
        String element = (String)nodes.get(1);
        String key = root + "__" + element;
        return DisplayManager.instance().getDisplayName(key, element);
    }
}

