/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ProgTabUIFactory;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.OverlayAd;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.SearchSettings;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;

final class SearchResultDisplayer
implements ThemeObserver,
RefreshListener {
    private final JPanel MAIN_PANEL = new BoxPanel(1);
    private final JTabbedPane TABBED_PANE = new JTabbedPane();
    private final CancelSearchIconProxy KILL_ICON = new CancelSearchIconProxy(false);
    private final CancelSearchIconProxy SEL_ICON = new CancelSearchIconProxy(true);
    private static final List entries = new ArrayList();
    private final JPanel results = new JPanel();
    private final CardLayout switcher = new CardLayout();
    private final ResultPanel DUMMY;
    private final OverlayAd OVERLAY;
    private ChangeListener _activeSearchListener;
    private final PaneListener PANE_LISTENER = new PaneListener();

    SearchResultDisplayer() {
        this.MAIN_PANEL.setMinimumSize(new Dimension(0, 0));
        ProgTabUIFactory.extendUI(this.TABBED_PANE);
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.results.setLayout(this.switcher);
        this.OVERLAY = new OverlayAd();
        this.DUMMY = new ResultPanel(this.OVERLAY);
        JPanel mainScreen = new JPanel(new BorderLayout());
        mainScreen.add((Component)this.DUMMY.getComponent(), "Center");
        this.results.add("dummy", mainScreen);
        this.results.add("tabbedPane", this.TABBED_PANE);
        this.switcher.first(this.results);
        this.MAIN_PANEL.add(this.results);
        this.TABBED_PANE.addMouseListener(this.PANE_LISTENER);
        this.TABBED_PANE.addChangeListener(this.PANE_LISTENER);
        GUIMediator.addThemeObserver(this);
    }

    void setSearchListener(ChangeListener listener) {
        this._activeSearchListener = listener;
    }

    void updateResults() {
        List list = entries;
        synchronized (list) {
            int i = 0;
            while (i < entries.size()) {
                ((ResultPanel)entries.get(i)).refresh();
                ++i;
            }
        }
    }

    ResultPanel addResultTab(GUID guid, SearchInformation info) {
        ResultPanel panel = new ResultPanel(guid, info);
        List list = entries;
        synchronized (list) {
            entries.add(panel);
            this.TABBED_PANE.addTab(info.getQuery(), this.SEL_ICON, panel.getComponent());
            this.TABBED_PANE.setSelectedIndex(entries.size() - 1);
            if (entries.size() > SearchSettings.PARALLEL_SEARCH.getValue()) {
                this.killSearchAtIndex(0);
            }
        }
        GUIMediator.instance().setSearching(true);
        this.OVERLAY.searchPerformed();
        this.switcher.last(this.results);
        this.MAIN_PANEL.revalidate();
        return panel;
    }

    void addQueryResult(byte[] replyGUID, SearchResult line, ResultPanel rp) {
        ResultPanel resultPanel = rp;
        synchronized (resultPanel) {
            if (!rp.matches(new GUID(replyGUID))) {
                throw new IllegalArgumentException("guids don't match");
            }
            rp.add(line);
        }
        int resultPanelIndex = -1;
        List list = entries;
        synchronized (list) {
            resultPanelIndex = entries.indexOf(rp);
            if (resultPanelIndex == -1) {
                return;
            }
            this.TABBED_PANE.setTitleAt(resultPanelIndex, this.titleOf(rp));
        }
    }

    void addChangeListener(ChangeListener listener) {
        this.TABBED_PANE.addChangeListener(listener);
    }

    void addFocusListener(FocusListener listener) {
        this.TABBED_PANE.addFocusListener(listener);
    }

    void showMenu(MouseEvent e) {
        ResultPanel rp = this.getSelectedResultPanel();
        if (rp != null) {
            JPopupMenu menu = rp.createPopupMenu();
            Point p = e.getPoint();
            if (menu != null) {
                try {
                    menu.show(this.MAIN_PANEL, p.x + 1, p.y - 6);
                }
                catch (IllegalComponentStateException icse) {
                    // empty catch block
                }
            }
        }
    }

    ResultPanel getSelectedResultPanel() {
        List list = entries;
        synchronized (list) {
            int i = this.TABBED_PANE.getSelectedIndex();
            if (i == -1) {
                ResultPanel resultPanel = null;
                return resultPanel;
            }
            try {
                ResultPanel resultPanel = (ResultPanel)entries.get(i);
                return resultPanel;
            }
            catch (IndexOutOfBoundsException e) {
                ResultPanel resultPanel = null;
                return resultPanel;
            }
        }
    }

    ResultPanel getResultPanelForGUID(GUID rguid) {
        List list = entries;
        synchronized (list) {
            int i = 0;
            while (i < entries.size()) {
                ResultPanel rp = (ResultPanel)entries.get(i);
                if (rp.matches(rguid)) {
                    ResultPanel resultPanel = rp;
                    return resultPanel;
                }
                ++i;
            }
        }
        return null;
    }

    ResultPanel getPanelAtIndex(int index) {
        List list = entries;
        synchronized (list) {
            ResultPanel resultPanel = (ResultPanel)entries.get(index);
            return resultPanel;
        }
    }

    int getIndexForGUID(GUID rguid) {
        List list = entries;
        synchronized (list) {
            int i = 0;
            while (i < entries.size()) {
                ResultPanel rp = (ResultPanel)entries.get(i);
                if (rp.matches(rguid)) {
                    int n = i;
                    return n;
                }
                ++i;
            }
        }
        return -1;
    }

    int getIndexForPoint(int x, int y) {
        List list = entries;
        synchronized (list) {
            TabbedPaneUI ui = this.TABBED_PANE.getUI();
            int n = ui.tabForCoordinate(this.TABBED_PANE, x, y);
            return n;
        }
    }

    void killSearch() {
        List list = entries;
        synchronized (list) {
            int i = this.TABBED_PANE.getSelectedIndex();
            if (i == -1) {
                return;
            }
            this.killSearchAtIndex(i);
        }
    }

    void killSearchAtIndex(int i) {
        List list = entries;
        synchronized (list) {
            ResultPanel killed = (ResultPanel)entries.remove(i);
            final GUID killedGUID = new GUID(killed.getGUID());
            GUIMediator.removeThemeObserver(killed);
            GUIMediator.instance().schedule(new Runnable(){

                public void run() {
                    RouterService.stopQuery(killedGUID);
                }
            });
            this.TABBED_PANE.removeTabAt(i);
            this.fixIcons();
            SearchMediator.searchKilled(killed);
            if (entries.size() == 0) {
                try {
                    this.switcher.first(this.results);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    // empty catch block
                }
                GUIMediator.instance().setSearching(false);
            } else {
                this.checkToStopLime();
            }
        }
    }

    void browseHostFailed(GUID guid) {
        List list = entries;
        synchronized (list) {
            int i = this.getIndexForGUID(guid);
            if (i > -1) {
                ResultPanel rp = this.getPanelAtIndex(i);
                GUIMediator.showError("ERROR_BROWSE_HOST_FAILED_BEGIN_KEY", rp.getQuery(), "ERROR_BROWSE_HOST_FAILED_END_KEY", QuestionsHandler.BROWSE_HOST_FAILED);
                this.killSearchAtIndex(i);
            }
        }
    }

    void checkToStopLime() {
        long now = System.currentTimeMillis();
        boolean stopLime = true;
        List list = entries;
        synchronized (list) {
            int i = 0;
            while (i < entries.size()) {
                ResultPanel panel = (ResultPanel)entries.get(i);
                stopLime &= panel.isStopped() || panel.calculatePercentage(now) >= 1.0;
                ++i;
            }
        }
        if (stopLime) {
            GUIMediator.instance().setSearching(false);
        }
    }

    void setTabDisplayCount(ResultPanel rp) {
        int i = 0;
        boolean found = false;
        List list = entries;
        synchronized (list) {
            while (i < entries.size()) {
                Object panel = entries.get(i);
                if (panel == rp) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                this.TABBED_PANE.setTitleAt(i, this.titleOf(rp));
            }
        }
    }

    private void fixIcons() {
        List list = entries;
        synchronized (list) {
            int sel = this.TABBED_PANE.getSelectedIndex();
            int i = 0;
            while (i < entries.size()) {
                this.TABBED_PANE.setIconAt(i, i == sel ? this.SEL_ICON : this.KILL_ICON);
                ++i;
            }
        }
    }

    CancelSearchIconProxy getSelectedIcon() {
        int selectedIndex = this.TABBED_PANE.getSelectedIndex();
        if (selectedIndex == -1) {
            return null;
        }
        return (CancelSearchIconProxy)this.TABBED_PANE.getIconAt(selectedIndex);
    }

    ResultPanel getDummyResultPanel() {
        return this.DUMMY;
    }

    JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public void updateTheme() {
        ProgTabUIFactory.extendUI(this.TABBED_PANE);
        this.SEL_ICON.updateTheme();
        this.KILL_ICON.updateTheme();
        this.DUMMY.updateTheme();
        this.OVERLAY.updateTheme();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            ResultPanel curPanel = (ResultPanel)i.next();
            curPanel.updateTheme();
        }
    }

    public void refresh() {
        this.checkToStopLime();
        if (this.TABBED_PANE.isVisible() && this.TABBED_PANE.isShowing()) {
            Rectangle allBounds = this.TABBED_PANE.getBounds();
            Component comp = null;
            try {
                comp = this.TABBED_PANE.getSelectedComponent();
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                // empty catch block
            }
            if (comp != null) {
                Rectangle compBounds = comp.getBounds();
                Rectangle allTabs = new Rectangle(allBounds.x, allBounds.y, allBounds.width, compBounds.y - 1);
                this.TABBED_PANE.repaint(allTabs);
            }
        }
    }

    private String titleOf(ResultPanel rp) {
        int total;
        int current = rp.filteredSources();
        if (current < (total = rp.totalSources())) {
            return rp.getQuery() + " (" + current + "/" + total + ")";
        }
        return rp.getQuery() + " (" + total + ")";
    }

    private class PaneListener
    implements MouseListener,
    ChangeListener {
        private PaneListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (this.tryPopup(e)) {
                return;
            }
            if (SwingUtilities.isLeftMouseButton(e)) {
                CancelSearchIconProxy icon = SearchResultDisplayer.this.getSelectedIcon();
                int x = e.getX();
                int y = e.getY();
                if (icon != null && icon.shouldKill(x, y)) {
                    List list = entries;
                    synchronized (list) {
                        int idx = SearchResultDisplayer.this.getIndexForPoint(x, y);
                        if (idx != -1) {
                            SearchResultDisplayer.this.killSearchAtIndex(idx);
                        }
                    }
                } else {
                    this.stateChanged(null);
                }
            }
        }

        public void mousePressed(MouseEvent e) {
            this.tryPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.tryPopup(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private boolean tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                List list = entries;
                synchronized (list) {
                    int idx = SearchResultDisplayer.this.getIndexForPoint(e.getX(), e.getY());
                    if (idx != -1) {
                        SearchResultDisplayer.this.TABBED_PANE.setSelectedIndex(idx);
                    }
                    SearchResultDisplayer.this.showMenu(e);
                }
                return true;
            }
            return false;
        }

        public void stateChanged(ChangeEvent e) {
            SearchResultDisplayer.this._activeSearchListener.stateChanged(e);
            SearchResultDisplayer.this.fixIcons();
        }
    }
}

