/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.FilterBox;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.Selector;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class SelectorMenu {
    private static final String SELECTOR = "selector";
    private final JPopupMenu MENU = new JPopupMenu();

    SelectorMenu(FilterBox box) {
        SelectionListener listener = new SelectionListener(box);
        List options = box.getMetadataModel().getSelectorOptions();
        String currentSchema = "";
        JMenu currentSchemaMenu = null;
        Iterator i = options.iterator();
        while (i.hasNext()) {
            Selector selector = (Selector)i.next();
            JMenuItem item = this.createItem(box, selector);
            item.addActionListener(listener);
            if (selector.isFieldSelector()) {
                if (!selector.getSchema().equals(currentSchema)) {
                    currentSchema = selector.getSchema();
                    String title = NamedMediaType.getFromDescription(currentSchema).getName();
                    currentSchemaMenu = new JMenu(title);
                    this.MENU.add(currentSchemaMenu);
                }
                currentSchemaMenu.add(item);
                continue;
            }
            this.MENU.add(item);
        }
    }

    JPopupMenu getComponent() {
        return this.MENU;
    }

    private JMenuItem createItem(FilterBox box, Selector selector) {
        String title = selector.getTitle();
        boolean isSelected = box.getSelector().equals(selector);
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(title, isSelected);
        item.putClientProperty(SELECTOR, selector);
        return item;
    }

    private static class SelectionListener
    implements ActionListener {
        private final FilterBox BOX;

        SelectionListener(FilterBox box) {
            this.BOX = box;
        }

        public void actionPerformed(ActionEvent e) {
            JMenuItem item = (JMenuItem)e.getSource();
            Selector selector = (Selector)item.getClientProperty(SelectorMenu.SELECTOR);
            this.BOX.setSelector(selector);
        }
    }
}

