/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.search.SearchResult;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.Comparators;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.SortedMap;
import com.sun.java.util.collections.TreeMap;

public final class TableLineGrouper {
    private SortedMap map = new TreeMap(Comparators.integerComparator());
    private final ApproximateMatcher matcher = new ApproximateMatcher(120);

    public TableLineGrouper() {
        this.matcher.setIgnoreCase(true);
        this.matcher.setIgnoreWhitespace(true);
        this.matcher.setCompareBackwards(true);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public void clear() {
        this.map.clear();
    }

    private int matchHelper(List list, SearchResult line) {
        Assert.that(list != null, "Trying to match null list");
        Assert.that(line != null, "Trying to match null line");
        int j = 0;
        while (j < list.size()) {
            SearchResult line2 = (SearchResult)list.get(j);
            int match = line2.match(line, this.matcher);
            if (match == 0) {
                return j;
            }
            if (match == 2) {
                return -2;
            }
            ++j;
        }
        return -1;
    }

    public SearchResult match(SearchResult line) {
        Integer key = new Integer(line.getSize());
        Iterator iter = this.map.tailMap(key).values().iterator();
        while (iter.hasNext()) {
            List lines = (List)iter.next();
            int ret = this.matchHelper(lines, line);
            if (ret >= 0) {
                return (SearchResult)lines.get(ret);
            }
            if (ret == -2) break;
        }
        SortedMap map = this.map.headMap(key);
        while (true) {
            Integer key2;
            try {
                key2 = (Integer)map.lastKey();
            }
            catch (NoSuchElementException e) {
                break;
            }
            List lines = (List)map.get(key2);
            int ret = this.matchHelper(lines, line);
            if (ret >= 0) {
                return (SearchResult)lines.get(ret);
            }
            if (ret == -2) break;
            map = map.headMap(key2);
        }
        return null;
    }

    public void add(SearchResult line) {
        Assert.that(line != null, "Attempting to add null line");
        Integer key = new Integer(line.getSize());
        List lines = (List)this.map.get(key);
        if (lines == null) {
            lines = new LinkedList();
            this.map.put(key, lines);
        }
        lines.add(line);
    }
}

