/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics;

import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.statistics.StatisticsPane;
import com.limegroup.gnutella.gui.statistics.panes.PaneItem;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class StatisticsPaneManager
implements RefreshListener {
    private final JPanel MAIN_PANEL = new JPanel();
    private final CardLayout CARD_LAYOUT = new CardLayout();
    private final Map STATISTICS_PANE_MAP = new HashMap();
    private String _selectedPaneKey;

    public StatisticsPaneManager() {
        this.MAIN_PANEL.setLayout(this.CARD_LAYOUT);
    }

    public void show(String name) {
        this.CARD_LAYOUT.show(this.MAIN_PANEL, name);
        this._selectedPaneKey = name;
    }

    public JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public PaneItem getFirstDisplayedPaneItem() {
        StatisticsPane pane = (StatisticsPane)this.STATISTICS_PANE_MAP.get(this._selectedPaneKey);
        return pane.getFirstPaneItem();
    }

    public void addPane(StatisticsPane pane) {
        this.MAIN_PANEL.add((Component)pane.getComponent(), pane.getName());
        this.STATISTICS_PANE_MAP.put(pane.getName(), pane);
    }

    public void refresh() {
        Iterator iter = this.STATISTICS_PANE_MAP.values().iterator();
        while (iter.hasNext()) {
            ((StatisticsPane)iter.next()).refresh();
        }
    }

    public void componentResized(ComponentEvent e) {
        Iterator iter = this.STATISTICS_PANE_MAP.values().iterator();
        while (iter.hasNext()) {
            ((StatisticsPane)iter.next()).componentResized(e, this.MAIN_PANEL);
        }
    }
}

