/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.statistics.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.statistics.panes.GraphAxisData;
import com.limegroup.gnutella.gui.statistics.panes.GraphBorder;
import com.limegroup.gnutella.gui.statistics.panes.StatHandler;
import com.limegroup.gnutella.gui.statistics.panes.StatisticDisplayer;
import com.limegroup.gnutella.statistics.NumericalStatistic;
import com.limegroup.gnutella.statistics.Statistic;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IntBuffer;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.text.NumberFormat;
import javax.swing.JComponent;

final class GraphPainter
extends JComponent
implements ComponentListener,
StatisticDisplayer {
    private final int[] X_COORDS = new int[200];
    private GraphBorder _border;
    private final List LIST = new LinkedList();
    private static int _curColor = 0;
    private final Color[] GRAPH_COLORS = new Color[]{CommonUtils.isMacOSX() ? new Color(0, 0, 0) : new Color(255, 255, 255), new Color(0, 153, 0), new Color(255, 102, 255), new Color(255, 255, 0), new Color(255, 51, 0), new Color(51, 153, 204), new Color(255, 153, 0), new Color(153, 0, 51), new Color(51, 0, 153)};
    private static GraphAxisData DEFAULT_AXIS_DATA = new GraphAxisData();
    private final GraphAxisData AXIS_DATA;
    private static final String NAME = GUIMediator.getStringResource("STATS_LEGEND_NAME");
    private static final String CURRENT = GUIMediator.getStringResource("STATS_LEGEND_CURRENT");
    private static final String AVERAGE = GUIMediator.getStringResource("STATS_LEGEND_AVERAGE");
    private static final String MAX = GUIMediator.getStringResource("STATS_LEGEND_MAX");
    private static final String TOTAL = GUIMediator.getStringResource("STATS_LEGEND_TOTAL");
    private static final String COLOR = GUIMediator.getStringResource("STATS_LEGEND_COLOR");
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private double _yPixelFactor = 0.0;
    private static final int NAME_COLUMN_WIDTH = 160;
    private static final int CURRENT_COLUMN_WIDTH = 54;
    private static final int AVERAGE_COLUMN_WIDTH = 54;
    private static final int MAX_COLUMN_WIDTH = 54;
    private static final int TOTAL_COLUMN_WIDTH = 70;
    private static final int COLOR_COLUMN_WIDTH = 44;
    private static final int RECT_WIDTH = 436;
    private static final int COLOR_BOX_WIDTH = 10;

    GraphPainter() {
        this(DEFAULT_AXIS_DATA);
    }

    GraphPainter(GraphAxisData data) {
        this.AXIS_DATA = data;
        this.addComponentListener(this);
    }

    public void registerStatistic(Statistic stat, String displayName) {
        StatHandler handler = new StatHandler(stat, this.GRAPH_COLORS[_curColor], displayName);
        this.LIST.add(handler);
        _curColor = _curColor != this.GRAPH_COLORS.length - 1 ? ++_curColor : 0;
        if (!(stat instanceof NumericalStatistic) && this._border == null) {
            this._border = new GraphBorder(this.AXIS_DATA);
            this.setBorder(this._border);
        }
    }

    public void registerDualStatistic(Statistic stat0, Statistic stat1, String displayName) {
    }

    public void refresh() {
        this.repaint();
    }

    public JComponent getComponent() {
        return this;
    }

    public void setWriteStatsToFile(boolean write) {
        List list = this.LIST;
        synchronized (list) {
            Iterator iter = this.LIST.iterator();
            while (iter.hasNext()) {
                Statistic curStat = ((StatHandler)iter.next()).getStat();
                curStat.setWriteStatToFile(write);
            }
        }
    }

    protected void paintComponent(Graphics g) {
        try {
            this.paintGraph(g);
        }
        catch (Throwable t) {
            GUIMediator.showInternalError(t);
        }
    }

    private void paintGraph(Graphics g) {
        super.paintComponent(g);
        Color oldColor = g.getColor();
        Font oldFont = g.getFont();
        Font tempFont = new Font(oldFont.getName(), 0, oldFont.getSize() - 2);
        g.setFont(tempFont);
        FontMetrics m = g.getFontMetrics();
        int rowHeight = m.getHeight() + 1;
        int rowBase = m.getLeading() / 2 + m.getMaxAscent();
        int yBoxColor = (rowHeight - 10) / 2;
        boolean yOrig = false;
        int xName = this.getWidth() - 436 - 10;
        int xCurrent = xName + 160;
        int xAverage = xCurrent + 54;
        int xMax = xAverage + 54;
        int xTotal = xMax + 54;
        int xColor = xTotal + 70;
        int margin = 3;
        int xBoxColor = xColor + 17;
        int y = 0;
        g.drawString(NAME, xName + 3, y + rowBase);
        g.drawString(CURRENT, xCurrent + 3, y + rowBase);
        g.drawString(AVERAGE, xAverage + 3, y + rowBase);
        g.drawString(MAX, xMax + 3, y + rowBase);
        g.drawString(TOTAL, xTotal + 3, y + rowBase);
        g.drawString(COLOR, xColor + 3, y + rowBase);
        g.drawLine(xName, y += rowHeight, xName + 436, y);
        ++y;
        Iterator iter = this.LIST.iterator();
        while (iter.hasNext()) {
            String current;
            StatHandler handler = (StatHandler)iter.next();
            Statistic stat = handler.getStat();
            int[] Y_COORDS = handler.getData();
            IntBuffer buf = stat.getStatHistory();
            g.setColor(handler.getColor());
            if (!(stat instanceof NumericalStatistic)) {
                IntBuffer intBuffer = buf;
                synchronized (intBuffer) {
                    int j = 0;
                    while (j < buf.size()) {
                        int yVal = (int)((double)buf.get(j) * this._yPixelFactor / (double)this.AXIS_DATA.getYScale());
                        Y_COORDS[j] = this.getHeight() - GraphBorder.getOffset() - yVal;
                        ++j;
                    }
                }
                g.drawPolyline(this.X_COORDS, Y_COORDS, Y_COORDS.length);
            }
            IntBuffer intBuffer = buf;
            synchronized (intBuffer) {
                current = NUMBER_FORMAT.format((double)buf.get(Y_COORDS.length - 1) / (double)this.AXIS_DATA.getYScale());
            }
            g.fillRect(xBoxColor, y + yBoxColor, 10, 10);
            g.setColor(oldColor);
            g.drawRect(xBoxColor - 1, y + yBoxColor - 1, 11, 11);
            String name = handler.getDisplayName();
            NUMBER_FORMAT.setMaximumFractionDigits(3);
            String average = NUMBER_FORMAT.format(stat.getAverage());
            String max = NUMBER_FORMAT.format(stat.getMax());
            NUMBER_FORMAT.setMaximumFractionDigits(1);
            String total = NUMBER_FORMAT.format(stat.getTotal());
            g.drawString(name, xName + 3, y + rowBase);
            g.drawString(current, xCurrent + 3, y + rowBase);
            g.drawString(average, xAverage + 3, y + rowBase);
            g.drawString(max, xMax + 3, y + rowBase);
            g.drawString(total, xTotal + 3, y + rowBase);
            y += rowHeight;
        }
        g.drawRect(xName, 0, 436, y - 0);
        g.drawLine(xCurrent, 0, xCurrent, y);
        g.drawLine(xAverage, 0, xAverage, y);
        g.drawLine(xMax, 0, xMax, y);
        g.drawLine(xTotal, 0, xTotal, y);
        g.drawLine(xColor, 0, xColor, y);
        g.setFont(oldFont);
    }

    public void componentResized(ComponentEvent e) {
        double xPixelFactor = (double)(this.getWidth() - GraphBorder.getOffset() - 30) / (double)this.AXIS_DATA.getTotalXValues();
        double curCoord = GraphBorder.getOffset();
        int i = 0;
        while (i < this.X_COORDS.length) {
            this.X_COORDS[i] = (int)curCoord;
            ++i;
            curCoord += xPixelFactor;
        }
        this._yPixelFactor = (double)(this.getHeight() - GraphBorder.getOffset() - 60) / (double)this.AXIS_DATA.getTotalYValues();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }
}

