/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.tables.ChatRenderer;
import com.limegroup.gnutella.gui.tables.ColorRenderer;
import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.ColumnSelectionMenu;
import com.limegroup.gnutella.gui.tables.ComponentMediator;
import com.limegroup.gnutella.gui.tables.DataLine;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.DefaultColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DefaultMouseListener;
import com.limegroup.gnutella.gui.tables.HeaderMouseListener;
import com.limegroup.gnutella.gui.tables.HeaderMouseObserver;
import com.limegroup.gnutella.gui.tables.IconAndNameRenderer;
import com.limegroup.gnutella.gui.tables.IconRenderer;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.ProgressBarRenderer;
import com.limegroup.gnutella.gui.tables.RemoveListener;
import com.limegroup.gnutella.gui.tables.SelectionListener;
import com.limegroup.gnutella.gui.tables.TableSettings;
import com.limegroup.gnutella.settings.ThemeFileHandler;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Comparable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public abstract class AbstractTableMediator
implements ComponentMediator,
HeaderMouseObserver,
ThemeObserver {
    protected final String ID;
    protected PaddedPanel MAIN_PANEL;
    protected DataLineModel DATA_MODEL;
    protected LimeJTable TABLE;
    protected ButtonRow BUTTON_ROW;
    public ActionListener REMOVE_LISTENER;
    public MouseListener DEFAULT_LISTENER;
    public MouseInputListener HEADER_LISTENER;
    public ListSelectionListener SELECTION_LISTENER;
    public TableSettings SETTINGS;
    protected static final TableCellRenderer PROGRESS_BAR_RENDERER = new ProgressBarRenderer();
    protected static final TableCellRenderer CHAT_RENDERER = new ChatRenderer();
    protected static final TableCellRenderer COLOR_RENDERER = new ColorRenderer();
    protected static final TableCellRenderer ICON_RENDERER = new IconRenderer();
    protected static final TableCellRenderer ICON_AND_NAME_RENDERER = new IconAndNameRenderer();
    protected static final Dimension ZERO_DIMENSION = new Dimension(0, 0);
    protected Resorter RESORTER = new Resorter();
    protected JComponent TABLE_PANE;
    protected JScrollPane SCROLL_PANE;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ProgressBarHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ChatHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$ColoredCell;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$tables$IconAndNameHolder;
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractTableMediator(String id) {
        this.ID = id;
        this.updateSplashScreen();
        this.buildSettings();
        this.buildListeners();
        this.setupConstants();
        Assert.that(this.DATA_MODEL != null, "DATA_MODEL not set.");
        Assert.that(this.TABLE != null, "TABLE not set.");
        this.setupTable();
        this.addListeners();
        this.setDefaultRenderers();
        this.setDefaultEditors();
        this.setupMainPanel();
        this.setupTableHeaders();
        this.handleNoSelection();
    }

    protected abstract void updateSplashScreen();

    protected void buildSettings() {
        this.SETTINGS = new TableSettings(this.ID);
    }

    protected abstract void setupConstants();

    protected void buildListeners() {
        this.DEFAULT_LISTENER = new DefaultMouseListener(this);
        this.SELECTION_LISTENER = new SelectionListener(this);
        this.HEADER_LISTENER = new HeaderMouseListener(this);
        this.REMOVE_LISTENER = new RemoveListener(this);
    }

    protected void addListeners() {
        this.TABLE.addMouseListener(this.DEFAULT_LISTENER);
        this.TABLE.getSelectionModel().addListSelectionListener(this.SELECTION_LISTENER);
        this.TABLE.getTableHeader().addMouseListener(this.HEADER_LISTENER);
        this.TABLE.getTableHeader().addMouseMotionListener(this.HEADER_LISTENER);
    }

    protected void setupTable() {
        this.TABLE.setRowHeight(this.TABLE.getRowHeight() + 1);
        this.TABLE.setShowGrid(false);
        this.TABLE.setIntercellSpacing(ZERO_DIMENSION);
        this.TABLE.setColumnSelectionAllowed(false);
        this.TABLE.setTableSettings(this.SETTINGS);
        this.TABLE.setAutoResizeMode(1);
    }

    protected void setDefaultRenderers() {
        this.TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$tables$ProgressBarHolder == null ? (class$com$limegroup$gnutella$gui$tables$ProgressBarHolder = AbstractTableMediator.class$("com.limegroup.gnutella.gui.tables.ProgressBarHolder")) : class$com$limegroup$gnutella$gui$tables$ProgressBarHolder, PROGRESS_BAR_RENDERER);
        this.TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$tables$ChatHolder == null ? (class$com$limegroup$gnutella$gui$tables$ChatHolder = AbstractTableMediator.class$("com.limegroup.gnutella.gui.tables.ChatHolder")) : class$com$limegroup$gnutella$gui$tables$ChatHolder, CHAT_RENDERER);
        this.TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$tables$ColoredCell == null ? (class$com$limegroup$gnutella$gui$tables$ColoredCell = AbstractTableMediator.class$("com.limegroup.gnutella.gui.tables.ColoredCell")) : class$com$limegroup$gnutella$gui$tables$ColoredCell, COLOR_RENDERER);
        this.TABLE.setDefaultRenderer(class$javax$swing$Icon == null ? (class$javax$swing$Icon = AbstractTableMediator.class$("javax.swing.Icon")) : class$javax$swing$Icon, ICON_RENDERER);
        this.TABLE.setDefaultRenderer(class$com$limegroup$gnutella$gui$tables$IconAndNameHolder == null ? (class$com$limegroup$gnutella$gui$tables$IconAndNameHolder = AbstractTableMediator.class$("com.limegroup.gnutella.gui.tables.IconAndNameHolder")) : class$com$limegroup$gnutella$gui$tables$IconAndNameHolder, ICON_AND_NAME_RENDERER);
    }

    protected void setDefaultEditors() {
    }

    protected void setupMainPanel() {
        if (this.MAIN_PANEL != null) {
            this.MAIN_PANEL.add(this.getScrolledTablePane());
            if (this.BUTTON_ROW != null) {
                this.MAIN_PANEL.add(this.BUTTON_ROW);
            }
            this.MAIN_PANEL.setMinimumSize(ZERO_DIMENSION);
        }
    }

    protected void setupTableHeaders() {
        ColumnPreferenceHandler cph = this.createDefaultColumnPreferencesHandler();
        cph.setWidths();
        cph.setOrder();
        cph.setVisibility();
        this.TABLE.setColumnPreferenceHandler(cph);
    }

    protected ColumnPreferenceHandler createDefaultColumnPreferencesHandler() {
        return new DefaultColumnPreferenceHandler(this.TABLE);
    }

    protected JComponent getScrolledTablePane() {
        if (this.TABLE_PANE != null) {
            return this.TABLE_PANE;
        }
        JPanel tablePane = new JPanel();
        tablePane.setLayout(new BoxLayout(tablePane, 1));
        this.SCROLL_PANE = new JScrollPane(this.TABLE);
        JPanel corner = new JPanel();
        corner.setBackground(this.TABLE.getTableHeader().getBackground());
        corner.setBorder(BorderFactory.createBevelBorder(0));
        this.SCROLL_PANE.setCorner("UPPER_RIGHT_CORNER", corner);
        tablePane.add(this.SCROLL_PANE);
        this.TABLE_PANE = tablePane;
        this.updateTheme();
        return tablePane;
    }

    public void updateTheme() {
        Color tableColor = ThemeFileHandler.TABLE_BACKGROUND_COLOR.getValue();
        if (this.TABLE_PANE == null) {
            return;
        }
        this.TABLE_PANE.setBackground(tableColor);
        this.TABLE.setBackground(tableColor);
        this.TABLE.setOpaque(true);
        this.SCROLL_PANE.getViewport().setBackground(tableColor);
    }

    public void add(Object o) {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        boolean inView = this.TABLE.isSelectionVisible();
        int addedAt = this.SETTINGS.REAL_TIME_SORT.getValue() && this.DATA_MODEL.isSorted() ? this.DATA_MODEL.addSorted(o) : this.DATA_MODEL.add(o);
        this.fixSelection(addedAt, inView);
    }

    public void addUnsorted(Object o) {
        if (this.TABLE.isEditing()) {
            TableCellEditor editor = this.TABLE.getCellEditor();
            editor.cancelCellEditing();
        }
        boolean inView = this.TABLE.isSelectionVisible();
        int addedAt = this.DATA_MODEL.add(o);
        this.fixSelection(addedAt, inView);
    }

    protected void fixSelection(int addedAt, boolean inView) {
        if (addedAt >= 0 && addedAt < this.DATA_MODEL.getRowCount()) {
            this.TABLE.removeRowSelectionInterval(addedAt, addedAt);
            int selected = this.TABLE.getSelectedRow();
            if (selected >= 0 && selected < this.DATA_MODEL.getRowCount()) {
                this.TABLE.addRowSelectionInterval(selected, selected);
                if (inView) {
                    this.TABLE.ensureRowVisible(selected);
                }
            }
        }
    }

    public void remove(Object o) {
        int idx = this.DATA_MODEL.getRow(o);
        if (idx != -1) {
            this.removeRow(idx);
        }
    }

    public void removeRow(int row) {
        this.DATA_MODEL.remove(row);
    }

    public void refresh() {
        if (this.TABLE.isShowing()) {
            this.doRefresh();
            this.resort();
        }
    }

    protected void doRefresh() {
        this.DATA_MODEL.refresh();
    }

    public void update(Object o) {
        this.DATA_MODEL.update(o);
        this.resort();
    }

    public void resort() {
        this.RESORTER.doResort(false);
    }

    public void forceResort() {
        this.RESORTER.doResort(true);
    }

    public JComponent getComponent() {
        return this.MAIN_PANEL;
    }

    public void removeSelection() {
        int[] sel = this.TABLE.getSelectedRows();
        Arrays.sort(sel);
        int counter = sel.length - 1;
        while (counter >= 0) {
            int i = sel[counter];
            this.DATA_MODEL.remove(i);
            --counter;
        }
        this.clearSelection();
    }

    protected JPopupMenu createColumnSelectionMenu() {
        return new ColumnSelectionMenu(this.TABLE).getComponent();
    }

    public void handleRightMouseClick(MouseEvent e) {
        Point p = e.getPoint();
        int row = this.TABLE.rowAtPoint(p);
        if (row < 0) {
            return;
        }
        if (!this.TABLE.getSelectionModel().isSelectedIndex(row)) {
            this.TABLE.getSelectionModel().setSelectionInterval(row, row);
        }
    }

    public void handlePopupMenu(MouseEvent e) {
        Point p = e.getPoint();
        this.handleRightMouseClick(e);
        JPopupMenu menu = this.createPopupMenu();
        if (menu != null) {
            try {
                menu.show(this.TABLE, p.x + 1, p.y - 6);
            }
            catch (IllegalComponentStateException icse) {
                // empty catch block
            }
        }
    }

    public void handleHeaderColumnLeftClick(Point p) {
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        int c = this.TABLE.convertColumnIndexToModel(col);
        int oldC = this.DATA_MODEL.getSortColumn();
        if (c != -1) {
            this.TABLE.sortColumn(c, this.DATA_MODEL.getSortColumn() != c || !this.DATA_MODEL.isSortAscending());
            this.sortAndMaintainSelection(c);
            th.repaint(th.getHeaderRect(col));
            if (oldC != -1 && oldC != c) {
                int oldCol = this.TABLE.convertColumnIndexToView(oldC);
                th.repaint(th.getHeaderRect(oldCol));
            }
        }
    }

    public void handleHeaderPopupMenu(Point p) {
        this.createColumnSelectionMenu().show(this.TABLE.getTableHeader(), p.x + 1, p.y - 6);
    }

    public void handleHeaderColumnPressed(Point p) {
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        int c = this.TABLE.convertColumnIndexToModel(col);
        if (c != -1) {
            this.TABLE.setPressedColumnIndex(c);
            th.repaint(th.getHeaderRect(col));
        }
    }

    public void handleHeaderColumnReleased(Point p) {
        this.TABLE.setPressedColumnIndex(-1);
        JTableHeader th = this.TABLE.getTableHeader();
        int col = th.columnAtPoint(p);
        if (col != -1) {
            th.repaint(th.getHeaderRect(col));
        }
    }

    public void setButtonEnabled(int buttonIdx, boolean enabled) {
        if (this.BUTTON_ROW != null) {
            this.BUTTON_ROW.setButtonEnabled(buttonIdx, enabled);
        }
    }

    public int getSize() {
        return this.DATA_MODEL.getRowCount();
    }

    public void clearTable() {
        this.DATA_MODEL.clear();
        this.handleNoSelection();
    }

    protected void clearSelection() {
        this.TABLE.clearSelection();
        this.handleNoSelection();
    }

    protected void sortAndMaintainSelection(int columnToSort) {
        int[] rows = this.TABLE.getSelectedRows();
        DataLine[] dls = new DataLine[rows.length];
        DataLine inView = null;
        int i = 0;
        while (i < rows.length) {
            dls[i] = this.DATA_MODEL.get(rows[i]);
            if (inView == null && this.TABLE.isRowVisible(rows[i])) {
                inView = dls[i];
            }
            ++i;
        }
        if (columnToSort == -1) {
            this.DATA_MODEL.resort();
        } else {
            this.DATA_MODEL.sort(columnToSort);
        }
        int i2 = 0;
        while (i2 < rows.length) {
            int sel = this.DATA_MODEL.getRow(dls[i2]);
            this.TABLE.addRowSelectionInterval(sel, sel);
            if (inView == dls[i2]) {
                this.TABLE.ensureRowVisible(sel);
                inView = null;
            }
            ++i2;
        }
    }

    protected abstract JPopupMenu createPopupMenu();

    static int compare(Object o1, Object o2) {
        double dbl;
        int retval = o1 == null && o2 == null ? 0 : (o1 == null ? -1 : (o2 == null ? 1 : (o1.getClass() == (class$java$lang$String == null ? (class$java$lang$String = AbstractTableMediator.class$("java.lang.String")) : class$java$lang$String) ? StringUtils.compareFullPrimary((String)o1, (String)o2) : (o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : (o1 instanceof Integer ? (Integer)o1 - (Integer)o2 : (o1 instanceof Boolean ? (o1.equals(o2) ? 0 : (o1.equals(Boolean.TRUE) ? 1 : -1)) : (o1 instanceof Double || o1 instanceof Float ? ((dbl = ((Number)o1).doubleValue() - ((Number)o2).doubleValue()) > 0.0 ? 1 : (dbl < 0.0 ? -1 : 0)) : (o1 instanceof Number ? ((Number)o1).intValue() - ((Number)o2).intValue() : 0))))))));
        return retval;
    }

    public abstract void handleNoSelection();

    public abstract void handleSelection(int var1);

    public abstract void handleMouseDoubleClick(MouseEvent var1);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected final class Resorter
    implements Runnable {
        private boolean active = false;
        private boolean force = false;

        protected Resorter() {
        }

        public void doResort(boolean isForce) {
            if (!this.active && AbstractTableMediator.this.SETTINGS.REAL_TIME_SORT.getValue() && AbstractTableMediator.this.TABLE.isShowing()) {
                this.active = true;
                SwingUtilities.invokeLater(this);
            }
            this.force |= isForce;
        }

        public void run() {
            try {
                if (!AbstractTableMediator.this.TABLE.isEditing() && (this.force || AbstractTableMediator.this.DATA_MODEL.needsResort())) {
                    AbstractTableMediator.this.sortAndMaintainSelection(-1);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.active = false;
            this.force = false;
        }
    }
}

