/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.ThemeObserver;
import com.limegroup.gnutella.gui.tables.ColoredCell;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class ColorRenderer
extends JComponent
implements TableCellRenderer,
ThemeObserver {
    private Map otherRenderers = new HashMap();

    public ColorRenderer() {
        GUIMediator.addThemeObserver(this);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSel, boolean hasFocus, int row, int column) {
        Object val;
        Color clr;
        ColoredCell cc = (ColoredCell)value;
        if (cc != null) {
            clr = cc.getColor();
            val = cc.getValue();
        } else {
            clr = null;
            val = "";
        }
        if (val == null) {
            val = "";
        }
        TableCellRenderer tcr = table.getDefaultRenderer(val.getClass());
        tcr = this.getCachedOrNewRenderer(tcr);
        Component renderer = tcr.getTableCellRendererComponent(table, value, isSel, hasFocus, row, column);
        if (!isSel && !hasFocus) {
            renderer.setForeground(clr);
        }
        return renderer;
    }

    public void updateTheme() {
        Iterator i = this.otherRenderers.values().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof ThemeObserver)) continue;
            ((ThemeObserver)o).updateTheme();
        }
    }

    public void updateUI() {
        Iterator i = this.otherRenderers.values().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof JComponent)) continue;
            ((JComponent)o).updateUI();
        }
    }

    private TableCellRenderer getCachedOrNewRenderer(TableCellRenderer tcr) {
        TableCellRenderer renderer = (TableCellRenderer)this.otherRenderers.get(tcr);
        if (renderer == null) {
            Class<?> rendererClass = tcr.getClass();
            try {
                renderer = (TableCellRenderer)rendererClass.newInstance();
            }
            catch (IllegalAccessException e) {
                Assert.that(false, e.getMessage());
            }
            catch (InstantiationException e) {
                Assert.that(false, e.getMessage());
            }
            catch (ClassCastException e) {
                Assert.that(false, e.getMessage());
            }
            this.otherRenderers.put(tcr, renderer);
        }
        return renderer;
    }
}

