/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.tables;

import com.limegroup.gnutella.gui.tables.ColumnPreferenceHandler;
import com.limegroup.gnutella.gui.tables.DataLineModel;
import com.limegroup.gnutella.gui.tables.LastColumnException;
import com.limegroup.gnutella.gui.tables.LimeJTable;
import com.limegroup.gnutella.gui.tables.LimeTableColumn;
import com.limegroup.gnutella.settings.TablesHandler;
import com.sun.java.util.collections.Iterator;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableColumnModel;

public class DefaultColumnPreferenceHandler
implements ColumnPreferenceHandler,
TableColumnModelListener,
MouseListener {
    protected final LimeJTable table;
    protected boolean marginChanged;

    public DefaultColumnPreferenceHandler(LimeJTable t) {
        this.table = t;
        this.startListening();
    }

    public void columnAdded(TableColumnModelEvent e) {
        LimeTableColumn ltc = this.getToColumn(e);
        this.setVisibility(ltc, true);
        TableColumnModel tcm = this.table.getColumnModel();
        int order = this.getOrder(ltc);
        int current = tcm.getColumnIndex(ltc.getId());
        int max = tcm.getColumnCount();
        if (order != current) {
            this.stopListening();
            order = Math.min(order, max - 1);
            tcm.moveColumn(current, order);
            current = order + 1;
            while (current < max) {
                ltc = (LimeTableColumn)tcm.getColumn(current);
                this.setOrder(ltc, current);
                ++current;
            }
            Iterator i = this.table.getHiddenColumns();
            while (i.hasNext()) {
                ltc = (LimeTableColumn)i.next();
                current = this.getOrder(ltc);
                if (current <= order) continue;
                this.setOrder(ltc, current + 1);
            }
            this.startListening();
        }
        this.save();
    }

    public void columnMarginChanged(ChangeEvent e) {
        if (this.table.getTableHeader().getResizingColumn() == null) {
            return;
        }
        this.marginChanged = true;
    }

    public void columnMoved(TableColumnModelEvent e) {
        if (e.getFromIndex() == e.getToIndex()) {
            return;
        }
        LimeTableColumn from = this.getFromColumn(e);
        LimeTableColumn to = this.getToColumn(e);
        this.setOrder(from, e.getFromIndex());
        this.setOrder(to, e.getToIndex());
        this.save();
    }

    public void columnRemoved(TableColumnModelEvent e) {
        LimeTableColumn ltc;
        TableColumnModel tcm = this.table.getColumnModel();
        int i = 0;
        while (i < tcm.getColumnCount()) {
            ltc = (LimeTableColumn)tcm.getColumn(i);
            this.setOrder(ltc, i);
            ++i;
        }
        ltc = this.table.getLastRemovedColumn();
        this.setVisibility(ltc, false);
        int order = this.getOrder(ltc);
        Iterator i2 = this.table.getHiddenColumns();
        while (i2.hasNext()) {
            ltc = (LimeTableColumn)i2.next();
            int current = this.getOrder(ltc);
            if (current <= order) continue;
            this.setOrder(ltc, current - 1);
        }
        this.save();
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (!this.marginChanged) {
            return;
        }
        TableColumnModel tcm = this.table.getColumnModel();
        int i = 0;
        while (i < tcm.getColumnCount()) {
            LimeTableColumn ltc = (LimeTableColumn)tcm.getColumn(i);
            this.setWidth(ltc, ltc.getWidth());
            ++i;
        }
        this.marginChanged = false;
        this.save();
    }

    public void revertToDefault() {
        this.stopListening();
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        int i = 0;
        while (i < dlm.getColumnCount()) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            this.setVisibility(ltc, ltc.getDefaultVisibility());
            this.setOrder(ltc, ltc.getDefaultOrder());
            this.setWidth(ltc, ltc.getDefaultWidth());
            try {
                if (!this.table.isColumnVisible(ltc.getId())) {
                    this.table.setColumnVisible(ltc.getId(), true);
                }
            }
            catch (LastColumnException impossible) {
                // empty catch block
            }
            ++i;
        }
        TableColumnModel tcm = this.table.getColumnModel();
        int i2 = 0;
        while (i2 < dlm.getColumnCount()) {
            LimeTableColumn ltc = dlm.getTableColumn(i2);
            int order = this.getOrder(ltc);
            int current = tcm.getColumnIndex(ltc.getId());
            if (current != order) {
                tcm.moveColumn(current, order);
            }
            ltc.setPreferredWidth(ltc.getDefaultWidth());
            ++i2;
        }
        int i3 = 0;
        while (i3 < dlm.getColumnCount()) {
            LimeTableColumn ltc = dlm.getTableColumn(i3);
            boolean wantVis = this.getVisibility(ltc);
            try {
                if (!wantVis) {
                    this.table.setColumnVisible(ltc.getId(), false);
                }
            }
            catch (LastColumnException ignored) {
                // empty catch block
            }
            ++i3;
        }
        this.startListening();
        this.save();
    }

    public boolean isDefault() {
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        int i = 0;
        while (i < dlm.getColumnCount()) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            if (!this.isDefaultWidth(ltc)) {
                return false;
            }
            if (!this.isDefaultOrder(ltc)) {
                return false;
            }
            if (!this.isDefaultVisibility(ltc)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setWidths() {
        this.stopListening();
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        int i = 0;
        while (i < dlm.getColumnCount()) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            int width = this.getWidth(ltc);
            if (width != -1) {
                ltc.setPreferredWidth(width);
            }
            ++i;
        }
        this.startListening();
    }

    public void setOrder() {
        this.stopListening();
        boolean changed = false;
        TableColumnModel tcm = this.table.getColumnModel();
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        int max = dlm.getColumnCount();
        int i = 0;
        while (i < max) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            int order = this.getOrder(ltc);
            if (this.table.isColumnVisible(ltc.getId())) {
                int current = tcm.getColumnIndex(ltc.getId());
                if (order >= max) {
                    order = max - 1;
                    this.setOrder(ltc, order);
                    changed = true;
                }
                if (current != order) {
                    tcm.moveColumn(current, order);
                }
            }
            ++i;
        }
        if (changed) {
            TablesHandler.instance().save();
        }
        this.startListening();
    }

    public void setVisibility() {
        this.stopListening();
        DataLineModel dlm = (DataLineModel)this.table.getModel();
        int i = 0;
        while (i < dlm.getColumnCount()) {
            LimeTableColumn ltc = dlm.getTableColumn(i);
            boolean wantVis = this.getVisibility(ltc);
            boolean isVis = this.table.isColumnVisible(ltc.getId());
            try {
                if (wantVis && !isVis) {
                    this.table.setColumnVisible(ltc.getId(), true);
                } else if (!wantVis && isVis) {
                    this.table.setColumnVisible(ltc.getId(), false);
                }
            }
            catch (LastColumnException ee) {
                // empty catch block
            }
            ++i;
        }
        this.startListening();
    }

    protected void save() {
        TablesHandler.instance().save();
    }

    protected void startListening() {
        this.table.getTableHeader().addMouseListener(this);
        this.table.getColumnModel().addColumnModelListener(this);
    }

    protected void stopListening() {
        this.table.getTableHeader().removeMouseListener(this);
        this.table.getColumnModel().removeColumnModelListener(this);
    }

    protected LimeTableColumn getToColumn(TableColumnModelEvent e) {
        return (LimeTableColumn)this.table.getColumnModel().getColumn(e.getToIndex());
    }

    protected LimeTableColumn getFromColumn(TableColumnModelEvent e) {
        return (LimeTableColumn)this.table.getColumnModel().getColumn(e.getFromIndex());
    }

    protected void setVisibility(LimeTableColumn col, boolean vis) {
        TablesHandler.getVisibility(col.getId(), col.getDefaultVisibility()).setValue(vis);
    }

    protected void setOrder(LimeTableColumn col, int order) {
        TablesHandler.getOrder(col.getId(), col.getDefaultOrder()).setValue(order);
    }

    protected void setWidth(LimeTableColumn col, int width) {
        TablesHandler.getWidth(col.getId(), col.getDefaultWidth()).setValue(width);
    }

    protected boolean getVisibility(LimeTableColumn col) {
        return TablesHandler.getVisibility(col.getId(), col.getDefaultVisibility()).getValue();
    }

    protected int getOrder(LimeTableColumn col) {
        return TablesHandler.getOrder(col.getId(), col.getDefaultOrder()).getValue();
    }

    protected int getWidth(LimeTableColumn col) {
        return TablesHandler.getWidth(col.getId(), col.getDefaultWidth()).getValue();
    }

    protected boolean isDefaultVisibility(LimeTableColumn col) {
        return TablesHandler.getVisibility(col.getId(), col.getDefaultVisibility()).isDefault();
    }

    protected boolean isDefaultOrder(LimeTableColumn col) {
        return TablesHandler.getOrder(col.getId(), col.getDefaultOrder()).isDefault();
    }

    protected boolean isDefaultWidth(LimeTableColumn col) {
        return TablesHandler.getWidth(col.getId(), col.getDefaultWidth()).isDefault();
    }
}

